/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.cache;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.cache.CachingResourceData;
import org.pentaho.reporting.libraries.resourceloader.cache.DefaultResourceDataCacheEntry;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceDataCache;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceDataCacheEntry;

public class NullResourceDataCache
implements ResourceDataCache {
    private Reference lastEntry;

    public ResourceData put(ResourceManager caller, ResourceData data) throws ResourceLoadingException {
        ResourceData retval = CachingResourceData.createCached(data);
        this.lastEntry = new WeakReference<DefaultResourceDataCacheEntry>(new DefaultResourceDataCacheEntry(retval, caller));
        return retval;
    }

    public ResourceDataCacheEntry get(ResourceKey key) {
        if (this.lastEntry != null) {
            ResourceDataCacheEntry entry = (ResourceDataCacheEntry)this.lastEntry.get();
            if (entry != null && key.equals(entry.getData().getKey())) {
                return entry;
            }
            this.lastEntry = null;
        }
        return null;
    }

    public void remove(ResourceData data) {
    }

    public void clear() {
        this.lastEntry = null;
    }

    public void shutdown() {
        this.lastEntry = null;
    }
}

