/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#pragma once

#include "HTMLElement.h"
#include "JSDOMWrapper.h"
#include "JSElement.h"

namespace WebCore {

class WEBCORE_EXPORT JSHTMLElement : public JSElement {
public:
    using Base = JSElement;
    using DOMWrapped = HTMLElement;
    static JSHTMLElement* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, Ref<HTMLElement>&& impl)
    {
        JSHTMLElement* ptr = new (NotNull, JSC::allocateCell<JSHTMLElement>(globalObject->vm())) JSHTMLElement(structure, *globalObject, WTFMove(impl));
        ptr->finishCreation(globalObject->vm());
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::VM&, JSDOMGlobalObject&);
    static JSC::JSObject* prototype(JSC::VM&, JSDOMGlobalObject&);
    static HTMLElement* toWrapped(JSC::VM&, JSC::JSValue);

    DECLARE_INFO;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::JSType(JSElementType), StructureFlags), info(), JSC::NonArray);
    }

    JSC::JSScope* pushEventHandlerScope(JSC::JSGlobalObject*, JSC::JSScope*) const;

    static JSC::JSValue getConstructor(JSC::VM&, const JSC::JSGlobalObject*);
    static void forEachEventHandlerContentAttribute(const Function<void(const AtomString& attributeName, const AtomString& eventName)>&);

    mutable JSC::WriteBarrier<JSC::Unknown> m_attributeStyleMap;
    template<typename, JSC::SubspaceAccess mode> static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        if constexpr (mode == JSC::SubspaceAccess::Concurrently)
            return nullptr;
        return subspaceForImpl(vm);
    }
    static JSC::GCClient::IsoSubspace* subspaceForImpl(JSC::VM& vm);
    DECLARE_VISIT_CHILDREN;

    static void analyzeHeap(JSCell*, JSC::HeapAnalyzer&);
    HTMLElement& wrapped() const
    {
        return static_cast<HTMLElement&>(Base::wrapped());
    }
    Ref<HTMLElement> protectedWrapped() const
    {
        return wrapped();
    }
protected:
    JSHTMLElement(JSC::Structure*, JSDOMGlobalObject&, Ref<HTMLElement>&&);

    DECLARE_DEFAULT_FINISH_CREATION;
};

WEBCORE_EXPORT JSC::JSValue toJS(JSC::JSGlobalObject*, JSDOMGlobalObject*, HTMLElement&);
inline JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, HTMLElement* impl) { return impl ? toJS(lexicalGlobalObject, globalObject, *impl) : JSC::jsNull(); }
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject*, Ref<HTMLElement>&&);
inline JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, RefPtr<HTMLElement>&& impl) { return impl ? toJSNewlyCreated(lexicalGlobalObject, globalObject, impl.releaseNonNull()) : JSC::jsNull(); }

// Custom constructor
JSC::EncodedJSValue constructJSHTMLElement(JSC::JSGlobalObject*, JSC::CallFrame&);

template<> struct JSDOMWrapperConverterTraits<HTMLElement> {
    using WrapperClass = JSHTMLElement;
    using ToWrappedReturnType = HTMLElement*;
};

} // namespace WebCore
