// This file is automatically generated from CSSProperties.json by the process-css-properties.py script. Do not edit it.

#pragma once

#include <array>
#include <wtf/HashFunctions.h>
#include <wtf/HashTraits.h>

namespace WebCore {

class Settings;

enum CSSPropertyID : uint16_t {
    CSSPropertyInvalid = 0,
    CSSPropertyCustom = 1,
    CSSPropertyColorScheme = 2,
    CSSPropertyWritingMode = 3,
    CSSPropertyWebkitRubyPosition = 4,
    CSSPropertyColor = 5,
    CSSPropertyDirection = 6,
    CSSPropertyDisplay = 7,
    CSSPropertyFontFamily = 8,
    CSSPropertyFontFeatureSettings = 9,
    CSSPropertyFontKerning = 10,
    CSSPropertyFontOpticalSizing = 11,
    CSSPropertyFontPalette = 12,
    CSSPropertyFontSize = 13,
    CSSPropertyFontSizeAdjust = 14,
    CSSPropertyFontStretch = 15,
    CSSPropertyFontStyle = 16,
    CSSPropertyFontSynthesisSmallCaps = 17,
    CSSPropertyFontSynthesisStyle = 18,
    CSSPropertyFontSynthesisWeight = 19,
    CSSPropertyFontVariantAlternates = 20,
    CSSPropertyFontVariantCaps = 21,
    CSSPropertyFontVariantEastAsian = 22,
    CSSPropertyFontVariantEmoji = 23,
    CSSPropertyFontVariantLigatures = 24,
    CSSPropertyFontVariantNumeric = 25,
    CSSPropertyFontVariantPosition = 26,
    CSSPropertyFontVariationSettings = 27,
    CSSPropertyFontWeight = 28,
    CSSPropertyTextOrientation = 29,
    CSSPropertyTextRendering = 30,
    CSSPropertyZoom = 31,
    CSSPropertyWebkitFontSmoothing = 32,
    CSSPropertyWebkitLocale = 33,
    CSSPropertyWebkitTextSizeAdjust = 34,
    CSSPropertyWebkitTextZoom = 35,
    CSSPropertyLetterSpacing = 36,
    CSSPropertyTextAutospace = 37,
    CSSPropertyTextSpacingTrim = 38,
    CSSPropertyAccentColor = 39,
    CSSPropertyAdditiveSymbols = 40,
    CSSPropertyAlignContent = 41,
    CSSPropertyAlignItems = 42,
    CSSPropertyAlignSelf = 43,
    CSSPropertyAlignmentBaseline = 44,
    CSSPropertyAlt = 45,
    CSSPropertyAnimationComposition = 46,
    CSSPropertyAnimationDelay = 47,
    CSSPropertyAnimationDirection = 48,
    CSSPropertyAnimationDuration = 49,
    CSSPropertyAnimationFillMode = 50,
    CSSPropertyAnimationIterationCount = 51,
    CSSPropertyAnimationName = 52,
    CSSPropertyAnimationPlayState = 53,
    CSSPropertyAnimationTimingFunction = 54,
    CSSPropertyAppearance = 55,
    CSSPropertyAspectRatio = 56,
    CSSPropertyBackfaceVisibility = 57,
    CSSPropertyBackgroundAttachment = 58,
    CSSPropertyBackgroundBlendMode = 59,
    CSSPropertyBackgroundColor = 60,
    CSSPropertyBackgroundImage = 61,
    CSSPropertyBackgroundPositionX = 62,
    CSSPropertyBackgroundPositionY = 63,
    CSSPropertyBackgroundRepeat = 64,
    CSSPropertyBackgroundSize = 65,
    CSSPropertyBasePalette = 66,
    CSSPropertyBaselineShift = 67,
    CSSPropertyBlockStepInsert = 68,
    CSSPropertyBlockStepSize = 69,
    CSSPropertyBorderCollapse = 70,
    CSSPropertyBorderImageOutset = 71,
    CSSPropertyBorderImageRepeat = 72,
    CSSPropertyBorderImageSlice = 73,
    CSSPropertyBorderImageSource = 74,
    CSSPropertyBorderImageWidth = 75,
    CSSPropertyBoxSizing = 76,
    CSSPropertyBreakAfter = 77,
    CSSPropertyBreakBefore = 78,
    CSSPropertyBreakInside = 79,
    CSSPropertyBufferedRendering = 80,
    CSSPropertyCaptionSide = 81,
    CSSPropertyCaretColor = 82,
    CSSPropertyClear = 83,
    CSSPropertyClip = 84,
    CSSPropertyClipPath = 85,
    CSSPropertyClipRule = 86,
    CSSPropertyColorInterpolation = 87,
    CSSPropertyColorInterpolationFilters = 88,
    CSSPropertyColumnCount = 89,
    CSSPropertyColumnFill = 90,
    CSSPropertyColumnGap = 91,
    CSSPropertyColumnRuleColor = 92,
    CSSPropertyColumnRuleStyle = 93,
    CSSPropertyColumnRuleWidth = 94,
    CSSPropertyColumnSpan = 95,
    CSSPropertyColumnWidth = 96,
    CSSPropertyContain = 97,
    CSSPropertyContainerName = 98,
    CSSPropertyContainerType = 99,
    CSSPropertyContent = 100,
    CSSPropertyContentVisibility = 101,
    CSSPropertyCounterIncrement = 102,
    CSSPropertyCounterReset = 103,
    CSSPropertyCounterSet = 104,
    CSSPropertyCursor = 105,
    CSSPropertyCx = 106,
    CSSPropertyCy = 107,
    CSSPropertyDominantBaseline = 108,
    CSSPropertyEmptyCells = 109,
    CSSPropertyFallback = 110,
    CSSPropertyFill = 111,
    CSSPropertyFillOpacity = 112,
    CSSPropertyFillRule = 113,
    CSSPropertyFilter = 114,
    CSSPropertyFlexBasis = 115,
    CSSPropertyFlexDirection = 116,
    CSSPropertyFlexGrow = 117,
    CSSPropertyFlexShrink = 118,
    CSSPropertyFlexWrap = 119,
    CSSPropertyFloat = 120,
    CSSPropertyFloodColor = 121,
    CSSPropertyFloodOpacity = 122,
    CSSPropertyFontDisplay = 123,
    CSSPropertyGlyphOrientationHorizontal = 124,
    CSSPropertyGlyphOrientationVertical = 125,
    CSSPropertyGridAutoColumns = 126,
    CSSPropertyGridAutoFlow = 127,
    CSSPropertyGridAutoRows = 128,
    CSSPropertyGridColumnEnd = 129,
    CSSPropertyGridColumnStart = 130,
    CSSPropertyGridRowEnd = 131,
    CSSPropertyGridRowStart = 132,
    CSSPropertyGridTemplateAreas = 133,
    CSSPropertyGridTemplateColumns = 134,
    CSSPropertyGridTemplateRows = 135,
    CSSPropertyHangingPunctuation = 136,
    CSSPropertyHyphenateCharacter = 137,
    CSSPropertyHyphens = 138,
    CSSPropertyImageOrientation = 139,
    CSSPropertyImageRendering = 140,
    CSSPropertyInherits = 141,
    CSSPropertyInitialValue = 142,
    CSSPropertyInputSecurity = 143,
    CSSPropertyIsolation = 144,
    CSSPropertyJustifyContent = 145,
    CSSPropertyJustifyItems = 146,
    CSSPropertyJustifySelf = 147,
    CSSPropertyKerning = 148,
    CSSPropertyLightingColor = 149,
    CSSPropertyLineBreak = 150,
    CSSPropertyLineHeight = 151,
    CSSPropertyListStyleImage = 152,
    CSSPropertyListStylePosition = 153,
    CSSPropertyListStyleType = 154,
    CSSPropertyMarginTrim = 155,
    CSSPropertyMarkerEnd = 156,
    CSSPropertyMarkerMid = 157,
    CSSPropertyMarkerStart = 158,
    CSSPropertyMaskBorderOutset = 159,
    CSSPropertyMaskBorderRepeat = 160,
    CSSPropertyMaskBorderSlice = 161,
    CSSPropertyMaskBorderSource = 162,
    CSSPropertyMaskBorderWidth = 163,
    CSSPropertyMaskImage = 164,
    CSSPropertyMaskOrigin = 165,
    CSSPropertyMaskRepeat = 166,
    CSSPropertyMaskSize = 167,
    CSSPropertyMaskType = 168,
    CSSPropertyMasonryAutoFlow = 169,
    CSSPropertyMathStyle = 170,
    CSSPropertyMixBlendMode = 171,
    CSSPropertyNegative = 172,
    CSSPropertyObjectFit = 173,
    CSSPropertyObjectPosition = 174,
    CSSPropertyOffsetAnchor = 175,
    CSSPropertyOffsetDistance = 176,
    CSSPropertyOffsetPath = 177,
    CSSPropertyOffsetPosition = 178,
    CSSPropertyOffsetRotate = 179,
    CSSPropertyOpacity = 180,
    CSSPropertyOrder = 181,
    CSSPropertyOrphans = 182,
    CSSPropertyOutlineColor = 183,
    CSSPropertyOutlineOffset = 184,
    CSSPropertyOutlineStyle = 185,
    CSSPropertyOutlineWidth = 186,
    CSSPropertyOverflowAnchor = 187,
    CSSPropertyOverflowWrap = 188,
    CSSPropertyOverflowX = 189,
    CSSPropertyOverflowY = 190,
    CSSPropertyOverrideColors = 191,
    CSSPropertyPad = 192,
    CSSPropertyPage = 193,
    CSSPropertyPaintOrder = 194,
    CSSPropertyPerspective = 195,
    CSSPropertyPerspectiveOriginX = 196,
    CSSPropertyPerspectiveOriginY = 197,
    CSSPropertyPointerEvents = 198,
    CSSPropertyPosition = 199,
    CSSPropertyPrefix = 200,
    CSSPropertyPrintColorAdjust = 201,
    CSSPropertyQuotes = 202,
    CSSPropertyR = 203,
    CSSPropertyRange = 204,
    CSSPropertyResize = 205,
    CSSPropertyRotate = 206,
    CSSPropertyRowGap = 207,
    CSSPropertyRx = 208,
    CSSPropertyRy = 209,
    CSSPropertyScale = 210,
    CSSPropertyScrollBehavior = 211,
    CSSPropertyScrollSnapAlign = 212,
    CSSPropertyScrollSnapStop = 213,
    CSSPropertyScrollSnapType = 214,
    CSSPropertyScrollbarColor = 215,
    CSSPropertyScrollbarGutter = 216,
    CSSPropertyScrollbarWidth = 217,
    CSSPropertyShapeImageThreshold = 218,
    CSSPropertyShapeMargin = 219,
    CSSPropertyShapeOutside = 220,
    CSSPropertyShapeRendering = 221,
    CSSPropertySize = 222,
    CSSPropertySizeAdjust = 223,
    CSSPropertySpeakAs = 224,
    CSSPropertySrc = 225,
    CSSPropertyStopColor = 226,
    CSSPropertyStopOpacity = 227,
    CSSPropertyStroke = 228,
    CSSPropertyStrokeColor = 229,
    CSSPropertyStrokeDasharray = 230,
    CSSPropertyStrokeDashoffset = 231,
    CSSPropertyStrokeLinecap = 232,
    CSSPropertyStrokeLinejoin = 233,
    CSSPropertyStrokeMiterlimit = 234,
    CSSPropertyStrokeOpacity = 235,
    CSSPropertyStrokeWidth = 236,
    CSSPropertySuffix = 237,
    CSSPropertySymbols = 238,
    CSSPropertySyntax = 239,
    CSSPropertySystem = 240,
    CSSPropertyTabSize = 241,
    CSSPropertyTableLayout = 242,
    CSSPropertyTextAlign = 243,
    CSSPropertyTextAlignLast = 244,
    CSSPropertyTextAnchor = 245,
    CSSPropertyTextBoxEdge = 246,
    CSSPropertyTextBoxTrim = 247,
    CSSPropertyTextDecorationColor = 248,
    CSSPropertyTextDecorationLine = 249,
    CSSPropertyTextDecorationSkipInk = 250,
    CSSPropertyTextDecorationStyle = 251,
    CSSPropertyTextDecorationThickness = 252,
    CSSPropertyTextEmphasisColor = 253,
    CSSPropertyTextEmphasisPosition = 254,
    CSSPropertyTextEmphasisStyle = 255,
    CSSPropertyTextGroupAlign = 256,
    CSSPropertyTextIndent = 257,
    CSSPropertyTextJustify = 258,
    CSSPropertyTextOverflow = 259,
    CSSPropertyTextShadow = 260,
    CSSPropertyTextTransform = 261,
    CSSPropertyTextUnderlineOffset = 262,
    CSSPropertyTextUnderlinePosition = 263,
    CSSPropertyTextWrap = 264,
    CSSPropertyTouchAction = 265,
    CSSPropertyTransform = 266,
    CSSPropertyTransformBox = 267,
    CSSPropertyTransformOriginX = 268,
    CSSPropertyTransformOriginY = 269,
    CSSPropertyTransformOriginZ = 270,
    CSSPropertyTransformStyle = 271,
    CSSPropertyTransitionDelay = 272,
    CSSPropertyTransitionDuration = 273,
    CSSPropertyTransitionProperty = 274,
    CSSPropertyTransitionTimingFunction = 275,
    CSSPropertyTranslate = 276,
    CSSPropertyUnicodeBidi = 277,
    CSSPropertyUnicodeRange = 278,
    CSSPropertyVectorEffect = 279,
    CSSPropertyVerticalAlign = 280,
    CSSPropertyVisibility = 281,
    CSSPropertyWhiteSpaceCollapse = 282,
    CSSPropertyWidows = 283,
    CSSPropertyWillChange = 284,
    CSSPropertyWordBreak = 285,
    CSSPropertyWordSpacing = 286,
    CSSPropertyX = 287,
    CSSPropertyY = 288,
    CSSPropertyZIndex = 289,
    CSSPropertyAppleColorFilter = 290,
    CSSPropertyApplePayButtonStyle = 291,
    CSSPropertyApplePayButtonType = 292,
    CSSPropertyInternalTextAutosizingStatus = 293,
    CSSPropertyWebkitBorderHorizontalSpacing = 294,
    CSSPropertyWebkitBorderVerticalSpacing = 295,
    CSSPropertyWebkitBoxAlign = 296,
    CSSPropertyWebkitBoxDecorationBreak = 297,
    CSSPropertyWebkitBoxDirection = 298,
    CSSPropertyWebkitBoxFlex = 299,
    CSSPropertyWebkitBoxFlexGroup = 300,
    CSSPropertyWebkitBoxLines = 301,
    CSSPropertyWebkitBoxOrdinalGroup = 302,
    CSSPropertyWebkitBoxOrient = 303,
    CSSPropertyWebkitBoxPack = 304,
    CSSPropertyWebkitBoxReflect = 305,
    CSSPropertyWebkitColumnAxis = 306,
    CSSPropertyWebkitColumnProgression = 307,
    CSSPropertyWebkitCursorVisibility = 308,
    CSSPropertyWebkitFontSizeDelta = 309,
    CSSPropertyWebkitHyphenateLimitAfter = 310,
    CSSPropertyWebkitHyphenateLimitBefore = 311,
    CSSPropertyWebkitHyphenateLimitLines = 312,
    CSSPropertyWebkitInitialLetter = 313,
    CSSPropertyWebkitLineAlign = 314,
    CSSPropertyWebkitLineBoxContain = 315,
    CSSPropertyWebkitLineClamp = 316,
    CSSPropertyWebkitLineGrid = 317,
    CSSPropertyWebkitLineSnap = 318,
    CSSPropertyWebkitMarqueeDirection = 319,
    CSSPropertyWebkitMarqueeIncrement = 320,
    CSSPropertyWebkitMarqueeRepetition = 321,
    CSSPropertyWebkitMarqueeSpeed = 322,
    CSSPropertyWebkitMarqueeStyle = 323,
    CSSPropertyWebkitMaskPositionX = 324,
    CSSPropertyWebkitMaskPositionY = 325,
    CSSPropertyWebkitNbspMode = 326,
    CSSPropertyWebkitRtlOrdering = 327,
    CSSPropertyWebkitTapHighlightColor = 328,
    CSSPropertyWebkitTextDecorationsInEffect = 329,
    CSSPropertyWebkitTextFillColor = 330,
    CSSPropertyWebkitTextSecurity = 331,
    CSSPropertyWebkitTextStrokeColor = 332,
    CSSPropertyWebkitTextStrokeWidth = 333,
    CSSPropertyWebkitUserDrag = 334,
    CSSPropertyWebkitUserModify = 335,
    CSSPropertyWebkitUserSelect = 336,
    CSSPropertyBackdropFilter = 337,
    CSSPropertyBackgroundClip = 338,
    CSSPropertyBackgroundOrigin = 339,
    CSSPropertyBlockSize = 340,
    CSSPropertyBorderBlockEndColor = 341,
    CSSPropertyBorderBlockEndStyle = 342,
    CSSPropertyBorderBlockEndWidth = 343,
    CSSPropertyBorderBlockStartColor = 344,
    CSSPropertyBorderBlockStartStyle = 345,
    CSSPropertyBorderBlockStartWidth = 346,
    CSSPropertyBorderBottomColor = 347,
    CSSPropertyBorderBottomLeftRadius = 348,
    CSSPropertyBorderBottomRightRadius = 349,
    CSSPropertyBorderBottomStyle = 350,
    CSSPropertyBorderBottomWidth = 351,
    CSSPropertyBorderEndEndRadius = 352,
    CSSPropertyBorderEndStartRadius = 353,
    CSSPropertyBorderInlineEndColor = 354,
    CSSPropertyBorderInlineEndStyle = 355,
    CSSPropertyBorderInlineEndWidth = 356,
    CSSPropertyBorderInlineStartColor = 357,
    CSSPropertyBorderInlineStartStyle = 358,
    CSSPropertyBorderInlineStartWidth = 359,
    CSSPropertyBorderLeftColor = 360,
    CSSPropertyBorderLeftStyle = 361,
    CSSPropertyBorderLeftWidth = 362,
    CSSPropertyBorderRightColor = 363,
    CSSPropertyBorderRightStyle = 364,
    CSSPropertyBorderRightWidth = 365,
    CSSPropertyBorderStartEndRadius = 366,
    CSSPropertyBorderStartStartRadius = 367,
    CSSPropertyBorderTopColor = 368,
    CSSPropertyBorderTopLeftRadius = 369,
    CSSPropertyBorderTopRightRadius = 370,
    CSSPropertyBorderTopStyle = 371,
    CSSPropertyBorderTopWidth = 372,
    CSSPropertyBottom = 373,
    CSSPropertyBoxShadow = 374,
    CSSPropertyContainIntrinsicBlockSize = 375,
    CSSPropertyContainIntrinsicHeight = 376,
    CSSPropertyContainIntrinsicInlineSize = 377,
    CSSPropertyContainIntrinsicWidth = 378,
    CSSPropertyHeight = 379,
    CSSPropertyInlineSize = 380,
    CSSPropertyInsetBlockEnd = 381,
    CSSPropertyInsetBlockStart = 382,
    CSSPropertyInsetInlineEnd = 383,
    CSSPropertyInsetInlineStart = 384,
    CSSPropertyLeft = 385,
    CSSPropertyMarginBlockEnd = 386,
    CSSPropertyMarginBlockStart = 387,
    CSSPropertyMarginBottom = 388,
    CSSPropertyMarginInlineEnd = 389,
    CSSPropertyMarginInlineStart = 390,
    CSSPropertyMarginLeft = 391,
    CSSPropertyMarginRight = 392,
    CSSPropertyMarginTop = 393,
    CSSPropertyMaskClip = 394,
    CSSPropertyMaskComposite = 395,
    CSSPropertyMaskMode = 396,
    CSSPropertyMaxBlockSize = 397,
    CSSPropertyMaxHeight = 398,
    CSSPropertyMaxInlineSize = 399,
    CSSPropertyMaxWidth = 400,
    CSSPropertyMinBlockSize = 401,
    CSSPropertyMinHeight = 402,
    CSSPropertyMinInlineSize = 403,
    CSSPropertyMinWidth = 404,
    CSSPropertyOverscrollBehaviorBlock = 405,
    CSSPropertyOverscrollBehaviorInline = 406,
    CSSPropertyOverscrollBehaviorX = 407,
    CSSPropertyOverscrollBehaviorY = 408,
    CSSPropertyPaddingBlockEnd = 409,
    CSSPropertyPaddingBlockStart = 410,
    CSSPropertyPaddingBottom = 411,
    CSSPropertyPaddingInlineEnd = 412,
    CSSPropertyPaddingInlineStart = 413,
    CSSPropertyPaddingLeft = 414,
    CSSPropertyPaddingRight = 415,
    CSSPropertyPaddingTop = 416,
    CSSPropertyRight = 417,
    CSSPropertyScrollMarginBlockEnd = 418,
    CSSPropertyScrollMarginBlockStart = 419,
    CSSPropertyScrollMarginBottom = 420,
    CSSPropertyScrollMarginInlineEnd = 421,
    CSSPropertyScrollMarginInlineStart = 422,
    CSSPropertyScrollMarginLeft = 423,
    CSSPropertyScrollMarginRight = 424,
    CSSPropertyScrollMarginTop = 425,
    CSSPropertyScrollPaddingBlockEnd = 426,
    CSSPropertyScrollPaddingBlockStart = 427,
    CSSPropertyScrollPaddingBottom = 428,
    CSSPropertyScrollPaddingInlineEnd = 429,
    CSSPropertyScrollPaddingInlineStart = 430,
    CSSPropertyScrollPaddingLeft = 431,
    CSSPropertyScrollPaddingRight = 432,
    CSSPropertyScrollPaddingTop = 433,
    CSSPropertyTextCombineUpright = 434,
    CSSPropertyTop = 435,
    CSSPropertyWidth = 436,
    CSSPropertyWebkitBackdropFilter = 437,
    CSSPropertyWebkitBackgroundClip = 438,
    CSSPropertyWebkitBackgroundOrigin = 439,
    CSSPropertyWebkitBoxShadow = 440,
    CSSPropertyWebkitMaskClip = 441,
    CSSPropertyWebkitMaskComposite = 442,
    CSSPropertyWebkitMaskSourceType = 443,
    CSSPropertyWebkitTextCombine = 444,
    CSSPropertyAll = 445,
    CSSPropertyAnimation = 446,
    CSSPropertyBackground = 447,
    CSSPropertyBackgroundPosition = 448,
    CSSPropertyBorder = 449,
    CSSPropertyBorderBlock = 450,
    CSSPropertyBorderBlockColor = 451,
    CSSPropertyBorderBlockEnd = 452,
    CSSPropertyBorderBlockStart = 453,
    CSSPropertyBorderBlockStyle = 454,
    CSSPropertyBorderBlockWidth = 455,
    CSSPropertyBorderBottom = 456,
    CSSPropertyBorderColor = 457,
    CSSPropertyBorderImage = 458,
    CSSPropertyBorderInline = 459,
    CSSPropertyBorderInlineColor = 460,
    CSSPropertyBorderInlineEnd = 461,
    CSSPropertyBorderInlineStart = 462,
    CSSPropertyBorderInlineStyle = 463,
    CSSPropertyBorderInlineWidth = 464,
    CSSPropertyBorderLeft = 465,
    CSSPropertyBorderRadius = 466,
    CSSPropertyBorderRight = 467,
    CSSPropertyBorderSpacing = 468,
    CSSPropertyBorderStyle = 469,
    CSSPropertyBorderTop = 470,
    CSSPropertyBorderWidth = 471,
    CSSPropertyColumnRule = 472,
    CSSPropertyColumns = 473,
    CSSPropertyContainIntrinsicSize = 474,
    CSSPropertyContainer = 475,
    CSSPropertyFlex = 476,
    CSSPropertyFlexFlow = 477,
    CSSPropertyFont = 478,
    CSSPropertyFontSynthesis = 479,
    CSSPropertyFontVariant = 480,
    CSSPropertyGap = 481,
    CSSPropertyGrid = 482,
    CSSPropertyGridArea = 483,
    CSSPropertyGridColumn = 484,
    CSSPropertyGridRow = 485,
    CSSPropertyGridTemplate = 486,
    CSSPropertyInset = 487,
    CSSPropertyInsetBlock = 488,
    CSSPropertyInsetInline = 489,
    CSSPropertyListStyle = 490,
    CSSPropertyMargin = 491,
    CSSPropertyMarginBlock = 492,
    CSSPropertyMarginInline = 493,
    CSSPropertyMarker = 494,
    CSSPropertyMask = 495,
    CSSPropertyMaskBorder = 496,
    CSSPropertyMaskPosition = 497,
    CSSPropertyOffset = 498,
    CSSPropertyOutline = 499,
    CSSPropertyOverflow = 500,
    CSSPropertyOverscrollBehavior = 501,
    CSSPropertyPadding = 502,
    CSSPropertyPaddingBlock = 503,
    CSSPropertyPaddingInline = 504,
    CSSPropertyPageBreakAfter = 505,
    CSSPropertyPageBreakBefore = 506,
    CSSPropertyPageBreakInside = 507,
    CSSPropertyPerspectiveOrigin = 508,
    CSSPropertyPlaceContent = 509,
    CSSPropertyPlaceItems = 510,
    CSSPropertyPlaceSelf = 511,
    CSSPropertyScrollMargin = 512,
    CSSPropertyScrollMarginBlock = 513,
    CSSPropertyScrollMarginInline = 514,
    CSSPropertyScrollPadding = 515,
    CSSPropertyScrollPaddingBlock = 516,
    CSSPropertyScrollPaddingInline = 517,
    CSSPropertyTextDecoration = 518,
    CSSPropertyTextDecorationSkip = 519,
    CSSPropertyTextEmphasis = 520,
    CSSPropertyTransformOrigin = 521,
    CSSPropertyTransition = 522,
    CSSPropertyWhiteSpace = 523,
    CSSPropertyWebkitBackgroundSize = 524,
    CSSPropertyWebkitBorderImage = 525,
    CSSPropertyWebkitBorderRadius = 526,
    CSSPropertyWebkitColumnBreakAfter = 527,
    CSSPropertyWebkitColumnBreakBefore = 528,
    CSSPropertyWebkitColumnBreakInside = 529,
    CSSPropertyWebkitMask = 530,
    CSSPropertyWebkitMaskBoxImage = 531,
    CSSPropertyWebkitMaskPosition = 532,
    CSSPropertyWebkitPerspective = 533,
    CSSPropertyWebkitTextDecoration = 534,
    CSSPropertyWebkitTextOrientation = 535,
    CSSPropertyWebkitTextStroke = 536,
};

constexpr uint16_t firstCSSProperty = 2;
constexpr uint16_t numCSSProperties = 535;
constexpr unsigned maxCSSPropertyNameLength = 34;
constexpr auto firstTopPriorityProperty = CSSPropertyID::CSSPropertyColorScheme;
constexpr auto lastTopPriorityProperty = CSSPropertyID::CSSPropertyWebkitRubyPosition;
constexpr auto firstHighPriorityProperty = CSSPropertyID::CSSPropertyColor;
constexpr auto lastHighPriorityProperty = CSSPropertyID::CSSPropertyTextSpacingTrim;
constexpr auto firstLowPriorityProperty = CSSPropertyID::CSSPropertyAccentColor;
constexpr auto lastLowPriorityProperty = CSSPropertyID::CSSPropertyWebkitUserSelect;
constexpr auto firstDeferredProperty = CSSPropertyID::CSSPropertyBackdropFilter;
constexpr auto lastDeferredProperty = CSSPropertyID::CSSPropertyWebkitTextCombine;
constexpr auto firstShorthandProperty = CSSPropertyID::CSSPropertyAll;
constexpr auto lastShorthandProperty = CSSPropertyID::CSSPropertyWebkitTextStroke;
constexpr uint16_t numCSSPropertyLonghands = firstShorthandProperty - firstCSSProperty;
extern const std::array<CSSPropertyID, 412> computedPropertyIDs;

struct CSSPropertySettings {
    WTF_MAKE_STRUCT_FAST_ALLOCATED;

    bool CSSOMViewSmoothScrollingEnabled { false };
    bool accentColorEnabled { false };
    bool aspectRatioEnabled { false };
    bool colorFilterEnabled { false };
    bool cssContainIntrinsicSizeEnabled { false };
    bool cssContainerQueriesEnabled { false };
    bool cssContainmentEnabled { false };
    bool cssContentVisibilityEnabled { false };
    bool cssCounterStyleAtRulesEnabled { false };
    bool cssCustomPropertiesAndValuesEnabled { false };
    bool cssFontFaceSizeAdjustEnabled { false };
    bool cssFontVariantEmojiEnabled { false };
    bool cssIndividualTransformPropertiesEnabled { false };
    bool cssInputSecurityEnabled { false };
    bool cssMarginTrimEnabled { false };
    bool cssMotionPathEnabled { false };
    bool cssRhythmicSizingEnabled { false };
    bool cssScrollAnchoringEnabled { false };
    bool cssScrollbarColorEnabled { false };
    bool cssScrollbarGutterEnabled { false };
    bool cssScrollbarWidthEnabled { false };
    bool cssTextAlignLastEnabled { false };
    bool cssTextBoxTrimEnabled { false };
    bool cssTextGroupAlignEnabled { false };
    bool cssTextJustifyEnabled { false };
    bool cssTextSpacingEnabled { false };
    bool cssUnprefixedBackdropFilterEnabled { false };
    bool cssWhiteSpaceLonghandsEnabled { false };
    bool masonryEnabled { false };
    bool overscrollBehaviorEnabled { false };
    bool textAutosizingEnabled { false };

    CSSPropertySettings() = default;
    explicit CSSPropertySettings(const Settings&);
};

bool operator==(const CSSPropertySettings&, const CSSPropertySettings&);
void add(Hasher&, const CSSPropertySettings&);

constexpr bool isLonghand(CSSPropertyID);
bool isInternal(CSSPropertyID);
bool isExposed(CSSPropertyID, const Settings*);
bool isExposed(CSSPropertyID, const Settings&);
bool isExposed(CSSPropertyID, const CSSPropertySettings*);
bool isExposed(CSSPropertyID, const CSSPropertySettings&);

CSSPropertyID findCSSProperty(const char* characters, unsigned length);
ASCIILiteral nameLiteral(CSSPropertyID);
const AtomString& nameString(CSSPropertyID);
String nameForIDL(CSSPropertyID);

CSSPropertyID relatedProperty(CSSPropertyID);

template<CSSPropertyID first, CSSPropertyID last> struct CSSPropertiesRange {
    struct Iterator {
        uint16_t index { static_cast<uint16_t>(first) };
        constexpr CSSPropertyID operator*() const { return static_cast<CSSPropertyID>(index); }
        constexpr Iterator& operator++() { ++index; return *this; }
        constexpr bool operator==(std::nullptr_t) const { return index > static_cast<uint16_t>(last); }
    };
    static constexpr Iterator begin() { return { }; }
    static constexpr std::nullptr_t end() { return nullptr; }
    static constexpr uint16_t size() { return last - first + 1; }
};
using AllCSSPropertiesRange = CSSPropertiesRange<static_cast<CSSPropertyID>(firstCSSProperty), lastShorthandProperty>;
using AllLonghandCSSPropertiesRange = CSSPropertiesRange<static_cast<CSSPropertyID>(firstCSSProperty), lastDeferredProperty>;
constexpr AllCSSPropertiesRange allCSSProperties() { return { }; }
constexpr AllLonghandCSSPropertiesRange allLonghandCSSProperties() { return { }; }

constexpr bool isLonghand(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= firstCSSProperty && static_cast<uint16_t>(property) < static_cast<uint16_t>(firstShorthandProperty);
}
constexpr bool isShorthand(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= static_cast<uint16_t>(firstShorthandProperty) && static_cast<uint16_t>(property) <= static_cast<uint16_t>(lastShorthandProperty);
}

} // namespace WebCore

namespace WTF {

template<> struct DefaultHash<WebCore::CSSPropertyID> : IntHash<unsigned> { };

template<> struct HashTraits<WebCore::CSSPropertyID> : GenericHashTraits<WebCore::CSSPropertyID> {
    static const bool emptyValueIsZero = true;
    static void constructDeletedValue(WebCore::CSSPropertyID& slot) { slot = static_cast<WebCore::CSSPropertyID>(std::numeric_limits<uint16_t>::max()); }
    static bool isDeletedValue(WebCore::CSSPropertyID value) { return static_cast<uint16_t>(value) == std::numeric_limits<uint16_t>::max(); }
};

} // namespace WTF

namespace std {

template<> struct iterator_traits<WebCore::AllCSSPropertiesRange::Iterator> { using value_type = WebCore::CSSPropertyID; };
template<> struct iterator_traits<WebCore::AllLonghandCSSPropertiesRange::Iterator> { using value_type = WebCore::CSSPropertyID; };

} // namespace std

