// This file is automatically generated from CSSProperties.json by the process-css-properties script. Do not edit it.

#pragma once

#include <array>
#include <wtf/HashFunctions.h>
#include <wtf/HashTraits.h>

namespace WebCore {

class Settings;

enum CSSPropertyID : uint16_t {
    CSSPropertyInvalid = 0,
    CSSPropertyCustom = 1,
    CSSPropertyColorScheme = 2,
    CSSPropertyWritingMode = 3,
    CSSPropertyWebkitRubyPosition = 4,
    CSSPropertyColor = 5,
    CSSPropertyDirection = 6,
    CSSPropertyDisplay = 7,
    CSSPropertyFontFamily = 8,
    CSSPropertyFontFeatureSettings = 9,
    CSSPropertyFontKerning = 10,
    CSSPropertyFontOpticalSizing = 11,
    CSSPropertyFontPalette = 12,
    CSSPropertyFontSize = 13,
    CSSPropertyFontSizeAdjust = 14,
    CSSPropertyFontStretch = 15,
    CSSPropertyFontStyle = 16,
    CSSPropertyFontSynthesisSmallCaps = 17,
    CSSPropertyFontSynthesisStyle = 18,
    CSSPropertyFontSynthesisWeight = 19,
    CSSPropertyFontVariantAlternates = 20,
    CSSPropertyFontVariantCaps = 21,
    CSSPropertyFontVariantEastAsian = 22,
    CSSPropertyFontVariantLigatures = 23,
    CSSPropertyFontVariantNumeric = 24,
    CSSPropertyFontVariantPosition = 25,
    CSSPropertyFontVariationSettings = 26,
    CSSPropertyFontWeight = 27,
    CSSPropertyTextOrientation = 28,
    CSSPropertyTextRendering = 29,
    CSSPropertyZoom = 30,
    CSSPropertyWebkitFontSmoothing = 31,
    CSSPropertyWebkitLocale = 32,
    CSSPropertyWebkitTextSizeAdjust = 33,
    CSSPropertyWebkitTextZoom = 34,
    CSSPropertyLetterSpacing = 35,
    CSSPropertyAccentColor = 36,
    CSSPropertyAdditiveSymbols = 37,
    CSSPropertyAlignContent = 38,
    CSSPropertyAlignItems = 39,
    CSSPropertyAlignSelf = 40,
    CSSPropertyAlignmentBaseline = 41,
    CSSPropertyAlt = 42,
    CSSPropertyAnimationComposition = 43,
    CSSPropertyAnimationDelay = 44,
    CSSPropertyAnimationDirection = 45,
    CSSPropertyAnimationDuration = 46,
    CSSPropertyAnimationFillMode = 47,
    CSSPropertyAnimationIterationCount = 48,
    CSSPropertyAnimationName = 49,
    CSSPropertyAnimationPlayState = 50,
    CSSPropertyAnimationTimingFunction = 51,
    CSSPropertyAppearance = 52,
    CSSPropertyAspectRatio = 53,
    CSSPropertyBackfaceVisibility = 54,
    CSSPropertyBackgroundAttachment = 55,
    CSSPropertyBackgroundBlendMode = 56,
    CSSPropertyBackgroundColor = 57,
    CSSPropertyBackgroundImage = 58,
    CSSPropertyBackgroundPositionX = 59,
    CSSPropertyBackgroundPositionY = 60,
    CSSPropertyBackgroundRepeat = 61,
    CSSPropertyBackgroundSize = 62,
    CSSPropertyBasePalette = 63,
    CSSPropertyBaselineShift = 64,
    CSSPropertyBorderCollapse = 65,
    CSSPropertyBorderImageOutset = 66,
    CSSPropertyBorderImageRepeat = 67,
    CSSPropertyBorderImageSlice = 68,
    CSSPropertyBorderImageSource = 69,
    CSSPropertyBorderImageWidth = 70,
    CSSPropertyBoxSizing = 71,
    CSSPropertyBreakAfter = 72,
    CSSPropertyBreakBefore = 73,
    CSSPropertyBreakInside = 74,
    CSSPropertyBufferedRendering = 75,
    CSSPropertyCaptionSide = 76,
    CSSPropertyCaretColor = 77,
    CSSPropertyClear = 78,
    CSSPropertyClip = 79,
    CSSPropertyClipPath = 80,
    CSSPropertyClipRule = 81,
    CSSPropertyColorInterpolation = 82,
    CSSPropertyColorInterpolationFilters = 83,
    CSSPropertyColumnCount = 84,
    CSSPropertyColumnFill = 85,
    CSSPropertyColumnGap = 86,
    CSSPropertyColumnRuleColor = 87,
    CSSPropertyColumnRuleStyle = 88,
    CSSPropertyColumnRuleWidth = 89,
    CSSPropertyColumnSpan = 90,
    CSSPropertyColumnWidth = 91,
    CSSPropertyContain = 92,
    CSSPropertyContainerName = 93,
    CSSPropertyContainerType = 94,
    CSSPropertyContent = 95,
    CSSPropertyContentVisibility = 96,
    CSSPropertyCounterIncrement = 97,
    CSSPropertyCounterReset = 98,
    CSSPropertyCursor = 99,
    CSSPropertyCx = 100,
    CSSPropertyCy = 101,
    CSSPropertyDominantBaseline = 102,
    CSSPropertyEmptyCells = 103,
    CSSPropertyFallback = 104,
    CSSPropertyFill = 105,
    CSSPropertyFillOpacity = 106,
    CSSPropertyFillRule = 107,
    CSSPropertyFilter = 108,
    CSSPropertyFlexBasis = 109,
    CSSPropertyFlexDirection = 110,
    CSSPropertyFlexGrow = 111,
    CSSPropertyFlexShrink = 112,
    CSSPropertyFlexWrap = 113,
    CSSPropertyFloat = 114,
    CSSPropertyFloodColor = 115,
    CSSPropertyFloodOpacity = 116,
    CSSPropertyFontDisplay = 117,
    CSSPropertyGlyphOrientationHorizontal = 118,
    CSSPropertyGlyphOrientationVertical = 119,
    CSSPropertyGridAutoColumns = 120,
    CSSPropertyGridAutoFlow = 121,
    CSSPropertyGridAutoRows = 122,
    CSSPropertyGridColumnEnd = 123,
    CSSPropertyGridColumnStart = 124,
    CSSPropertyGridRowEnd = 125,
    CSSPropertyGridRowStart = 126,
    CSSPropertyGridTemplateAreas = 127,
    CSSPropertyGridTemplateColumns = 128,
    CSSPropertyGridTemplateRows = 129,
    CSSPropertyHangingPunctuation = 130,
    CSSPropertyImageOrientation = 131,
    CSSPropertyImageRendering = 132,
    CSSPropertyInherits = 133,
    CSSPropertyInitialValue = 134,
    CSSPropertyInputSecurity = 135,
    CSSPropertyIsolation = 136,
    CSSPropertyJustifyContent = 137,
    CSSPropertyJustifyItems = 138,
    CSSPropertyJustifySelf = 139,
    CSSPropertyKerning = 140,
    CSSPropertyLeadingTrim = 141,
    CSSPropertyLightingColor = 142,
    CSSPropertyLineBreak = 143,
    CSSPropertyLineHeight = 144,
    CSSPropertyListStyleImage = 145,
    CSSPropertyListStylePosition = 146,
    CSSPropertyListStyleType = 147,
    CSSPropertyMarginTrim = 148,
    CSSPropertyMarkerEnd = 149,
    CSSPropertyMarkerMid = 150,
    CSSPropertyMarkerStart = 151,
    CSSPropertyMaskImage = 152,
    CSSPropertyMaskOrigin = 153,
    CSSPropertyMaskRepeat = 154,
    CSSPropertyMaskSize = 155,
    CSSPropertyMaskType = 156,
    CSSPropertyMasonryAutoFlow = 157,
    CSSPropertyMathStyle = 158,
    CSSPropertyMixBlendMode = 159,
    CSSPropertyNegative = 160,
    CSSPropertyObjectFit = 161,
    CSSPropertyObjectPosition = 162,
    CSSPropertyOffsetAnchor = 163,
    CSSPropertyOffsetDistance = 164,
    CSSPropertyOffsetPath = 165,
    CSSPropertyOffsetPosition = 166,
    CSSPropertyOffsetRotate = 167,
    CSSPropertyOpacity = 168,
    CSSPropertyOrder = 169,
    CSSPropertyOrphans = 170,
    CSSPropertyOutlineColor = 171,
    CSSPropertyOutlineOffset = 172,
    CSSPropertyOutlineStyle = 173,
    CSSPropertyOutlineWidth = 174,
    CSSPropertyOverflowAnchor = 175,
    CSSPropertyOverflowWrap = 176,
    CSSPropertyOverflowX = 177,
    CSSPropertyOverflowY = 178,
    CSSPropertyOverrideColors = 179,
    CSSPropertyPad = 180,
    CSSPropertyPage = 181,
    CSSPropertyPaintOrder = 182,
    CSSPropertyPerspective = 183,
    CSSPropertyPerspectiveOriginX = 184,
    CSSPropertyPerspectiveOriginY = 185,
    CSSPropertyPointerEvents = 186,
    CSSPropertyPosition = 187,
    CSSPropertyPrefix = 188,
    CSSPropertyPrintColorAdjust = 189,
    CSSPropertyQuotes = 190,
    CSSPropertyR = 191,
    CSSPropertyRange = 192,
    CSSPropertyResize = 193,
    CSSPropertyRotate = 194,
    CSSPropertyRowGap = 195,
    CSSPropertyRx = 196,
    CSSPropertyRy = 197,
    CSSPropertyScale = 198,
    CSSPropertyScrollBehavior = 199,
    CSSPropertyScrollSnapAlign = 200,
    CSSPropertyScrollSnapStop = 201,
    CSSPropertyScrollSnapType = 202,
    CSSPropertyShapeImageThreshold = 203,
    CSSPropertyShapeMargin = 204,
    CSSPropertyShapeOutside = 205,
    CSSPropertyShapeRendering = 206,
    CSSPropertySize = 207,
    CSSPropertySpeakAs = 208,
    CSSPropertySrc = 209,
    CSSPropertyStopColor = 210,
    CSSPropertyStopOpacity = 211,
    CSSPropertyStroke = 212,
    CSSPropertyStrokeColor = 213,
    CSSPropertyStrokeDasharray = 214,
    CSSPropertyStrokeDashoffset = 215,
    CSSPropertyStrokeLinecap = 216,
    CSSPropertyStrokeLinejoin = 217,
    CSSPropertyStrokeMiterlimit = 218,
    CSSPropertyStrokeOpacity = 219,
    CSSPropertyStrokeWidth = 220,
    CSSPropertySuffix = 221,
    CSSPropertySymbols = 222,
    CSSPropertySyntax = 223,
    CSSPropertySystem = 224,
    CSSPropertyTabSize = 225,
    CSSPropertyTableLayout = 226,
    CSSPropertyTextAlign = 227,
    CSSPropertyTextAlignLast = 228,
    CSSPropertyTextAnchor = 229,
    CSSPropertyTextDecorationColor = 230,
    CSSPropertyTextDecorationLine = 231,
    CSSPropertyTextDecorationSkipInk = 232,
    CSSPropertyTextDecorationStyle = 233,
    CSSPropertyTextDecorationThickness = 234,
    CSSPropertyTextEdge = 235,
    CSSPropertyTextEmphasisColor = 236,
    CSSPropertyTextEmphasisPosition = 237,
    CSSPropertyTextEmphasisStyle = 238,
    CSSPropertyTextIndent = 239,
    CSSPropertyTextJustify = 240,
    CSSPropertyTextOverflow = 241,
    CSSPropertyTextShadow = 242,
    CSSPropertyTextTransform = 243,
    CSSPropertyTextUnderlineOffset = 244,
    CSSPropertyTextUnderlinePosition = 245,
    CSSPropertyTouchAction = 246,
    CSSPropertyTransform = 247,
    CSSPropertyTransformBox = 248,
    CSSPropertyTransformOriginX = 249,
    CSSPropertyTransformOriginY = 250,
    CSSPropertyTransformOriginZ = 251,
    CSSPropertyTransformStyle = 252,
    CSSPropertyTransitionDelay = 253,
    CSSPropertyTransitionDuration = 254,
    CSSPropertyTransitionProperty = 255,
    CSSPropertyTransitionTimingFunction = 256,
    CSSPropertyTranslate = 257,
    CSSPropertyUnicodeBidi = 258,
    CSSPropertyUnicodeRange = 259,
    CSSPropertyVectorEffect = 260,
    CSSPropertyVerticalAlign = 261,
    CSSPropertyVisibility = 262,
    CSSPropertyWhiteSpace = 263,
    CSSPropertyWidows = 264,
    CSSPropertyWillChange = 265,
    CSSPropertyWordBreak = 266,
    CSSPropertyWordSpacing = 267,
    CSSPropertyX = 268,
    CSSPropertyY = 269,
    CSSPropertyZIndex = 270,
    CSSPropertyAppleColorFilter = 271,
    CSSPropertyApplePayButtonStyle = 272,
    CSSPropertyApplePayButtonType = 273,
    CSSPropertyInternalTextAutosizingStatus = 274,
    CSSPropertyWebkitBackdropFilter = 275,
    CSSPropertyWebkitBorderHorizontalSpacing = 276,
    CSSPropertyWebkitBorderVerticalSpacing = 277,
    CSSPropertyWebkitBoxAlign = 278,
    CSSPropertyWebkitBoxDecorationBreak = 279,
    CSSPropertyWebkitBoxDirection = 280,
    CSSPropertyWebkitBoxFlex = 281,
    CSSPropertyWebkitBoxFlexGroup = 282,
    CSSPropertyWebkitBoxLines = 283,
    CSSPropertyWebkitBoxOrdinalGroup = 284,
    CSSPropertyWebkitBoxOrient = 285,
    CSSPropertyWebkitBoxPack = 286,
    CSSPropertyWebkitBoxReflect = 287,
    CSSPropertyWebkitColumnAxis = 288,
    CSSPropertyWebkitColumnProgression = 289,
    CSSPropertyWebkitCursorVisibility = 290,
    CSSPropertyWebkitFontSizeDelta = 291,
    CSSPropertyWebkitHyphenateCharacter = 292,
    CSSPropertyWebkitHyphenateLimitAfter = 293,
    CSSPropertyWebkitHyphenateLimitBefore = 294,
    CSSPropertyWebkitHyphenateLimitLines = 295,
    CSSPropertyWebkitHyphens = 296,
    CSSPropertyWebkitInitialLetter = 297,
    CSSPropertyWebkitLineAlign = 298,
    CSSPropertyWebkitLineBoxContain = 299,
    CSSPropertyWebkitLineClamp = 300,
    CSSPropertyWebkitLineGrid = 301,
    CSSPropertyWebkitLineSnap = 302,
    CSSPropertyWebkitMarqueeDirection = 303,
    CSSPropertyWebkitMarqueeIncrement = 304,
    CSSPropertyWebkitMarqueeRepetition = 305,
    CSSPropertyWebkitMarqueeSpeed = 306,
    CSSPropertyWebkitMarqueeStyle = 307,
    CSSPropertyWebkitMaskBoxImageOutset = 308,
    CSSPropertyWebkitMaskBoxImageRepeat = 309,
    CSSPropertyWebkitMaskBoxImageSlice = 310,
    CSSPropertyWebkitMaskBoxImageSource = 311,
    CSSPropertyWebkitMaskBoxImageWidth = 312,
    CSSPropertyWebkitMaskPositionX = 313,
    CSSPropertyWebkitMaskPositionY = 314,
    CSSPropertyWebkitNbspMode = 315,
    CSSPropertyWebkitRtlOrdering = 316,
    CSSPropertyWebkitTapHighlightColor = 317,
    CSSPropertyWebkitTextDecorationsInEffect = 318,
    CSSPropertyWebkitTextFillColor = 319,
    CSSPropertyWebkitTextSecurity = 320,
    CSSPropertyWebkitTextStrokeColor = 321,
    CSSPropertyWebkitTextStrokeWidth = 322,
    CSSPropertyWebkitUserDrag = 323,
    CSSPropertyWebkitUserModify = 324,
    CSSPropertyWebkitUserSelect = 325,
    CSSPropertyBackgroundClip = 326,
    CSSPropertyBackgroundOrigin = 327,
    CSSPropertyBlockSize = 328,
    CSSPropertyBorderBlockEndColor = 329,
    CSSPropertyBorderBlockEndStyle = 330,
    CSSPropertyBorderBlockEndWidth = 331,
    CSSPropertyBorderBlockStartColor = 332,
    CSSPropertyBorderBlockStartStyle = 333,
    CSSPropertyBorderBlockStartWidth = 334,
    CSSPropertyBorderBottomColor = 335,
    CSSPropertyBorderBottomLeftRadius = 336,
    CSSPropertyBorderBottomRightRadius = 337,
    CSSPropertyBorderBottomStyle = 338,
    CSSPropertyBorderBottomWidth = 339,
    CSSPropertyBorderEndEndRadius = 340,
    CSSPropertyBorderEndStartRadius = 341,
    CSSPropertyBorderInlineEndColor = 342,
    CSSPropertyBorderInlineEndStyle = 343,
    CSSPropertyBorderInlineEndWidth = 344,
    CSSPropertyBorderInlineStartColor = 345,
    CSSPropertyBorderInlineStartStyle = 346,
    CSSPropertyBorderInlineStartWidth = 347,
    CSSPropertyBorderLeftColor = 348,
    CSSPropertyBorderLeftStyle = 349,
    CSSPropertyBorderLeftWidth = 350,
    CSSPropertyBorderRightColor = 351,
    CSSPropertyBorderRightStyle = 352,
    CSSPropertyBorderRightWidth = 353,
    CSSPropertyBorderStartEndRadius = 354,
    CSSPropertyBorderStartStartRadius = 355,
    CSSPropertyBorderTopColor = 356,
    CSSPropertyBorderTopLeftRadius = 357,
    CSSPropertyBorderTopRightRadius = 358,
    CSSPropertyBorderTopStyle = 359,
    CSSPropertyBorderTopWidth = 360,
    CSSPropertyBottom = 361,
    CSSPropertyBoxShadow = 362,
    CSSPropertyContainIntrinsicBlockSize = 363,
    CSSPropertyContainIntrinsicHeight = 364,
    CSSPropertyContainIntrinsicInlineSize = 365,
    CSSPropertyContainIntrinsicWidth = 366,
    CSSPropertyHeight = 367,
    CSSPropertyInlineSize = 368,
    CSSPropertyInsetBlockEnd = 369,
    CSSPropertyInsetBlockStart = 370,
    CSSPropertyInsetInlineEnd = 371,
    CSSPropertyInsetInlineStart = 372,
    CSSPropertyLeft = 373,
    CSSPropertyMarginBlockEnd = 374,
    CSSPropertyMarginBlockStart = 375,
    CSSPropertyMarginBottom = 376,
    CSSPropertyMarginInlineEnd = 377,
    CSSPropertyMarginInlineStart = 378,
    CSSPropertyMarginLeft = 379,
    CSSPropertyMarginRight = 380,
    CSSPropertyMarginTop = 381,
    CSSPropertyMaskClip = 382,
    CSSPropertyMaskComposite = 383,
    CSSPropertyMaskMode = 384,
    CSSPropertyMaxBlockSize = 385,
    CSSPropertyMaxHeight = 386,
    CSSPropertyMaxInlineSize = 387,
    CSSPropertyMaxWidth = 388,
    CSSPropertyMinBlockSize = 389,
    CSSPropertyMinHeight = 390,
    CSSPropertyMinInlineSize = 391,
    CSSPropertyMinWidth = 392,
    CSSPropertyOverscrollBehaviorBlock = 393,
    CSSPropertyOverscrollBehaviorInline = 394,
    CSSPropertyOverscrollBehaviorX = 395,
    CSSPropertyOverscrollBehaviorY = 396,
    CSSPropertyPaddingBlockEnd = 397,
    CSSPropertyPaddingBlockStart = 398,
    CSSPropertyPaddingBottom = 399,
    CSSPropertyPaddingInlineEnd = 400,
    CSSPropertyPaddingInlineStart = 401,
    CSSPropertyPaddingLeft = 402,
    CSSPropertyPaddingRight = 403,
    CSSPropertyPaddingTop = 404,
    CSSPropertyRight = 405,
    CSSPropertyScrollMarginBlockEnd = 406,
    CSSPropertyScrollMarginBlockStart = 407,
    CSSPropertyScrollMarginBottom = 408,
    CSSPropertyScrollMarginInlineEnd = 409,
    CSSPropertyScrollMarginInlineStart = 410,
    CSSPropertyScrollMarginLeft = 411,
    CSSPropertyScrollMarginRight = 412,
    CSSPropertyScrollMarginTop = 413,
    CSSPropertyScrollPaddingBlockEnd = 414,
    CSSPropertyScrollPaddingBlockStart = 415,
    CSSPropertyScrollPaddingBottom = 416,
    CSSPropertyScrollPaddingInlineEnd = 417,
    CSSPropertyScrollPaddingInlineStart = 418,
    CSSPropertyScrollPaddingLeft = 419,
    CSSPropertyScrollPaddingRight = 420,
    CSSPropertyScrollPaddingTop = 421,
    CSSPropertyTextCombineUpright = 422,
    CSSPropertyTop = 423,
    CSSPropertyWidth = 424,
    CSSPropertyWebkitBackgroundClip = 425,
    CSSPropertyWebkitBackgroundOrigin = 426,
    CSSPropertyWebkitBoxShadow = 427,
    CSSPropertyWebkitMaskClip = 428,
    CSSPropertyWebkitMaskComposite = 429,
    CSSPropertyWebkitMaskSourceType = 430,
    CSSPropertyWebkitTextCombine = 431,
    CSSPropertyAll = 432,
    CSSPropertyAnimation = 433,
    CSSPropertyBackground = 434,
    CSSPropertyBackgroundPosition = 435,
    CSSPropertyBorder = 436,
    CSSPropertyBorderBlock = 437,
    CSSPropertyBorderBlockColor = 438,
    CSSPropertyBorderBlockEnd = 439,
    CSSPropertyBorderBlockStart = 440,
    CSSPropertyBorderBlockStyle = 441,
    CSSPropertyBorderBlockWidth = 442,
    CSSPropertyBorderBottom = 443,
    CSSPropertyBorderColor = 444,
    CSSPropertyBorderImage = 445,
    CSSPropertyBorderInline = 446,
    CSSPropertyBorderInlineColor = 447,
    CSSPropertyBorderInlineEnd = 448,
    CSSPropertyBorderInlineStart = 449,
    CSSPropertyBorderInlineStyle = 450,
    CSSPropertyBorderInlineWidth = 451,
    CSSPropertyBorderLeft = 452,
    CSSPropertyBorderRadius = 453,
    CSSPropertyBorderRight = 454,
    CSSPropertyBorderSpacing = 455,
    CSSPropertyBorderStyle = 456,
    CSSPropertyBorderTop = 457,
    CSSPropertyBorderWidth = 458,
    CSSPropertyColumnRule = 459,
    CSSPropertyColumns = 460,
    CSSPropertyContainIntrinsicSize = 461,
    CSSPropertyContainer = 462,
    CSSPropertyFlex = 463,
    CSSPropertyFlexFlow = 464,
    CSSPropertyFont = 465,
    CSSPropertyFontSynthesis = 466,
    CSSPropertyFontVariant = 467,
    CSSPropertyGap = 468,
    CSSPropertyGrid = 469,
    CSSPropertyGridArea = 470,
    CSSPropertyGridColumn = 471,
    CSSPropertyGridRow = 472,
    CSSPropertyGridTemplate = 473,
    CSSPropertyInset = 474,
    CSSPropertyInsetBlock = 475,
    CSSPropertyInsetInline = 476,
    CSSPropertyListStyle = 477,
    CSSPropertyMargin = 478,
    CSSPropertyMarginBlock = 479,
    CSSPropertyMarginInline = 480,
    CSSPropertyMarker = 481,
    CSSPropertyMask = 482,
    CSSPropertyMaskPosition = 483,
    CSSPropertyOffset = 484,
    CSSPropertyOutline = 485,
    CSSPropertyOverflow = 486,
    CSSPropertyOverscrollBehavior = 487,
    CSSPropertyPadding = 488,
    CSSPropertyPaddingBlock = 489,
    CSSPropertyPaddingInline = 490,
    CSSPropertyPageBreakAfter = 491,
    CSSPropertyPageBreakBefore = 492,
    CSSPropertyPageBreakInside = 493,
    CSSPropertyPerspectiveOrigin = 494,
    CSSPropertyPlaceContent = 495,
    CSSPropertyPlaceItems = 496,
    CSSPropertyPlaceSelf = 497,
    CSSPropertyScrollMargin = 498,
    CSSPropertyScrollMarginBlock = 499,
    CSSPropertyScrollMarginInline = 500,
    CSSPropertyScrollPadding = 501,
    CSSPropertyScrollPaddingBlock = 502,
    CSSPropertyScrollPaddingInline = 503,
    CSSPropertyTextDecoration = 504,
    CSSPropertyTextDecorationSkip = 505,
    CSSPropertyTextEmphasis = 506,
    CSSPropertyTransformOrigin = 507,
    CSSPropertyTransition = 508,
    CSSPropertyWebkitBackgroundSize = 509,
    CSSPropertyWebkitBorderImage = 510,
    CSSPropertyWebkitBorderRadius = 511,
    CSSPropertyWebkitColumnBreakAfter = 512,
    CSSPropertyWebkitColumnBreakBefore = 513,
    CSSPropertyWebkitColumnBreakInside = 514,
    CSSPropertyWebkitMask = 515,
    CSSPropertyWebkitMaskBoxImage = 516,
    CSSPropertyWebkitMaskPosition = 517,
    CSSPropertyWebkitPerspective = 518,
    CSSPropertyWebkitTextDecoration = 519,
    CSSPropertyWebkitTextOrientation = 520,
    CSSPropertyWebkitTextStroke = 521,
};

constexpr uint16_t firstCSSProperty = 2;
constexpr uint16_t numCSSProperties = 520;
constexpr unsigned maxCSSPropertyNameLength = 34;
constexpr auto firstTopPriorityProperty = CSSPropertyID::CSSPropertyColorScheme;
constexpr auto lastTopPriorityProperty = CSSPropertyID::CSSPropertyWebkitRubyPosition;
constexpr auto firstHighPriorityProperty = CSSPropertyID::CSSPropertyColor;
constexpr auto lastHighPriorityProperty = CSSPropertyID::CSSPropertyLetterSpacing;
constexpr auto firstLowPriorityProperty = CSSPropertyID::CSSPropertyAccentColor;
constexpr auto lastLowPriorityProperty = CSSPropertyID::CSSPropertyWebkitUserSelect;
constexpr auto firstDeferredProperty = CSSPropertyID::CSSPropertyBackgroundClip;
constexpr auto lastDeferredProperty = CSSPropertyID::CSSPropertyWebkitTextCombine;
constexpr auto firstShorthandProperty = CSSPropertyID::CSSPropertyAll;
constexpr auto lastShorthandProperty = CSSPropertyID::CSSPropertyWebkitTextStroke;
constexpr uint16_t numCSSPropertyLonghands = firstShorthandProperty - firstCSSProperty;
extern const std::array<CSSPropertyID, 400> computedPropertyIDs;

struct CSSPropertySettings {
    WTF_MAKE_STRUCT_FAST_ALLOCATED;

    bool CSSOMViewSmoothScrollingEnabled { false };
    bool accentColorEnabled { false };
    bool aspectRatioEnabled { false };
    bool colorFilterEnabled { false };
    bool cssContainIntrinsicSizeEnabled { false };
    bool cssContainerQueriesEnabled { false };
    bool cssContainmentEnabled { false };
    bool cssContentVisibilityEnabled { false };
    bool cssCounterStyleAtRulesEnabled { false };
    bool cssCustomPropertiesAndValuesEnabled { false };
    bool cssIndividualTransformPropertiesEnabled { false };
    bool cssInputSecurityEnabled { false };
    bool cssLeadingTrimEnabled { false };
    bool cssMarginTrimEnabled { false };
    bool cssMotionPathEnabled { false };
    bool cssScrollAnchoringEnabled { false };
    bool cssTextAlignLastEnabled { false };
    bool cssTextJustifyEnabled { false };
    bool masonryEnabled { false };
    bool overscrollBehaviorEnabled { false };
    bool textAutosizingEnabled { false };
    bool webAnimationsCompositeOperationsEnabled { false };

    CSSPropertySettings() = default;
    explicit CSSPropertySettings(const Settings&);
};

bool operator==(const CSSPropertySettings&, const CSSPropertySettings&);
inline bool operator!=(const CSSPropertySettings& a, const CSSPropertySettings& b) { return !(a == b); }
void add(Hasher&, const CSSPropertySettings&);

constexpr bool isLonghand(CSSPropertyID);
bool isInternal(CSSPropertyID);
bool isExposed(CSSPropertyID, const Settings*);
bool isExposed(CSSPropertyID, const Settings&);
bool isExposed(CSSPropertyID, const CSSPropertySettings*);
bool isExposed(CSSPropertyID, const CSSPropertySettings&);

CSSPropertyID findCSSProperty(const char* characters, unsigned length);
ASCIILiteral nameLiteral(CSSPropertyID);
const AtomString& nameString(CSSPropertyID);
String nameForIDL(CSSPropertyID);

CSSPropertyID relatedProperty(CSSPropertyID);

template<CSSPropertyID first, CSSPropertyID last> struct CSSPropertiesRange {
    struct Iterator {
        uint16_t index { static_cast<uint16_t>(first) };
        constexpr CSSPropertyID operator*() const { return static_cast<CSSPropertyID>(index); }
        constexpr Iterator& operator++() { ++index; return *this; }
        constexpr bool operator==(std::nullptr_t) const { return index > static_cast<uint16_t>(last); }
        constexpr bool operator!=(std::nullptr_t) const { return index <= static_cast<uint16_t>(last); }
    };
    static constexpr Iterator begin() { return { }; }
    static constexpr std::nullptr_t end() { return nullptr; }
    static constexpr uint16_t size() { return last - first + 1; }
};
using AllCSSPropertiesRange = CSSPropertiesRange<static_cast<CSSPropertyID>(firstCSSProperty), lastShorthandProperty>;
using AllLonghandCSSPropertiesRange = CSSPropertiesRange<static_cast<CSSPropertyID>(firstCSSProperty), lastDeferredProperty>;
constexpr AllCSSPropertiesRange allCSSProperties() { return { }; }
constexpr AllLonghandCSSPropertiesRange allLonghandCSSProperties() { return { }; }

constexpr bool isLonghand(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= firstCSSProperty && static_cast<uint16_t>(property) < static_cast<uint16_t>(firstShorthandProperty);
}

} // namespace WebCore

namespace WTF {

template<> struct DefaultHash<WebCore::CSSPropertyID> : IntHash<unsigned> { };

template<> struct HashTraits<WebCore::CSSPropertyID> : GenericHashTraits<WebCore::CSSPropertyID> {
    static const bool emptyValueIsZero = true;
    static void constructDeletedValue(WebCore::CSSPropertyID& slot) { slot = static_cast<WebCore::CSSPropertyID>(std::numeric_limits<uint16_t>::max()); }
    static bool isDeletedValue(WebCore::CSSPropertyID value) { return static_cast<uint16_t>(value) == std::numeric_limits<uint16_t>::max(); }
};

} // namespace WTF

namespace std {

template<> struct iterator_traits<WebCore::AllCSSPropertiesRange::Iterator> { using value_type = WebCore::CSSPropertyID; };
template<> struct iterator_traits<WebCore::AllLonghandCSSPropertiesRange::Iterator> { using value_type = WebCore::CSSPropertyID; };

} // namespace std

