/*
 * Copyright (C) 2013 Google Inc. All rights reserved.
 * Copyright (C) 2013-2016 Apple Inc. All rights reserved.
 * Copyright (C) 2014 University of Washington. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

// DO NOT EDIT THIS FILE. It is automatically generated from CombinedDomains.json by the script: Source/JavaScriptCore/inspector/scripts/generate-inspector-protocol-bindings.py

#pragma once

#include "InspectorProtocolObjects.h"
#include <wtf/JSONValues.h>
#include <wtf/text/WTFString.h>

namespace Inspector {

class FrontendRouter;

class JS_EXPORT_PRIVATE AnimationFrontendDispatcher {
    WTF_MAKE_FAST_ALLOCATED;
public:
    AnimationFrontendDispatcher(FrontendRouter& frontendRouter) : m_frontendRouter(frontendRouter) { }
    void animationCreated(Ref<Protocol::Animation::Animation>&& animation);
    void nameChanged(const String& animationId, const String& opt_name);
    void effectChanged(const String& animationId, RefPtr<Protocol::Animation::Effect>&& opt_effect);
    void targetChanged(const String& animationId);
    void animationDestroyed(const String& animationId);
    void trackingStart(double timestamp);
    void trackingUpdate(double timestamp, Ref<Protocol::Animation::TrackingUpdate>&& event);
    void trackingComplete(double timestamp);
private:
    FrontendRouter& m_frontendRouter;
};

class JS_EXPORT_PRIVATE ApplicationCacheFrontendDispatcher {
    WTF_MAKE_FAST_ALLOCATED;
public:
    ApplicationCacheFrontendDispatcher(FrontendRouter& frontendRouter) : m_frontendRouter(frontendRouter) { }
    void applicationCacheStatusUpdated(const String& frameId, const String& manifestURL, int status);
    void networkStateUpdated(bool isNowOnline);
private:
    FrontendRouter& m_frontendRouter;
};

class JS_EXPORT_PRIVATE BrowserFrontendDispatcher {
    WTF_MAKE_FAST_ALLOCATED;
public:
    BrowserFrontendDispatcher(FrontendRouter& frontendRouter) : m_frontendRouter(frontendRouter) { }
    void extensionsEnabled(Ref<JSON::ArrayOf<Protocol::Browser::Extension>>&& extensions);
    void extensionsDisabled(Ref<JSON::ArrayOf<String>>&& extensionIds);
private:
    FrontendRouter& m_frontendRouter;
};

#if defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE
class JS_EXPORT_PRIVATE CPUProfilerFrontendDispatcher {
    WTF_MAKE_FAST_ALLOCATED;
public:
    CPUProfilerFrontendDispatcher(FrontendRouter& frontendRouter) : m_frontendRouter(frontendRouter) { }
    void trackingStart(double timestamp);
    void trackingUpdate(Ref<Protocol::CPUProfiler::Event>&& event);
    void trackingComplete(double timestamp);
private:
    FrontendRouter& m_frontendRouter;
};
#endif // defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE

class JS_EXPORT_PRIVATE CSSFrontendDispatcher {
    WTF_MAKE_FAST_ALLOCATED;
public:
    CSSFrontendDispatcher(FrontendRouter& frontendRouter) : m_frontendRouter(frontendRouter) { }
    void mediaQueryResultChanged();
    void styleSheetChanged(const String& styleSheetId);
    void styleSheetAdded(Ref<Protocol::CSS::CSSStyleSheetHeader>&& header);
    void styleSheetRemoved(const String& styleSheetId);
    void nodeLayoutContextTypeChanged(int nodeId, std::optional<Protocol::CSS::LayoutContextType>&& opt_layoutContextType);
private:
    FrontendRouter& m_frontendRouter;
};

class JS_EXPORT_PRIVATE CanvasFrontendDispatcher {
    WTF_MAKE_FAST_ALLOCATED;
public:
    CanvasFrontendDispatcher(FrontendRouter& frontendRouter) : m_frontendRouter(frontendRouter) { }
    void canvasAdded(Ref<Protocol::Canvas::Canvas>&& canvas);
    void canvasRemoved(const String& canvasId);
    void canvasMemoryChanged(const String& canvasId, double memoryCost);
    void extensionEnabled(const String& canvasId, const String& extension);
    void clientNodesChanged(const String& canvasId);
    void recordingStarted(const String& canvasId, Protocol::Recording::Initiator initiator);
    void recordingProgress(const String& canvasId, Ref<JSON::ArrayOf<Protocol::Recording::Frame>>&& frames, int bufferUsed);
    void recordingFinished(const String& canvasId, RefPtr<Protocol::Recording::Recording>&& opt_recording);
#if defined(ENABLE_WEBGL) && ENABLE_WEBGL
    void programCreated(Ref<Protocol::Canvas::ShaderProgram>&& shaderProgram);
#endif // defined(ENABLE_WEBGL) && ENABLE_WEBGL
#if defined(ENABLE_WEBGL) && ENABLE_WEBGL
    void programDeleted(const String& programId);
#endif // defined(ENABLE_WEBGL) && ENABLE_WEBGL
private:
    FrontendRouter& m_frontendRouter;
};

class JS_EXPORT_PRIVATE ConsoleFrontendDispatcher {
    WTF_MAKE_FAST_ALLOCATED;
public:
    ConsoleFrontendDispatcher(FrontendRouter& frontendRouter) : m_frontendRouter(frontendRouter) { }
    void messageAdded(Ref<Protocol::Console::ConsoleMessage>&& message);
    void messageRepeatCountUpdated(int count);
    void messagesCleared();
    void heapSnapshot(double timestamp, const String& snapshotData, const String& opt_title);
private:
    FrontendRouter& m_frontendRouter;
};

class JS_EXPORT_PRIVATE DOMFrontendDispatcher {
    WTF_MAKE_FAST_ALLOCATED;
public:
    DOMFrontendDispatcher(FrontendRouter& frontendRouter) : m_frontendRouter(frontendRouter) { }
    void documentUpdated();
    void inspect(int nodeId);
    void setChildNodes(int parentId, Ref<JSON::ArrayOf<Protocol::DOM::Node>>&& nodes);
    void attributeModified(int nodeId, const String& name, const String& value);
    void attributeRemoved(int nodeId, const String& name);
    void inlineStyleInvalidated(Ref<JSON::ArrayOf<int>>&& nodeIds);
    void characterDataModified(int nodeId, const String& characterData);
    void childNodeCountUpdated(int nodeId, int childNodeCount);
    void childNodeInserted(int parentNodeId, int previousNodeId, Ref<Protocol::DOM::Node>&& node);
    void childNodeRemoved(int parentNodeId, int nodeId);
    void willDestroyDOMNode(int nodeId);
    void shadowRootPushed(int hostId, Ref<Protocol::DOM::Node>&& root);
    void shadowRootPopped(int hostId, int rootId);
    void customElementStateChanged(int nodeId, Protocol::DOM::CustomElementState customElementState);
    void pseudoElementAdded(int parentId, Ref<Protocol::DOM::Node>&& pseudoElement);
    void pseudoElementRemoved(int parentId, int pseudoElementId);
    void didAddEventListener(int nodeId);
    void willRemoveEventListener(int nodeId);
    void didFireEvent(int nodeId, const String& eventName, double timestamp, RefPtr<JSON::Object>&& opt_data);
#if defined(ENABLE_VIDEO) && ENABLE_VIDEO
    void powerEfficientPlaybackStateChanged(int nodeId, double timestamp, bool isPowerEfficient);
#endif // defined(ENABLE_VIDEO) && ENABLE_VIDEO
private:
    FrontendRouter& m_frontendRouter;
};

class JS_EXPORT_PRIVATE DOMStorageFrontendDispatcher {
    WTF_MAKE_FAST_ALLOCATED;
public:
    DOMStorageFrontendDispatcher(FrontendRouter& frontendRouter) : m_frontendRouter(frontendRouter) { }
    void domStorageItemsCleared(Ref<Protocol::DOMStorage::StorageId>&& storageId);
    void domStorageItemRemoved(Ref<Protocol::DOMStorage::StorageId>&& storageId, const String& key);
    void domStorageItemAdded(Ref<Protocol::DOMStorage::StorageId>&& storageId, const String& key, const String& newValue);
    void domStorageItemUpdated(Ref<Protocol::DOMStorage::StorageId>&& storageId, const String& key, const String& oldValue, const String& newValue);
private:
    FrontendRouter& m_frontendRouter;
};

class JS_EXPORT_PRIVATE DatabaseFrontendDispatcher {
    WTF_MAKE_FAST_ALLOCATED;
public:
    DatabaseFrontendDispatcher(FrontendRouter& frontendRouter) : m_frontendRouter(frontendRouter) { }
    void addDatabase(Ref<Protocol::Database::Database>&& database);
private:
    FrontendRouter& m_frontendRouter;
};

class JS_EXPORT_PRIVATE DebuggerFrontendDispatcher {
    WTF_MAKE_FAST_ALLOCATED;
public:
    DebuggerFrontendDispatcher(FrontendRouter& frontendRouter) : m_frontendRouter(frontendRouter) { }
    void globalObjectCleared();
    void scriptParsed(const String& scriptId, const String& url, int startLine, int startColumn, int endLine, int endColumn, std::optional<bool>&& opt_isContentScript, const String& opt_sourceURL, const String& opt_sourceMapURL, std::optional<bool>&& opt_module);
    void scriptFailedToParse(const String& url, const String& scriptSource, int startLine, int errorLine, const String& errorMessage);
    void breakpointResolved(const String& breakpointId, Ref<Protocol::Debugger::Location>&& location);
        // Named after parameter 'reason' while generating command/event paused.
        enum class Reason {
            XHR = 156,
            Fetch = 157,
            DOM = 257,
            AnimationFrame = 258,
            Interval = 259,
            Listener = 260,
            Timeout = 170,
            Exception = 261,
            Assert = 91,
            CSPViolation = 262,
            DebuggerStatement = 263,
            Breakpoint = 264,
            PauseOnNextStatement = 265,
            Microtask = 227,
            BlackboxedScript = 266,
            Other = 74,
        }; // enum class Reason
    void paused(Ref<JSON::ArrayOf<Protocol::Debugger::CallFrame>>&& callFrames, const String& reason, RefPtr<JSON::Object>&& opt_data, RefPtr<Protocol::Console::StackTrace>&& opt_asyncStackTrace);
    void resumed();
    void didSampleProbe(Ref<Protocol::Debugger::ProbeSample>&& sample);
    void playBreakpointActionSound(int breakpointActionId);
private:
    FrontendRouter& m_frontendRouter;
};

class JS_EXPORT_PRIVATE DialogFrontendDispatcher {
    WTF_MAKE_FAST_ALLOCATED;
public:
    DialogFrontendDispatcher(FrontendRouter& frontendRouter) : m_frontendRouter(frontendRouter) { }
    void javascriptDialogOpening(const String& type, const String& message, const String& opt_defaultPrompt);
private:
    FrontendRouter& m_frontendRouter;
};

class JS_EXPORT_PRIVATE HeapFrontendDispatcher {
    WTF_MAKE_FAST_ALLOCATED;
public:
    HeapFrontendDispatcher(FrontendRouter& frontendRouter) : m_frontendRouter(frontendRouter) { }
    void garbageCollected(Ref<Protocol::Heap::GarbageCollection>&& collection);
    void trackingStart(double timestamp, const String& snapshotData);
    void trackingComplete(double timestamp, const String& snapshotData);
private:
    FrontendRouter& m_frontendRouter;
};

class JS_EXPORT_PRIVATE InspectorFrontendDispatcher {
    WTF_MAKE_FAST_ALLOCATED;
public:
    InspectorFrontendDispatcher(FrontendRouter& frontendRouter) : m_frontendRouter(frontendRouter) { }
    void evaluateForTestInFrontend(const String& script);
    void inspect(Ref<Protocol::Runtime::RemoteObject>&& object, Ref<JSON::Object>&& hints);
private:
    FrontendRouter& m_frontendRouter;
};

class JS_EXPORT_PRIVATE LayerTreeFrontendDispatcher {
    WTF_MAKE_FAST_ALLOCATED;
public:
    LayerTreeFrontendDispatcher(FrontendRouter& frontendRouter) : m_frontendRouter(frontendRouter) { }
    void layerTreeDidChange();
private:
    FrontendRouter& m_frontendRouter;
};

#if defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE
class JS_EXPORT_PRIVATE MemoryFrontendDispatcher {
    WTF_MAKE_FAST_ALLOCATED;
public:
    MemoryFrontendDispatcher(FrontendRouter& frontendRouter) : m_frontendRouter(frontendRouter) { }
        // Named after parameter 'severity' while generating command/event memoryPressure.
        enum class Severity {
            Critical = 267,
            NonCritical = 268,
        }; // enum class Severity
    void memoryPressure(double timestamp, const String& severity);
    void trackingStart(double timestamp);
    void trackingUpdate(Ref<Protocol::Memory::Event>&& event);
    void trackingComplete(double timestamp);
private:
    FrontendRouter& m_frontendRouter;
};
#endif // defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE

class JS_EXPORT_PRIVATE NetworkFrontendDispatcher {
    WTF_MAKE_FAST_ALLOCATED;
public:
    NetworkFrontendDispatcher(FrontendRouter& frontendRouter) : m_frontendRouter(frontendRouter) { }
    void requestWillBeSent(const String& requestId, const String& frameId, const String& loaderId, const String& documentURL, Ref<Protocol::Network::Request>&& request, double timestamp, double walltime, Ref<Protocol::Network::Initiator>&& initiator, RefPtr<Protocol::Network::Response>&& opt_redirectResponse, std::optional<Protocol::Page::ResourceType>&& opt_type, const String& opt_targetId);
    void responseReceived(const String& requestId, const String& frameId, const String& loaderId, double timestamp, Protocol::Page::ResourceType type, Ref<Protocol::Network::Response>&& response);
    void dataReceived(const String& requestId, double timestamp, int dataLength, int encodedDataLength);
    void loadingFinished(const String& requestId, double timestamp, const String& opt_sourceMapURL, RefPtr<Protocol::Network::Metrics>&& opt_metrics);
    void loadingFailed(const String& requestId, double timestamp, const String& errorText, std::optional<bool>&& opt_canceled);
    void requestServedFromMemoryCache(const String& requestId, const String& frameId, const String& loaderId, const String& documentURL, double timestamp, Ref<Protocol::Network::Initiator>&& initiator, Ref<Protocol::Network::CachedResource>&& resource);
    void requestIntercepted(const String& requestId, Ref<Protocol::Network::Request>&& request);
    void responseIntercepted(const String& requestId, Ref<Protocol::Network::Response>&& response);
    void webSocketWillSendHandshakeRequest(const String& requestId, double timestamp, double walltime, Ref<Protocol::Network::WebSocketRequest>&& request);
    void webSocketHandshakeResponseReceived(const String& requestId, double timestamp, Ref<Protocol::Network::WebSocketResponse>&& response);
    void webSocketCreated(const String& requestId, const String& url);
    void webSocketClosed(const String& requestId, double timestamp);
    void webSocketFrameReceived(const String& requestId, double timestamp, Ref<Protocol::Network::WebSocketFrame>&& response);
    void webSocketFrameError(const String& requestId, double timestamp, const String& errorMessage);
    void webSocketFrameSent(const String& requestId, double timestamp, Ref<Protocol::Network::WebSocketFrame>&& response);
private:
    FrontendRouter& m_frontendRouter;
};

class JS_EXPORT_PRIVATE PageFrontendDispatcher {
    WTF_MAKE_FAST_ALLOCATED;
public:
    PageFrontendDispatcher(FrontendRouter& frontendRouter) : m_frontendRouter(frontendRouter) { }
    void domContentEventFired(double timestamp, const String& frameId);
    void loadEventFired(double timestamp, const String& frameId);
    void frameNavigated(Ref<Protocol::Page::Frame>&& frame);
    void frameAttached(const String& frameId, const String& opt_parentFrameId);
    void frameDetached(const String& frameId);
    void frameStartedLoading(const String& frameId);
    void frameStoppedLoading(const String& frameId);
    void frameScheduledNavigation(const String& frameId, double delay);
    void frameClearedScheduledNavigation(const String& frameId);
    void navigatedWithinDocument(const String& frameId, const String& url);
#if (defined(ENABLE_DARK_MODE_CSS) && ENABLE_DARK_MODE_CSS) || (defined(HAVE_OS_DARK_MODE_SUPPORT) && HAVE_OS_DARK_MODE_SUPPORT)
    void defaultAppearanceDidChange(Protocol::Page::Appearance appearance);
#endif // (defined(ENABLE_DARK_MODE_CSS) && ENABLE_DARK_MODE_CSS) || (defined(HAVE_OS_DARK_MODE_SUPPORT) && HAVE_OS_DARK_MODE_SUPPORT)
    void willCheckNavigationPolicy(const String& frameId);
    void didCheckNavigationPolicy(const String& frameId, std::optional<bool>&& opt_cancel);
    void fileChooserOpened(const String& frameId, Ref<Protocol::Runtime::RemoteObject>&& element);
private:
    FrontendRouter& m_frontendRouter;
};

class JS_EXPORT_PRIVATE PlaywrightFrontendDispatcher {
    WTF_MAKE_FAST_ALLOCATED;
public:
    PlaywrightFrontendDispatcher(FrontendRouter& frontendRouter) : m_frontendRouter(frontendRouter) { }
    void pageProxyCreated(const String& browserContextId, const String& pageProxyId, const String& opt_openerId);
    void pageProxyDestroyed(const String& pageProxyId);
    void provisionalLoadFailed(const String& pageProxyId, const String& loaderId, const String& error);
    void windowOpen(const String& pageProxyId, const String& url, Ref<JSON::ArrayOf<String>>&& windowFeatures);
    void downloadCreated(const String& pageProxyId, const String& frameId, const String& uuid, const String& url);
    void downloadFilenameSuggested(const String& uuid, const String& suggestedFilename);
    void downloadFinished(const String& uuid, const String& error);
    void screencastFinished(const String& screencastId);
private:
    FrontendRouter& m_frontendRouter;
};

class JS_EXPORT_PRIVATE RuntimeFrontendDispatcher {
    WTF_MAKE_FAST_ALLOCATED;
public:
    RuntimeFrontendDispatcher(FrontendRouter& frontendRouter) : m_frontendRouter(frontendRouter) { }
    void executionContextCreated(Ref<Protocol::Runtime::ExecutionContextDescription>&& context);
private:
    FrontendRouter& m_frontendRouter;
};

class JS_EXPORT_PRIVATE ScreencastFrontendDispatcher {
    WTF_MAKE_FAST_ALLOCATED;
public:
    ScreencastFrontendDispatcher(FrontendRouter& frontendRouter) : m_frontendRouter(frontendRouter) { }
    void screencastFrame(const String& data, int deviceWidth, int deviceHeight);
private:
    FrontendRouter& m_frontendRouter;
};

class JS_EXPORT_PRIVATE ScriptProfilerFrontendDispatcher {
    WTF_MAKE_FAST_ALLOCATED;
public:
    ScriptProfilerFrontendDispatcher(FrontendRouter& frontendRouter) : m_frontendRouter(frontendRouter) { }
    void trackingStart(double timestamp);
    void trackingUpdate(Ref<Protocol::ScriptProfiler::Event>&& event);
    void trackingComplete(double timestamp, RefPtr<Protocol::ScriptProfiler::Samples>&& opt_samples);
private:
    FrontendRouter& m_frontendRouter;
};

class JS_EXPORT_PRIVATE TargetFrontendDispatcher {
    WTF_MAKE_FAST_ALLOCATED;
public:
    TargetFrontendDispatcher(FrontendRouter& frontendRouter) : m_frontendRouter(frontendRouter) { }
    void targetCreated(Ref<Protocol::Target::TargetInfo>&& targetInfo);
    void targetDestroyed(const String& targetId, bool crashed);
    void didCommitProvisionalTarget(const String& oldTargetId, const String& newTargetId);
    void dispatchMessageFromTarget(const String& targetId, const String& message);
private:
    FrontendRouter& m_frontendRouter;
};

class JS_EXPORT_PRIVATE TimelineFrontendDispatcher {
    WTF_MAKE_FAST_ALLOCATED;
public:
    TimelineFrontendDispatcher(FrontendRouter& frontendRouter) : m_frontendRouter(frontendRouter) { }
    void eventRecorded(Ref<Protocol::Timeline::TimelineEvent>&& record);
    void recordingStarted(double startTime);
    void recordingStopped(double endTime);
    void autoCaptureStarted();
private:
    FrontendRouter& m_frontendRouter;
};

class JS_EXPORT_PRIVATE WorkerFrontendDispatcher {
    WTF_MAKE_FAST_ALLOCATED;
public:
    WorkerFrontendDispatcher(FrontendRouter& frontendRouter) : m_frontendRouter(frontendRouter) { }
    void workerCreated(const String& workerId, const String& url, const String& name, const String& frameId);
    void workerTerminated(const String& workerId);
    void dispatchMessageFromWorker(const String& workerId, const String& message);
private:
    FrontendRouter& m_frontendRouter;
};

} // namespace Inspector
