/*
 * Copyright (C) 2021 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#include "IDLTypes.h"
#include "JSDOMAsyncIterator.h"
#include "JSFileSystemDirectoryHandle.h"

namespace WebCore {

class FileSystemHandle;

struct JSFileSystemDirectoryHandleIteratorTraits {
    static constexpr JSDOMAsyncIteratorType type = JSDOMAsyncIteratorType::Map;
    using KeyType = IDLByteString;
    using ValueType = IDLInterface<FileSystemHandle>;
};

// FIXME: After webkit.org/b/231243, this class should be automatically generated by bindings code generator.
class JSFileSystemDirectoryHandleIterator final : public JSDOMAsyncIteratorBase<JSFileSystemDirectoryHandle, JSFileSystemDirectoryHandleIteratorTraits, JSFileSystemDirectoryHandleIterator> {
public:
    using Base = JSDOMAsyncIteratorBase<JSFileSystemDirectoryHandle, JSFileSystemDirectoryHandleIteratorTraits, JSFileSystemDirectoryHandleIterator>;
    DECLARE_INFO;

    template<typename CellType, JSC::SubspaceAccess mode>
    static JSC::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        if constexpr (mode == JSC::SubspaceAccess::Concurrently)
            return nullptr;
        return subspaceForImpl(vm);
    }
    static JSC::IsoSubspace* subspaceForImpl(JSC::VM&);

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

    static JSFileSystemDirectoryHandleIterator* create(JSC::VM& vm, JSC::Structure* structure, JSFileSystemDirectoryHandle& iteratedObject, IterationKind kind)
    {
        auto* instance = new (NotNull, JSC::allocateCell<JSFileSystemDirectoryHandleIterator>(vm.heap)) JSFileSystemDirectoryHandleIterator(structure, iteratedObject, kind);
        instance->finishCreation(vm);
        return instance;
    }

    JSC::JSBoundFunction* createOnSettledFunction(JSC::JSGlobalObject*);
    JSC::JSBoundFunction* createOnFulfilledFunction(JSC::JSGlobalObject*);
    JSC::JSBoundFunction* createOnRejectedFunction(JSC::JSGlobalObject*);

private:
    JSFileSystemDirectoryHandleIterator(JSC::Structure* structure, JSFileSystemDirectoryHandle& iteratedObject, IterationKind kind)
        : Base(structure, iteratedObject, kind)
    {
    }
};

using JSFileSystemDirectoryHandleIteratorPrototype = JSDOMAsyncIteratorPrototype<JSFileSystemDirectoryHandle, JSFileSystemDirectoryHandleIteratorTraits, JSFileSystemDirectoryHandleIterator>;
using JSFileSystemDirectoryHandleIteratorBase = JSFileSystemDirectoryHandleIterator::Base;

} // namespace WebCore
