/*
 * Decompiled with CFR 0.152.
 */
package kawa.standard;

import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ModuleContext;
import gnu.lists.ImmutablePair;
import gnu.lists.LList;
import gnu.mapping.SimpleSymbol;
import gnu.mapping.Symbol;
import java.util.ArrayList;
import java.util.List;
import kawa.lang.SyntaxForm;
import kawa.lang.Translator;

public class IfFeature {
    private static List<String> coreFeatures = new ArrayList<String>();
    public static final String PROVIDE_PREFIX = "%provide%";

    public static boolean testFeature(Object form) {
        if (form instanceof SyntaxForm) {
            SyntaxForm sf = (SyntaxForm)form;
            form = sf.getDatum();
        }
        if ((form = ((Translator)Compilation.getCurrent()).namespaceResolve(form)) instanceof String || form instanceof SimpleSymbol) {
            return IfFeature.hasFeature(form.toString());
        }
        return false;
    }

    public static boolean hasFeature(String name) {
        String classExistsPrefix;
        int i = coreFeatures.size();
        while (--i >= 0) {
            if (name != coreFeatures.get(i)) continue;
            return true;
        }
        if (name == "in-http-server" || name == "in-servlet") {
            int mflags = ModuleContext.getContext().getFlags();
            if (name == "in-http-server") {
                return (mflags & ModuleContext.IN_HTTP_SERVER) != 0;
            }
            if (name == "in-servlet") {
                return (mflags & ModuleContext.IN_SERVLET) != 0;
            }
        }
        if (name.startsWith(classExistsPrefix = "class-exists:")) {
            name = name.substring(classExistsPrefix.length());
            try {
                Class.forName(name, false, IfFeature.class.getClassLoader());
                return true;
            }
            catch (ClassNotFoundException ex) {
                return false;
            }
        }
        SimpleSymbol provide_symbol = Symbol.valueOf(PROVIDE_PREFIX + name);
        Declaration decl = Compilation.getCurrent().lookup(provide_symbol, -1);
        return decl != null && !decl.getFlag(65536L);
    }

    public static LList featureList() {
        LList result = LList.Empty;
        int i = coreFeatures.size();
        while (--i >= 0) {
            String item = coreFeatures.get(i);
            result = new ImmutablePair(Symbol.valueOf(item), result);
        }
        return result;
    }

    public static boolean isProvide(Declaration decl) {
        return decl.getName().startsWith(PROVIDE_PREFIX);
    }

    static {
        coreFeatures.add("complex");
        coreFeatures.add("exact-complex");
        coreFeatures.add("full-unicode");
        coreFeatures.add("kawa");
        coreFeatures.add("ratios");
        coreFeatures.add("srfi-0");
        coreFeatures.add("srfi-4");
        coreFeatures.add("srfi-6");
        coreFeatures.add("srfi-8");
        coreFeatures.add("srfi-9");
        coreFeatures.add("srfi-11");
        coreFeatures.add("srfi-16");
        coreFeatures.add("srfi-17");
        coreFeatures.add("srfi-23");
        coreFeatures.add("srfi-25");
        coreFeatures.add("srfi-26");
        coreFeatures.add("srfi-28");
        coreFeatures.add("srfi-30");
        coreFeatures.add("srfi-39");
        try {
            Class.forName("java.text.Normalizer");
            coreFeatures.add("string-normalize-unicode");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        coreFeatures.add("threads");
    }
}

