##################################################################
####      hullbogeys.nas - ePilot                             ####
####                                                          ####
####    Main Hull Bogey management. Controls initial load     ####
####    fuselage configuration and hull bogey positioning,    ####
####    hydrodynamic drag, hull side forces                   ####
####                                                          ####
##################################################################

var movehullbogeys = func {

  var surface=getprop("fdm/jsbsim/ground/solid");
  var speed=getprop("/velocities/groundspeed-kt");

  if(surface) {
# Lower hard structures below median
    setprop("fdm/jsbsim/contact/unit[9]/z-position", -90);
    setprop("fdm/jsbsim/contact/unit[10]/z-position", -95);
    setprop("fdm/jsbsim/contact/unit[11]/z-position", -45.48);
    setprop("fdm/jsbsim/contact/unit[12]/z-position", -45.48);
# and raise water support structures
    setprop("fdm/jsbsim/contact/unit[3]/z-position", 87.0);
    setprop("fdm/jsbsim/contact/unit[4]/z-position", 89.0);
    setprop("fdm/jsbsim/contact/unit[5]/z-position", 40.0);
    setprop("fdm/jsbsim/contact/unit[6]/z-position", 40.0);
    setprop("fdm/jsbsim/contact/unit[7]/z-position", 30.0);
    setprop("fdm/jsbsim/contact/unit[8]/z-position", 30.0);

  } else {

# Raise hard structures below median
    setprop("fdm/jsbsim/contact/unit[9]/z-position", 90);
    setprop("fdm/jsbsim/contact/unit[10]/z-position", 95);
    setprop("fdm/jsbsim/contact/unit[11]/z-position", 45.48);
    setprop("fdm/jsbsim/contact/unit[12]/z-position", 45.48);
# and lower water support structures
#nose planing
    var new_z=((-87) - (speed/3));
    if (new_z < -103) {new_z=-103};
    setprop("fdm/jsbsim/contact/unit[3]/z-position", new_z);
# hull step planing
    var new_z=((-89) - (speed/6));
    if (new_z < -94) {new_z=-94};
    setprop("fdm/jsbsim/contact/unit[4]/z-position", -89.0);
# outrigger float planing
    var new_z=((-40) - (speed/3));
    if (new_z < -52) {new_z=-52};
    setprop("fdm/jsbsim/contact/unit[5]/z-position", new_z);
    setprop("fdm/jsbsim/contact/unit[6]/z-position", new_z);
    setprop("fdm/jsbsim/contact/unit[7]/z-position", new_z+10);
    setprop("fdm/jsbsim/contact/unit[8]/z-position", new_z+10);

  }

settimer(movehullbogeys, 1.0);
}

setlistener("/sim/signals/fdm-initialized", movehullbogeys);


##############################  water drag  #############################################


var bogeydrag = func {
  var running = getprop("/engines/engine[0]/running");
  var on_water = getprop("/fdm/jsbsim/contact/unit[4]/compression-ft") > 0;

    if (running and on_water) {

      var speed = getprop("/velocities/groundspeed-kt");
      var throttle = getprop("/controls/engines/engine[0]/throttle");

      var coeff = (0.15 + (speed/500) - (throttle/3));
      if (coeff < 0) {coeff = 0};

#     setprop("sim/messages/copilot", "Setting Hull to " ~ coeff);

      setprop("fdm/jsbsim/contact/unit[3]/dynamic_friction_coeff", coeff);
      setprop("fdm/jsbsim/contact/unit[4]/dynamic_friction_coeff", coeff);
      setprop("fdm/jsbsim/contact/unit[5]/dynamic_friction_coeff", coeff * 2);
      setprop("fdm/jsbsim/contact/unit[6]/dynamic_friction_coeff", coeff * 2);
    }
settimer(bogeydrag, 0.25);
}
bogeydrag();


#var leftoutriggerdrag = func {
#  var running = getprop("/engines/engine[0]/running");
#  var depth = getprop("/fdm/jsbsim/contact/unit[5]/compression-ft");

#    if (running and depth) {

#      var speed = getprop("/velocities/groundspeed-kt");
#      var throttle = getprop("/controls/engines/engine[0]/throttle");

#      var coeff = (0.15 + (speed/500) - (throttle/3) + (depth/5));
#      if (coeff < 0) {coeff = 0};

#      setprop("sim/messages/copilot", "Setting Left to " ~ coeff);

#      setprop("fdm/jsbsim/contact/unit[5]/dynamic_friction_coeff", coeff);
#    }
#settimer(leftoutriggerdrag, 0.25);
#}
#leftoutriggerdrag();

#var rightoutriggerdrag = func {
#  var running = getprop("/engines/engine[0]/running");
#  var depth = getprop("/fdm/jsbsim/contact/unit[8]/compression-ft");

#    if (running and depth) {

#      var speed = getprop("/velocities/groundspeed-kt");
#      var throttle = getprop("/controls/engines/engine[0]/throttle");

#      var coeff = (0.15 + (speed/500) - (throttle/3) + (depth/5));
#      if (coeff < 0) {coeff = 0};

#      setprop("sim/messages/copilot", "Setting Right to " ~ coeff);

#      setprop("fdm/jsbsim/contact/unit[8]/dynamic_friction_coeff", coeff);
#    }
#settimer(rightoutriggerdrag, 0.25);
#}
#rightoutriggerdrag();

