# LX Navigation LX8080 simulation

#	References:
#		LX.1	User Manual (90xx/80xx)		http://www.lx-avionik.de/wp/download/manuals/lx90xx-80xxUserManualEnglishVer802rev38.pdf
#		LX.2	Installation Manual (90xx/80xx)	http://www.lx-avionik.de/wp/download/manuals/lx90xx-80xxInstallationManualEnglish_rev23.pdf
#		LX.3	Manufacturer webpage		http://www.lx-avionik.de/produkte/lx8080/#variotec
#		LX.4	LX8000/LX8080 Manual		http://www.lx-avionik.de/wp/download/manuals/LX8080ManualEnglishVer0260.pdf

#	Screen Resolution (ref. LX.3):	320px * 240px

var LX8080_nav_pages = [nil, nil, nil, nil];
var LX8080_start = nil;
var LX8080_display = nil;


var canvas_LX8080_base = {
	init: func(canvas_group, file) {
		var font_mapper = func(family, weight) {
			if ( weight == "bold" ) {
				return "LiberationFonts/LiberationSans-Bold.ttf";
			} else {
				return "LiberationFonts/LiberationSans-Regular.ttf";
			}
		};

		
		canvas.parsesvg(canvas_group, file, {'font-mapper': font_mapper});

		var svg_keys = me.getKeys();
		foreach (var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);
			var clip_el = canvas_group.getElementById(key ~ "_clip");
			if (clip_el != nil) {
				clip_el.setVisible(0);
				var tran_rect = clip_el.getTransformedBounds();
				var clip_rect = sprintf("rect(%d,%d, %d,%d)", 
				tran_rect[1], # 0 ys
				tran_rect[2], # 1 xe
				tran_rect[3], # 2 ye
				tran_rect[0]); #3 xs
				#   coordinates are top,right,bottom,left (ys, xe, ye, xs) ref: l621 of simgear/canvas/CanvasElement.cxx
				me[key].set("clip", clip_rect);
				me[key].set("clip-frame", canvas.Element.PARENT);
			}
		}

		me.page = canvas_group;

		return me;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
		var volt = volts.getValue();
		var start_v = start.getValue();
		if ( start_v == 1 and volt > 9 ) {
			if( !active ){
				active = 1;
				active_p.setBoolValue( 1 );
			}
			LX8080_start.page.hide();
			var pg = page.getIntValue();
			if( pg < 1 or pg > 4 ){ 
				print( "LX8080: Invalid Active Page Set: "~ pg );
				return;
			}
			forindex( var i; LX8080_nav_pages ){
				if( i != ( pg - 1 ) ){
					LX8080_nav_pages[ i ].hide();
				} else {
					LX8080_nav_pages[ i ].show();
					LX8080_nav_pages[ i ].update();
				}
			}
		} else if ( start_v > 0 and start_v < 1 and volt > 9){
			if( active ){
				active = 0;
				active_p.setBoolValue( 0 );
			}
			
			LX8080_start.page.show();
			
			foreach( var el; LX8080_nav_pages ){
				el.hide();
			}
		} else {
			if( active ){
				active = 0;
				active_p.setBoolValue( 0 );
			}
			
			LX8080_start.page.hide();
			
			foreach( var el; LX8080_nav_pages ){
				el.hide();
			}
		}
	},
};


var canvas_LX8080_start = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_LX8080_start, canvas_LX8080_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return [];
	},
	hide: func() {
		me.page.hide();
	},
	show: func() {
		me.page.show();
	},
	
};

var canvas_LX8080_nav_3 = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_LX8080_nav_3, canvas_LX8080_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return [ "time.text", "trk.deg", "brg.deg", "wind.text", "alt_igc", "alt_inv", "fl", "pot_temp.degc", "oat.degc", "batt.v" ];
	},
	update: func() {
		me["time.text"].setText(sprintf("%02d", time_hr.getValue()) ~ ":" ~ sprintf("%02d", time_min.getValue()));
		
		me["trk.deg"].setText(sprintf("%3d", math.round(hdg_trk.getValue())));
		me["wind.text"].setText(sprintf("%3d", math.round(wind_deg.getDoubleValue())) ~ "/" ~ sprintf("%2d", math.round(wind_kt.getDoubleValue())));
		
		me["alt_igc"].setText( sprintf("%4d", math.round( alti_ft.getDoubleValue() * FT2M )));
		me["alt_inv"].setText( sprintf("%4d", math.round( alti_ft.getDoubleValue() )));
		me["fl"].setText( sprintf("%3d", math.round( alti_press_ft.getDoubleValue() / 100 ) ));
		
		#	Calculate potential temperature (ref: https://en.wikipedia.org/wiki/Potential_temperature): pot_temp = abs_temp * ( 1000 hpa / press ) ^ 0.286
		me["pot_temp.degc"].setText( sprintf( "%3d", math.round( ( oat_degc.getDoubleValue() + 273.15 ) * math.pow( ( 1000 / ( stat_press.getDoubleValue() * 33.86389 ) ), 0.286 ) - 273.15 ) ) ~ "°" );
		me["oat.degc"].setText( sprintf("%3d", math.round( oat_degc.getDoubleValue() ) ) ~ "°");
	},
	hide: func() {
		me.page.hide();
	},
	show: func() {
		me.page.show();
	},
	
};
var canvas_LX8080_nav_4 = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_LX8080_nav_4, canvas_LX8080_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return [ "time.text" ];
	},
	update: func() {
		me["time.text"].setText(sprintf("%02d", time_hr.getValue()) ~ ":" ~ sprintf("%02d", time_min.getValue()));
	},
	hide: func() {
		me.page.hide();
	},
	show: func() {
		me.page.show();
	},
	
};


var ls = setlistener("sim/signals/fdm-initialized", func {
	LX8080_display = canvas.new({
		"name": "LX8080",
		"size": [320, 240],
		"view": [320, 240],
		"mipmapping": 1
	});
	LX8080_display.addPlacement({"node": "lx8080.screen"});
	var groupMain = [ LX8080_display.createGroup(), LX8080_display.createGroup(), LX8080_display.createGroup(), LX8080_display.createGroup()];
	var groupStart = LX8080_display.createGroup();
	
	LX8080_nav_pages[0] = canvas_nd.new(groupMain[0], 1);
	LX8080_nav_pages[1] = canvas_nd.new(groupMain[1], 2);
	LX8080_nav_pages[2] = canvas_LX8080_nav_3.new(groupMain[2], instrument_path~"LX8080_nav_3.svg");
	LX8080_nav_pages[3] = canvas_LX8080_nav_4.new(groupMain[3], instrument_path~"LX8080_nav_4.svg");
	
	LX8080_start = canvas_LX8080_start.new(groupStart, instrument_path~"LX8080_start.svg");
	
	var base_update = maketimer(0.2, func() {
				canvas_LX8080_base.update();
			});
	base_update.start();
	removelistener(ls);
});

var showLX8080 = func {
	var dlg = canvas.Window.new([480, 800], "dialog").set("resize", 1);
	dlg.setCanvas(LX8080_display);
}

setlistener( zoom, func {
	var new_zoom = zoom.getIntValue();
	LX8080_nav_pages[0]["zoom.text"].setText( sprintf("%3d", new_zoom ) );
	LX8080_nav_pages[0].map.setRange( 10 * new_zoom );
	LX8080_nav_pages[1]["zoom.text"].setText( sprintf("%3d", new_zoom ) );
	LX8080_nav_pages[1].map.setRange( 10 * new_zoom );
});

setlistener(volts, func{
	if(volts.getValue() >= 10 and start.getValue() == 0){
		interpolate("/instrumentation/lx8080/start", 1, 3.5 );
	}else if( volts.getValue() < 10 and start.getValue() != 0){
		start.setValue(0.0);
	}
});
