#	LIVERY SYSTEM
aircraft.livery.init("Aircraft/BN-2/Models/Liveries");


#	CONFIG SYSTEM

# sync interior variant to interior variant-text (-text is used for GUI dialog bn2-config)

setlistener("/sim/model/interior/variant-text", func( i ){
	if( i.getValue() == "Commuter" ){
		setprop("/sim/model/interior/variant", 0);
	} elsif( i.getValue() == "Medical Transport" ){
		setprop("/sim/model/interior/variant", 1);
	} else {
		screen.log.write("BN2 Config System: Unknown interior configuration!");
	}
});

#	HOBBS METER

var rpm = [
	props.globals.getNode("/engines/engine[0]/rpm"),
	props.globals.getNode("/engines/engine[1]/rpm"),
];
var hobbs_property = [
	props.globals.initNode("/engines/engine[0]/hobbs", 0.0, "DOUBLE"),
	props.globals.initNode("/engines/engine[1]/hobbs", 0.0, "DOUBLE"),
];

var update_hobbs = func {
	for( var i = 0; i <= 1; i += 1 ){
		if( rpm[ i ].getDoubleValue() > 500.0 ){
			hobbs_property[ i ].setDoubleValue( hobbs_property[ i ].getDoubleValue() + ( 1 / 60 ) );
		}
	}
}

var hobbs_timer = maketimer( 60.0, update_hobbs );
hobbs_timer.simulatedTime = 1;
hobbs_timer.start();

#	SOUND SYSTEM
var sound_sw = {
	switchp: [
		props.globals.getNode("/controls/anti-ice/pitot-stall-heat", 1),
		props.globals.getNode("/controls/anti-ice/airframe-deice", 1),
		props.globals.getNode("/controls/anti-ice/propeller-deice", 1),
		props.globals.getNode("/controls/lighting/nav-lights", 1),
		props.globals.getNode("/controls/lighting/landing-lights[0]", 1),
		props.globals.getNode("/controls/lighting/landing-lights[1]", 1),
		props.globals.getNode("/controls/lighting/cabin-lights", 1),
		props.globals.getNode("/controls/lighting/pax-notice", 1),
		props.globals.getNode("/controls/lighting/acl-beacon", 1),
		props.globals.getNode("/controls/electric/engine[0]/generator", 1),
		props.globals.getNode("/controls/electric/engine[1]/generator", 1),
		props.globals.getNode("/controls/electric/battery-switch", 1),
		props.globals.getNode("/controls/electric/avionics-switch", 1),
		props.globals.getNode("/controls/electric/external-supply", 1),
	],
	upper: [
		props.globals.getNode("/controls/engines/engine[0]/magneto[0]", 1),
		props.globals.getNode("/controls/engines/engine[0]/magneto[1]", 1),
		props.globals.getNode("/controls/engines/engine[1]/magneto[0]", 1),
		props.globals.getNode("/controls/engines/engine[1]/magneto[1]", 1),
		props.globals.getNode("/controls/fuel/tank[0]/aux-fuel-pump", 1),
		props.globals.getNode("/controls/fuel/tank[1]/aux-fuel-pump", 1),
	],
};

var switch_properties = [
	props.globals.initNode("/sim/sound/switch-panel", -1, "INT"),
	props.globals.initNode("/sim/sound/upper-panel", -1, "INT"),
	props.globals.initNode("/sim/sound/cb-panel", -1, "INT"),
];

setlistener( "controls/engines/starter-switch", func( i ){
	if( i.getIntValue() != 0 ){
		switch_properties[1].setIntValue( 1 );
	} else {
		switch_properties[1].setIntValue( 0 );
	}
});

foreach( var el; sound_sw.switchp ){
	setlistener( el, func( i ) {
		if( i.getBoolValue() ){
			switch_properties[0].setIntValue( 1 );
		} else {
			switch_properties[0].setIntValue( 0 );
		}
	});
}
foreach( var el; sound_sw.upper ){
	setlistener( el, func( i ) {
		if( i.getBoolValue() ){
			switch_properties[1].setIntValue( 1 );
		} else {
			switch_properties[1].setIntValue( 0 );
		}
	});
}

foreach( var el; switch_properties ){
	setlistener( el, func( i ) {
		if( i.getIntValue() != -1 ) {
			settimer( func { i.setIntValue( -1 ) }, 0.1 );
		}
	});
}
