###############################################################################
##
##  DHC8-400 COM1 Standby Instrument
##
##  Original: Davtron 803
##  Original from Nasal for DR400-dauphin by dany93;
##                    Clément de l'Hamaide - PAF Team - http://equipe-flightgear.forumactif.com
##  Heavily modified in 2017 for c182s by Benedikt Hallinger
##  Modified in 2020 for COM 1 Display by Benedikt Wolf
##  
##  This file is licensed under the GPL license version 2 or later.
##
###############################################################################

#	This file is loaded into the same namespace as the ARCDU (canvas_arcdu), thus sharing properties
var com1_standby_volts = props.globals.initNode("systems/electrical/outputs/vhf-com-stby", 0.0, "DOUBLE");
var com1_standby_power_knob = props.globals.initNode("instrumentation/vhf-com-stby/power-knob", 0, "INT");
var com1_standby_status = props.globals.initNode("instrumentation/vhf-com-stby/status", 0, "INT");
var com1_tx = props.globals.getNode("instrumentation/comm[0]/ptt");

############################
# Canvas implementation
############################

var com1_canvas = canvas.new({
	"name": "COM1 Standby Instrument Screnn",   # The name is optional but allow for easier identification
	"size": [2048, 2048], # Size of the underlying texture (should be a power of 2, required) [Resolution]
	"view": [2048, 2048],  # Virtual resolution (Defines the coordinate system of the canvas [Dimensions]
	# which will be stretched the size of the texture, required)
	"mipmapping": 1       # Enable mipmapping (optional)
});

# add the canvas to replace basic texture of models lcd element
com1_canvas.addPlacement({"node": "com1.screen"});

# create groups holding some stuff
var bggroup  = com1_canvas.createGroup();
var textgroup = com1_canvas.createGroup();

bggroup.createChild("image")
		.setFile("Models/Cockpit/Pedestal/Front/frontpedestal.png")
		.setSize(2048, 2048)
		.setTranslation(0, 0);      

var active_line = textgroup.createChild("text", "com1.active")
		.setTranslation(410, 1225)   		 		# The origin is in the top left corner
		.setAlignment("center-center") 				# All values from osgText are supported (see $FG_ROOT/Docs/README.osgtext)
		.setFont("7-Segment.ttf")				# Fonts are loaded either from $AIRCRAFT_DIR/Fonts or $FG_ROOT/Fonts
		.setFontSize(20, 1.0)					# Set fontsize and optionally character aspect ratio
		.setColor(0.8,0.7,0.6)					# Text color
		.setText("188.888");
var stby_line = textgroup.createChild("text", "com1.standby")
		.setTranslation(410, 1278)   		 		# The origin is in the top left corner
		.setAlignment("center-center") 				# All values from osgText are supported (see $FG_ROOT/Docs/README.osgtext)
		.setFont("7-Segment.ttf")				# Fonts are loaded either from $AIRCRAFT_DIR/Fonts or $FG_ROOT/Fonts
		.setFontSize(20, 1.0)					# Set fontsize and optionally character aspect ratio
		.setColor(0.8,0.7,0.6)					# Text color
		.setText("188.888");
var tx_flag = textgroup.createChild("text", "com1.tx")
		.setTranslation(290, 1225)   		 		# The origin is in the top left corner
		.setAlignment("center-center") 				# All values from osgText are supported (see $FG_ROOT/Docs/README.osgtext)
		.setFont("LiberationFonts/LiberationMono-Regular.ttf")				# Fonts are loaded either from $AIRCRAFT_DIR/Fonts or $FG_ROOT/Fonts
		.setFontSize(25, 1.0)					# Set fontsize and optionally character aspect ratio
		.setColor(0.8,0.7,0.6)					# Text color
		.setText("TX");

var update_comm1 = func () {
	active_line.setText( sprintf("%6.3f", frequencies.comm[0].active.getDoubleValue() ) );
	stby_line.setText( sprintf("%6.3f", frequencies.comm[0].standby.getDoubleValue() ) );
}
update_comm1();

var update_tx = func () {
	if( com1_standby_status.getIntValue() > 1 and com1_tx.getBoolValue() ){
		tx_flag.show();
	} else {
		tx_flag.hide();
	}
}

var stby_display_was_on = -1;

var update_stby_display_on= func () {
	if( com1_standby_volts.getDoubleValue() > 10 and stby_display_was_on != 1 ){
		textgroup.show();
		stby_display_was_on = 1;
		com1_standby_status.setIntValue( com1_standby_power_knob.getIntValue() );
		update_tx();
	} else if( com1_standby_volts.getDoubleValue() <= 10 and stby_display_was_on != 0 ){
		textgroup.hide();
		stby_display_was_on = 0;
		com1_standby_status.setIntValue( 0 );
		update_tx();
	}
}

setlistener(com1_tx, update_tx);
setlistener(frequencies.comm[0].active, update_comm1);
setlistener(frequencies.comm[0].standby, update_comm1);
setlistener(com1_standby_volts, update_stby_display_on);
