# Nasal script to change variants
#
aircraft.livery.init("Aircraft/Icaro_MRX13/Models/Variants");

#------------------------------------------------------------------------------
# The variant "ZeroVariantForAutosave" is a special variant.
# This variant must be set to ensure that individual color configurations are autosaved.
# But this color settings are not transmitted via multiplayer.
# Hence an alternative variant must be shown in MP.
# Important: 
# It is possible that the user and the MP-members see different variants of the Icaro-MRX13!
# An indicator of such a case is that /sim/model/livery/name and /sim/model/livery/file differ.
#
var check_MP_Variant = func {
  var online = getprop("/sim/multiplay/online");
  if(online){
    var variant_file = getprop("/sim/model/livery/file");
    var variant_name = getprop("/sim/model/livery/name");
    if( variant_file == "ZeroVariantForAutosave") {
      print("Icaro-MRX13: MP-Variant 'ZeroVariantForAutosave' is not available");
      setprop("/sim/model/livery/file","Default");
      print("Icaro-MRX13: MP-Variant set to 'Default'-Variant");
      setprop("sim/messages/atc", sprintf("Warning!") );
      setprop("sim/messages/atc", sprintf("Multiplayer variant set to Default variant") );
      setprop("sim/messages/atc", sprintf("Multiplayer user may see a different variant") );
    }
  }
}
check_MP_Variant();
setlistener("/sim/multiplay/online",  func { check_MP_Variant() });
setlistener("/sim/model/livery/file", func { check_MP_Variant() });
#------------------------------------------------------------------------------
