/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.shell;

import java.util.Dictionary;
import java.util.HashSet;
import java.util.Properties;
import org.apache.karaf.cellar.core.Group;
import org.apache.karaf.cellar.core.Synchronizer;
import org.apache.karaf.cellar.shell.ClusterCommandSupport;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

@Command(scope="cluster", name="sync", description="Manipulate the synchronizers")
@Service
public class SyncCommand
extends ClusterCommandSupport {
    @Option(name="-g", aliases={"--group"}, description="The cluster group name", required=false, multiValued=false)
    private String groupName;
    @Option(name="-b", aliases={"--bundle"}, description="Cluster bundle support", required=false, multiValued=false)
    private boolean bundleSync = false;
    @Option(name="-c", aliases={"--config"}, description="Cluster config support", required=false, multiValued=false)
    private boolean configSync = false;
    @Option(name="-f", aliases={"--feature"}, description="Cluster feature support", required=false, multiValued=false)
    private boolean featuresSync = false;
    @Option(name="-o", aliases={"--obr"}, description="Cluster OBR support", required=false, multiValued=false)
    private boolean obrSync = false;
    @Argument(name="policy", description="The definition of the sync policy for the given cluster resource", required=false, multiValued=false)
    private String policy;
    @Reference
    private ConfigurationAdmin configurationAdmin;
    @Reference
    private BundleContext bundleContext;

    protected Object doExecute() throws Exception {
        HashSet<Group> groups;
        boolean allResources = false;
        if (!(this.bundleSync || this.configSync || this.featuresSync || this.obrSync)) {
            allResources = true;
        }
        if (this.groupName == null || this.groupName.isEmpty()) {
            groups = this.groupManager.listLocalGroups();
        } else {
            groups = new HashSet<Group>();
            if (this.groupManager.findGroupByName(this.groupName) == null) {
                System.err.println("Cluster group " + this.groupName + " doesn't exist");
                return null;
            }
            groups.add(this.groupManager.findGroupByName(this.groupName));
        }
        if (this.policy == null || this.policy.isEmpty()) {
            for (Group group : groups) {
                System.out.println("Synchronizing cluster group " + group.getName());
                if (this.bundleSync || allResources) {
                    this.doSync("bundle", group);
                }
                if (this.configSync || allResources) {
                    this.doSync("config", group);
                }
                if (this.featuresSync || allResources) {
                    this.doSync("feature", group);
                }
                if (!this.obrSync && !allResources) continue;
                this.doSync("obr.urls", group);
            }
        } else {
            if (!(this.policy.equalsIgnoreCase("cluster") || this.policy.equalsIgnoreCase("node") || this.policy.equalsIgnoreCase("clusterOnly") || this.policy.equalsIgnoreCase("nodeOnly") || this.policy.equalsIgnoreCase("disabled"))) {
                System.err.println("The sync policy " + this.policy + " is not valid. Valid sync policies are: cluster, node, clusterOnly, nodeOnly, disabled");
                return null;
            }
            for (Group group : groups) {
                System.out.println("Updating sync policy for cluster group " + group.getName());
                if (this.bundleSync || allResources) {
                    this.updateSync("bundle", group, this.policy);
                }
                if (this.configSync || allResources) {
                    this.updateSync("config", group, this.policy);
                }
                if (this.featuresSync || allResources) {
                    this.updateSync("feature", group, this.policy);
                }
                if (!this.obrSync && !allResources) continue;
                this.updateSync("obr.urls", group, this.policy);
            }
        }
        return null;
    }

    private void doSync(String resource, Group group) throws Exception {
        System.out.print("\t" + resource + ": ");
        ServiceReference[] references = this.bundleContext.getAllServiceReferences(Synchronizer.class.getName(), "(resource=" + resource + ")");
        if (references != null && references.length > 0) {
            for (ServiceReference reference : references) {
                Synchronizer synchronizer = (Synchronizer)this.bundleContext.getService(reference);
                synchronizer.sync(group);
                this.bundleContext.ungetService(reference);
            }
            System.out.println("done");
        } else {
            System.out.println("No synchronizer found for " + resource);
        }
    }

    private void updateSync(String resource, Group group, String policy) throws Exception {
        System.out.print("\t" + resource + ": ");
        Configuration configuration = this.configurationAdmin.getConfiguration("org.apache.karaf.cellar.groups", null);
        if (configuration != null) {
            Dictionary properties = configuration.getProperties();
            if (properties == null) {
                properties = new Properties();
            }
            properties.put(group.getName() + "." + resource + ".sync", policy);
            configuration.update(properties);
            System.out.println("done");
        }
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }
}

