/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.config;

import java.io.IOException;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.karaf.cellar.config.ClusterConfigurationEvent;
import org.apache.karaf.cellar.config.ConfigurationSupport;
import org.apache.karaf.cellar.core.Group;
import org.apache.karaf.cellar.core.Synchronizer;
import org.apache.karaf.cellar.core.control.SwitchStatus;
import org.apache.karaf.cellar.core.event.Event;
import org.apache.karaf.cellar.core.event.EventProducer;
import org.apache.karaf.cellar.core.event.EventType;
import org.apache.karaf.cellar.core.utils.CellarUtils;
import org.apache.karaf.features.BootFinished;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationSynchronizer
extends ConfigurationSupport
implements Synchronizer {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(ConfigurationSynchronizer.class);
    private EventProducer eventProducer;

    public void setEventProducer(EventProducer eventProducer) {
        this.eventProducer = eventProducer;
    }

    public void init(BundleContext bundleContext) {
        ServiceTracker tracker = new ServiceTracker(bundleContext, BootFinished.class, null);
        try {
            tracker.waitForService(120000L);
        }
        catch (Exception e) {
            LOGGER.warn("Can't start BootFinished service tracker", (Throwable)e);
        }
        if (this.groupManager == null) {
            return;
        }
        Set groups = this.groupManager.listLocalGroups();
        if (groups != null && !groups.isEmpty()) {
            for (Group group : groups) {
                this.sync(group);
            }
        }
    }

    public void destroy() {
    }

    public void sync(Group group) {
        String policy = this.getSyncPolicy(group);
        if (policy == null) {
            LOGGER.warn("CELLAR CONFIG: sync policy is not defined for cluster group {}", (Object)group.getName());
        } else if (policy.equalsIgnoreCase("cluster")) {
            LOGGER.debug("CELLAR CONFIG: sync policy set as 'cluster' for cluster group {}", (Object)group.getName());
            LOGGER.debug("CELLAR CONFIG: updating node from the cluster (pull first)");
            this.pull(group);
            LOGGER.debug("CELLAR CONFIG: node is the first one in the cluster group, no pull");
            LOGGER.debug("CELLAR CONFIG: updating cluster from the local node (push after)");
            this.push(group);
        } else if (policy.equalsIgnoreCase("node")) {
            LOGGER.debug("CELLAR CONFIG: sync policy set as 'node' for cluster group {}", (Object)group.getName());
            LOGGER.debug("CELLAR CONFIG: updating cluster from the local node (push first)");
            this.push(group);
            LOGGER.debug("CELLAR CONFIG: updating node from the cluster (pull after)");
            this.pull(group);
        } else if (policy.equalsIgnoreCase("clusterOnly")) {
            LOGGER.debug("CELLAR CONFIG: sync policy set as 'clusterOnly' for cluster group " + group.getName());
            LOGGER.debug("CELLAR CONFIG: updating node from the cluster (pull only)");
            this.pull(group);
            LOGGER.debug("CELLAR CONFIG: node is the first one in the cluster group, no pull");
        } else if (policy.equalsIgnoreCase("nodeOnly")) {
            LOGGER.debug("CELLAR CONFIG: sync policy set as 'nodeOnly' for cluster group " + group.getName());
            LOGGER.debug("CELLAR CONFIG: updating cluster from the local node (push only)");
            this.push(group);
        } else {
            LOGGER.debug("CELLAR CONFIG: sync policy set as 'disabled' for cluster group " + group.getName());
            LOGGER.debug("CELLAR CONFIG: no sync");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pull(Group group) {
        block16: {
            if (group != null) {
                String groupName = group.getName();
                LOGGER.debug("CELLAR CONFIG: pulling configurations from cluster group {}", (Object)groupName);
                Map clusterConfigurations = this.clusterManager.getMap("org.apache.karaf.cellar.configuration.map." + groupName);
                ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                    for (String pid : clusterConfigurations.keySet()) {
                        if (this.isAllowed(group, "config", pid, EventType.INBOUND).booleanValue() && this.shouldReplicateConfig((Dictionary)clusterConfigurations.get(pid))) {
                            Dictionary clusterDictionary = (Dictionary)clusterConfigurations.get(pid);
                            try {
                                Dictionary localDictionary;
                                Configuration localConfiguration = this.findLocalConfiguration(pid, clusterDictionary);
                                if (localConfiguration == null) {
                                    localConfiguration = this.createLocalConfiguration(pid, clusterDictionary);
                                }
                                if ((localDictionary = localConfiguration.getProperties()) == null) {
                                    localDictionary = new Properties();
                                }
                                if (this.equals(clusterDictionary, localDictionary = this.filter(localDictionary)) || !this.canDistributeConfig(localDictionary) || !this.shouldReplicateConfig(clusterDictionary)) continue;
                                LOGGER.debug("CELLAR CONFIG: updating configration {} on node", (Object)pid);
                                clusterDictionary = this.convertPropertiesFromCluster(clusterDictionary);
                                localConfiguration.update(clusterDictionary);
                                this.persistConfiguration(localConfiguration, clusterDictionary);
                            }
                            catch (IOException ex) {
                                LOGGER.error("CELLAR CONFIG: failed to read local configuration", (Throwable)ex);
                            }
                            continue;
                        }
                        LOGGER.trace("CELLAR CONFIG: configuration with PID {} is marked BLOCKED INBOUND for cluster group {}", (Object)pid, (Object)groupName);
                    }
                    if (!CellarUtils.doCleanupResourcesNotPresentInCluster((ConfigurationAdmin)this.configurationAdmin) || !this.getSynchronizerMap().containsKey("org.apache.karaf.cellar.configuration.map." + groupName)) break block16;
                    try {
                        HashSet<String> filenames = new HashSet<String>();
                        for (Properties configuration : clusterConfigurations.values()) {
                            if (!this.shouldReplicateConfig(configuration)) continue;
                            filenames.add(this.getKarafFilename(configuration));
                        }
                        filenames.remove(null);
                        for (Configuration configuration : this.configurationAdmin.listConfigurations(null)) {
                            String pid = configuration.getPid();
                            if (clusterConfigurations.containsKey(pid) && this.shouldReplicateConfig((Dictionary)clusterConfigurations.get(pid)) || filenames.contains(this.getKarafFilename(configuration.getProperties())) || !this.isAllowed(group, "config", pid, EventType.INBOUND).booleanValue()) continue;
                            LOGGER.debug("CELLAR CONFIG: deleting local configuration {} which is not present in cluster", (Object)pid);
                            this.deleteConfiguration(configuration);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.warn("Can't get local configurations", (Throwable)e);
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("CELLAR CONFIG: failed to read cluster configuration", (Throwable)ex);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(originalClassLoader);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(Group group) {
        if (this.eventProducer.getSwitch().getStatus().equals((Object)SwitchStatus.OFF)) {
            LOGGER.warn("CELLAR CONFIG: cluster event producer is OFF");
            return;
        }
        if (group != null) {
            String groupName = group.getName();
            LOGGER.debug("CELLAR CONFIG: pushing configurations to cluster group {}", (Object)groupName);
            Map clusterConfigurations = this.clusterManager.getMap("org.apache.karaf.cellar.configuration.map." + groupName);
            ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                try {
                    Configuration[] localConfigurations = this.configurationAdmin.listConfigurations(null);
                    for (Configuration localConfiguration : localConfigurations) {
                        String pid = localConfiguration.getPid();
                        if (this.isAllowed(group, "config", pid, EventType.OUTBOUND).booleanValue()) {
                            Dictionary localDictionary = localConfiguration.getProperties();
                            localDictionary = this.filter(localDictionary);
                            if (!clusterConfigurations.containsKey(pid)) {
                                LOGGER.debug("CELLAR CONFIG: creating configuration pid\u00a0{} on the cluster", (Object)pid);
                                clusterConfigurations.put(pid, ConfigurationSynchronizer.dictionaryToProperties(localDictionary));
                                ClusterConfigurationEvent event = new ClusterConfigurationEvent(pid);
                                event.setSourceGroup(group);
                                event.setSourceNode(this.clusterManager.getNode());
                                event.setLocal(this.clusterManager.getNode());
                                this.eventProducer.produce((Event)event);
                                continue;
                            }
                            Dictionary clusterDictionary = (Dictionary)clusterConfigurations.get(pid);
                            if (this.equals(clusterDictionary, localDictionary) || !this.canDistributeConfig(localDictionary)) continue;
                            LOGGER.debug("CELLAR CONFIG: updating configuration pid {} on the cluster", (Object)pid);
                            clusterConfigurations.put(pid, ConfigurationSynchronizer.dictionaryToProperties(localDictionary));
                            ClusterConfigurationEvent event = new ClusterConfigurationEvent(pid);
                            event.setSourceGroup(group);
                            event.setLocal(this.clusterManager.getNode());
                            event.setSourceNode(this.clusterManager.getNode());
                            this.eventProducer.produce((Event)event);
                            continue;
                        }
                        LOGGER.trace("CELLAR CONFIG: configuration with PID {} is marked BLOCKED OUTBOUND for cluster group {}", (Object)pid, (Object)groupName);
                    }
                    for (String pid : clusterConfigurations.keySet()) {
                        if (!this.isAllowed(group, "config", pid, EventType.OUTBOUND).booleanValue() || this.findLocalConfiguration(pid, (Dictionary)clusterConfigurations.get(pid)) != null) continue;
                        clusterConfigurations.remove(pid);
                    }
                    this.getSynchronizerMap().putIfAbsent("org.apache.karaf.cellar.configuration.map." + groupName, true);
                }
                catch (IOException ex) {
                    LOGGER.error("CELLAR CONFIG: failed to read configuration (IO error)", (Throwable)ex);
                }
                catch (InvalidSyntaxException ex) {
                    LOGGER.error("CELLAR CONFIG: failed to read configuration (invalid filter syntax)", (Throwable)ex);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }
    }

    public String getSyncPolicy(Group group) {
        String groupName = group.getName();
        try {
            String propertyKey;
            Configuration configuration = this.configurationAdmin.getConfiguration("org.apache.karaf.cellar.groups", null);
            Dictionary properties = configuration.getProperties();
            if (properties != null && properties.get(propertyKey = groupName + "." + "config" + "." + "sync") != null) {
                return properties.get(propertyKey).toString();
            }
        }
        catch (IOException e) {
            LOGGER.error("CELLAR CONFIG: error while retrieving the sync policy", (Throwable)e);
        }
        return null;
    }
}

