/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml;

import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.client.ValidationException;

public class DeleteDataFrameAnalyticsRequest
implements Validatable {
    private final String id;

    public DeleteDataFrameAnalyticsRequest(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public Optional<ValidationException> validate() {
        if (this.id == null) {
            return Optional.of(ValidationException.withError("data frame analytics id must not be null"));
        }
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteDataFrameAnalyticsRequest other = (DeleteDataFrameAnalyticsRequest)o;
        return Objects.equals(this.id, other.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

