/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.modules.osgi;

import java.io.IOException;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.apache.karaf.jaas.boot.principal.UserPrincipal;
import org.apache.karaf.jaas.modules.AbstractKarafLoginModule;
import org.apache.karaf.jaas.modules.JAASUtils;
import org.apache.karaf.jaas.modules.osgi.ConfigAdminHolder;
import org.osgi.service.cm.Configuration;

public class OsgiConfigLoginModule
extends AbstractKarafLoginModule {
    public static final String PID = "pid";
    public static final String USER_PREFIX = "user.";

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, options);
    }

    @Override
    public boolean login() throws LoginException {
        try {
            String pid = JAASUtils.getString(this.options, PID);
            Configuration config = ConfigAdminHolder.getService().getConfiguration(pid, null);
            Dictionary properties = config.getProperties();
            Callback[] callbacks = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false)};
            try {
                this.callbackHandler.handle(callbacks);
            }
            catch (IOException ioe) {
                throw new LoginException(ioe.getMessage());
            }
            catch (UnsupportedCallbackException uce) {
                throw new LoginException(uce.getMessage() + " not available to obtain information from user");
            }
            String user = ((NameCallback)callbacks[0]).getName();
            String password = new String(((PasswordCallback)callbacks[1]).getPassword());
            String userInfos = (String)properties.get(USER_PREFIX + user);
            if (userInfos == null) {
                if (!this.detailedLoginExcepion) {
                    throw new FailedLoginException("login failed");
                }
                throw new FailedLoginException("User does not exist");
            }
            String[] infos = userInfos.split(",");
            String storedPassword = infos[0];
            if (!this.checkPassword(password, storedPassword)) {
                if (!this.detailedLoginExcepion) {
                    throw new FailedLoginException("login failed");
                }
                throw new FailedLoginException("Password for " + user + " does not match");
            }
            this.principals = new HashSet();
            this.principals.add(new UserPrincipal(user));
            for (int i = 1; i < infos.length; ++i) {
                this.principals.add(new RolePrincipal(infos[i]));
            }
            this.succeeded = true;
            boolean bl = true;
            return bl;
        }
        catch (LoginException e) {
            throw e;
        }
        catch (Exception e) {
            throw (LoginException)new LoginException("Unable to authenticate user").initCause(e);
        }
        finally {
            this.callbackHandler = null;
            this.options = null;
        }
    }
}

