/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.subsystem.sftp.fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.nio.charset.Charset;
import java.nio.file.FileStore;
import java.nio.file.FileSystemException;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.sshd.client.channel.ClientChannel;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.session.ClientSessionHolder;
import org.apache.sshd.client.subsystem.sftp.RawSftpClient;
import org.apache.sshd.client.subsystem.sftp.SftpClient;
import org.apache.sshd.client.subsystem.sftp.SftpClientFactory;
import org.apache.sshd.client.subsystem.sftp.SftpVersionSelector;
import org.apache.sshd.client.subsystem.sftp.fs.SftpFileStore;
import org.apache.sshd.client.subsystem.sftp.fs.SftpFileSystemProvider;
import org.apache.sshd.client.subsystem.sftp.fs.SftpPath;
import org.apache.sshd.client.subsystem.sftp.impl.AbstractSftpClient;
import org.apache.sshd.common.file.util.BaseFileSystem;
import org.apache.sshd.common.session.SessionHolder;
import org.apache.sshd.common.subsystem.sftp.SftpConstants;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.buffer.Buffer;

public class SftpFileSystem
extends BaseFileSystem<SftpPath>
implements SessionHolder<ClientSession>,
ClientSessionHolder {
    public static final String POOL_SIZE_PROP = "sftp-fs-pool-size";
    public static final int DEFAULT_POOL_SIZE = 8;
    public static final NavigableSet<String> UNIVERSAL_SUPPORTED_VIEWS = Collections.unmodifiableNavigableSet(GenericUtils.asSortedSet((Comparator)String.CASE_INSENSITIVE_ORDER, (Object[])new String[]{"basic", "posix", "owner"}));
    private final String id;
    private final ClientSession clientSession;
    private final SftpClientFactory factory;
    private final SftpVersionSelector selector;
    private final Queue<SftpClient> pool;
    private final ThreadLocal<Wrapper> wrappers = new ThreadLocal();
    private final int version;
    private final Set<String> supportedViews;
    private SftpPath defaultDir;
    private int readBufferSize;
    private int writeBufferSize;
    private final List<FileStore> stores;

    public SftpFileSystem(SftpFileSystemProvider provider, String id, ClientSession session, SftpClientFactory factory, SftpVersionSelector selector) throws IOException {
        super((FileSystemProvider)provider);
        this.id = id;
        this.clientSession = Objects.requireNonNull(session, "No client session");
        this.factory = factory != null ? factory : SftpClientFactory.instance();
        this.selector = selector;
        this.stores = Collections.unmodifiableList(Collections.singletonList(new SftpFileStore(id, this)));
        this.pool = new LinkedBlockingQueue<SftpClient>(session.getIntProperty(POOL_SIZE_PROP, 8));
        try (SftpClient client = this.getClient();){
            this.version = client.getVersion();
            this.defaultDir = (SftpPath)((Object)this.getPath(client.canonicalPath("."), new String[0]));
        }
        if (this.version >= 4) {
            TreeSet<String> views = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            views.addAll(UNIVERSAL_SUPPORTED_VIEWS);
            views.add("acl");
            this.supportedViews = Collections.unmodifiableSet(views);
        } else {
            this.supportedViews = UNIVERSAL_SUPPORTED_VIEWS;
        }
    }

    public final SftpVersionSelector getSftpVersionSelector() {
        return this.selector;
    }

    public final String getId() {
        return this.id;
    }

    public final int getVersion() {
        return this.version;
    }

    public SftpFileSystemProvider provider() {
        return (SftpFileSystemProvider)super.provider();
    }

    public List<FileStore> getFileStores() {
        return this.stores;
    }

    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    public void setReadBufferSize(int size) {
        if (size < 256) {
            throw new IllegalArgumentException("Insufficient read buffer size: " + size + ", min.=" + 256);
        }
        this.readBufferSize = size;
    }

    public int getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public void setWriteBufferSize(int size) {
        if (size < 256) {
            throw new IllegalArgumentException("Insufficient write buffer size: " + size + ", min.=" + 256);
        }
        this.writeBufferSize = size;
    }

    protected SftpPath create(String root, List<String> names) {
        return new SftpPath(this, root, names);
    }

    public ClientSession getClientSession() {
        return this.clientSession;
    }

    public ClientSession getSession() {
        return this.getClientSession();
    }

    public SftpClient getClient() throws IOException {
        Wrapper wrapper = this.wrappers.get();
        if (wrapper == null) {
            while (wrapper == null) {
                SftpClient client = this.pool.poll();
                if (client == null) {
                    ClientSession session = this.getClientSession();
                    client = this.factory.createSftpClient(session, this.getSftpVersionSelector());
                }
                if (client.isClosing()) continue;
                wrapper = new Wrapper(client, this.getReadBufferSize(), this.getWriteBufferSize());
            }
            this.wrappers.set(wrapper);
        } else {
            wrapper.increment();
        }
        return wrapper;
    }

    public void close() throws IOException {
        if (this.isOpen()) {
            SftpFileSystemProvider provider = this.provider();
            String fsId = this.getId();
            SftpFileSystem fs = provider.removeFileSystem(fsId);
            ClientSession session = this.getClientSession();
            session.close(true);
            if (fs != null && fs != this) {
                throw new FileSystemException(fsId, fsId, "Mismatched FS instance for id=" + fsId);
            }
        }
    }

    public boolean isOpen() {
        ClientSession session = this.getClientSession();
        return session.isOpen();
    }

    public Set<String> supportedFileAttributeViews() {
        return this.supportedViews;
    }

    public UserPrincipalLookupService getUserPrincipalLookupService() {
        return DefaultUserPrincipalLookupService.INSTANCE;
    }

    public SftpPath getDefaultDir() {
        return this.defaultDir;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[" + this.getClientSession() + "]";
    }

    public static class DefaultGroupPrincipal
    extends DefaultUserPrincipal
    implements GroupPrincipal {
        public DefaultGroupPrincipal(String name) {
            super(name);
        }
    }

    public static class DefaultUserPrincipal
    implements UserPrincipal {
        private final String name;

        public DefaultUserPrincipal(String name) {
            this.name = Objects.requireNonNull(name, "name is null");
        }

        @Override
        public final String getName() {
            return this.name;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultUserPrincipal that = (DefaultUserPrincipal)o;
            return Objects.equals(this.getName(), that.getName());
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.getName());
        }

        @Override
        public String toString() {
            return this.getName();
        }
    }

    public static class DefaultUserPrincipalLookupService
    extends UserPrincipalLookupService {
        public static final DefaultUserPrincipalLookupService INSTANCE = new DefaultUserPrincipalLookupService();

        @Override
        public UserPrincipal lookupPrincipalByName(String name) throws IOException {
            return new DefaultUserPrincipal(name);
        }

        @Override
        public GroupPrincipal lookupPrincipalByGroupName(String group) throws IOException {
            return new DefaultGroupPrincipal(group);
        }
    }

    private final class Wrapper
    extends AbstractSftpClient {
        private final SftpClient delegate;
        private final AtomicInteger count = new AtomicInteger(1);
        private final int readSize;
        private final int writeSize;

        private Wrapper(SftpClient delegate, int readSize, int writeSize) {
            this.delegate = delegate;
            this.readSize = readSize;
            this.writeSize = writeSize;
        }

        @Override
        public int getVersion() {
            return this.delegate.getVersion();
        }

        public ClientSession getClientSession() {
            return this.delegate.getClientSession();
        }

        public ClientChannel getClientChannel() {
            return this.delegate.getClientChannel();
        }

        @Override
        public NavigableMap<String, byte[]> getServerExtensions() {
            return this.delegate.getServerExtensions();
        }

        @Override
        public Charset getNameDecodingCharset() {
            return this.delegate.getNameDecodingCharset();
        }

        @Override
        public void setNameDecodingCharset(Charset cs) {
            this.delegate.setNameDecodingCharset(cs);
        }

        @Override
        public boolean isClosing() {
            return false;
        }

        public boolean isOpen() {
            return this.count.get() > 0;
        }

        public void close() throws IOException {
            if (this.count.decrementAndGet() <= 0) {
                if (!SftpFileSystem.this.pool.offer(this.delegate)) {
                    this.delegate.close();
                }
                SftpFileSystem.this.wrappers.set(null);
            }
        }

        public void increment() {
            this.count.incrementAndGet();
        }

        @Override
        public SftpClient.CloseableHandle open(String path, Collection<SftpClient.OpenMode> options) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("open(" + path + ")[" + options + "] client is closed");
            }
            return this.delegate.open(path, options);
        }

        @Override
        public void close(SftpClient.Handle handle) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("close(" + handle + ") client is closed");
            }
            this.delegate.close(handle);
        }

        @Override
        public void remove(String path) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("remove(" + path + ") client is closed");
            }
            this.delegate.remove(path);
        }

        @Override
        public void rename(String oldPath, String newPath, Collection<SftpClient.CopyMode> options) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("rename(" + oldPath + " => " + newPath + ")[" + options + "] client is closed");
            }
            this.delegate.rename(oldPath, newPath, options);
        }

        @Override
        public int read(SftpClient.Handle handle, long fileOffset, byte[] dst, int dstOffset, int len) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("read(" + handle + "/" + fileOffset + ")[" + dstOffset + "/" + len + "] client is closed");
            }
            return this.delegate.read(handle, fileOffset, dst, dstOffset, len);
        }

        @Override
        public void write(SftpClient.Handle handle, long fileOffset, byte[] src, int srcOffset, int len) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("write(" + handle + "/" + fileOffset + ")[" + srcOffset + "/" + len + "] client is closed");
            }
            this.delegate.write(handle, fileOffset, src, srcOffset, len);
        }

        @Override
        public void mkdir(String path) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("mkdir(" + path + ") client is closed");
            }
            this.delegate.mkdir(path);
        }

        @Override
        public void rmdir(String path) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("rmdir(" + path + ") client is closed");
            }
            this.delegate.rmdir(path);
        }

        @Override
        public SftpClient.CloseableHandle openDir(String path) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("openDir(" + path + ") client is closed");
            }
            return this.delegate.openDir(path);
        }

        @Override
        public List<SftpClient.DirEntry> readDir(SftpClient.Handle handle) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("readDir(" + handle + ") client is closed");
            }
            return this.delegate.readDir(handle);
        }

        @Override
        public Iterable<SftpClient.DirEntry> listDir(SftpClient.Handle handle) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("readDir(" + handle + ") client is closed");
            }
            return this.delegate.listDir(handle);
        }

        @Override
        public String canonicalPath(String path) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("canonicalPath(" + path + ") client is closed");
            }
            return this.delegate.canonicalPath(path);
        }

        @Override
        public SftpClient.Attributes stat(String path) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("stat(" + path + ") client is closed");
            }
            return this.delegate.stat(path);
        }

        @Override
        public SftpClient.Attributes lstat(String path) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("lstat(" + path + ") client is closed");
            }
            return this.delegate.lstat(path);
        }

        @Override
        public SftpClient.Attributes stat(SftpClient.Handle handle) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("stat(" + handle + ") client is closed");
            }
            return this.delegate.stat(handle);
        }

        @Override
        public void setStat(String path, SftpClient.Attributes attributes) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("setStat(" + path + ")[" + attributes + "] client is closed");
            }
            this.delegate.setStat(path, attributes);
        }

        @Override
        public void setStat(SftpClient.Handle handle, SftpClient.Attributes attributes) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("setStat(" + handle + ")[" + attributes + "] client is closed");
            }
            this.delegate.setStat(handle, attributes);
        }

        @Override
        public String readLink(String path) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("readLink(" + path + ") client is closed");
            }
            return this.delegate.readLink(path);
        }

        @Override
        public void symLink(String linkPath, String targetPath) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("symLink(" + linkPath + " => " + targetPath + ") client is closed");
            }
            this.delegate.symLink(linkPath, targetPath);
        }

        @Override
        public Iterable<SftpClient.DirEntry> readDir(String path) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("readDir(" + path + ") client is closed");
            }
            return this.delegate.readDir(path);
        }

        @Override
        public InputStream read(String path) throws IOException {
            return this.read(path, this.readSize);
        }

        @Override
        public InputStream read(String path, SftpClient.OpenMode ... mode) throws IOException {
            return this.read(path, this.readSize, mode);
        }

        @Override
        public InputStream read(String path, Collection<SftpClient.OpenMode> mode) throws IOException {
            return this.read(path, this.readSize, mode);
        }

        @Override
        public InputStream read(String path, int bufferSize, Collection<SftpClient.OpenMode> mode) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("read(" + path + ")[" + mode + "] size=" + bufferSize + ": client is closed");
            }
            return this.delegate.read(path, bufferSize, mode);
        }

        @Override
        public OutputStream write(String path) throws IOException {
            return this.write(path, this.writeSize);
        }

        @Override
        public OutputStream write(String path, SftpClient.OpenMode ... mode) throws IOException {
            return this.write(path, this.writeSize, mode);
        }

        @Override
        public OutputStream write(String path, Collection<SftpClient.OpenMode> mode) throws IOException {
            return this.write(path, this.writeSize, mode);
        }

        @Override
        public OutputStream write(String path, int bufferSize, Collection<SftpClient.OpenMode> mode) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("write(" + path + ")[" + mode + "] size=" + bufferSize + ": client is closed");
            }
            return this.delegate.write(path, bufferSize, mode);
        }

        @Override
        public void link(String linkPath, String targetPath, boolean symbolic) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("link(" + linkPath + " => " + targetPath + "] symbolic=" + symbolic + ": client is closed");
            }
            this.delegate.link(linkPath, targetPath, symbolic);
        }

        @Override
        public void lock(SftpClient.Handle handle, long offset, long length, int mask) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("lock(" + handle + ")[offset=" + offset + ", length=" + length + ", mask=0x" + Integer.toHexString(mask) + "] client is closed");
            }
            this.delegate.lock(handle, offset, length, mask);
        }

        @Override
        public void unlock(SftpClient.Handle handle, long offset, long length) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("unlock" + handle + ")[offset=" + offset + ", length=" + length + "] client is closed");
            }
            this.delegate.unlock(handle, offset, length);
        }

        @Override
        public int send(int cmd, Buffer buffer) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("send(cmd=" + SftpConstants.getCommandMessageName(cmd) + ") client is closed");
            }
            if (this.delegate instanceof RawSftpClient) {
                return ((RawSftpClient)((Object)this.delegate)).send(cmd, buffer);
            }
            throw new StreamCorruptedException("send(cmd=" + SftpConstants.getCommandMessageName(cmd) + ") delegate is not a " + RawSftpClient.class.getSimpleName());
        }

        @Override
        public Buffer receive(int id) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("receive(id=" + id + ") client is closed");
            }
            if (this.delegate instanceof RawSftpClient) {
                return ((RawSftpClient)((Object)this.delegate)).receive(id);
            }
            throw new StreamCorruptedException("receive(id=" + id + ") delegate is not a " + RawSftpClient.class.getSimpleName());
        }

        @Override
        public Buffer receive(int id, long timeout) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("receive(id=" + id + ", timeout=" + timeout + ") client is closed");
            }
            if (this.delegate instanceof RawSftpClient) {
                return ((RawSftpClient)((Object)this.delegate)).receive(id, timeout);
            }
            throw new StreamCorruptedException("receive(id=" + id + ", timeout=" + timeout + ") delegate is not a " + RawSftpClient.class.getSimpleName());
        }
    }
}

