/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal.element;

import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.extender.whiteboard.internal.element.WebElement;
import org.ops4j.pax.web.service.WebContainer;
import org.ops4j.pax.web.service.whiteboard.ResourceMapping;
import org.ops4j.pax.web.service.whiteboard.WhiteboardResource;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceWebElement
extends WebElement<Object>
implements WhiteboardResource {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceWebElement.class);
    private ResourceMapping resourceMapping;

    public ResourceWebElement(ServiceReference<Object> ref, ResourceMapping resourceMapping) {
        super(ref);
        NullArgumentException.validateNotNull(resourceMapping, "Resource mapping");
        this.resourceMapping = resourceMapping;
    }

    @Override
    public void register(WebContainer webContainer, HttpContext httpContext) throws Exception {
        webContainer.registerResources(this.resourceMapping.getAlias(), this.resourceMapping.getPath(), httpContext);
    }

    @Override
    public String getHttpContextId() {
        return this.resourceMapping.getHttpContextId();
    }

    @Override
    public void unregister(WebContainer webContainer, HttpContext httpContext) {
        webContainer.unregister(this.resourceMapping.getAlias());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{mapping=" + this.resourceMapping + "}";
    }

    public ResourceMapping getResourceMapping() {
        return this.resourceMapping;
    }
}

