/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.core.event;

import org.apache.karaf.cellar.core.event.Event;
import org.apache.karaf.cellar.core.event.EventHandler;
import org.apache.karaf.cellar.core.event.EventHandlerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventDispatchTask<E extends Event>
implements Runnable {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(EventDispatchTask.class);
    private static final long DEFAULT_TIMEOUT = 30000L;
    private E event;
    private EventHandlerRegistry handlerRegistry;
    private long timeout;
    private long interval = 1000L;

    public EventDispatchTask(E event, EventHandlerRegistry handlerRegistry) {
        this.event = event;
        this.handlerRegistry = handlerRegistry;
        if (System.getProperty("cellar.timeout") != null) {
            try {
                this.timeout = Long.parseLong(System.getProperty("cellar.timeout"));
            }
            catch (Exception e) {
                this.timeout = 30000L;
            }
        } else {
            this.timeout = 30000L;
        }
    }

    public EventDispatchTask(E event, EventHandlerRegistry handlerRegistry, long timeout) {
        this.event = event;
        this.handlerRegistry = handlerRegistry;
        this.timeout = timeout;
    }

    public EventDispatchTask(EventHandlerRegistry handlerRegistry, long timeout, long interval, E event) {
        this.handlerRegistry = handlerRegistry;
        this.timeout = timeout;
        this.interval = interval;
        this.event = event;
    }

    @Override
    public void run() {
        try {
            boolean dispatched = false;
            for (long delay = 0L; delay < this.timeout && !dispatched; delay += this.interval) {
                EventHandler<E> handler = this.handlerRegistry.getHandler(this.event);
                if (handler != null) {
                    handler.handle(this.event);
                    dispatched = true;
                    continue;
                }
                try {
                    Thread.sleep(this.interval);
                    continue;
                }
                catch (InterruptedException e) {
                    LOGGER.warn("Interrupted while waiting for cluster event handler", (Throwable)e);
                }
            }
            if (!dispatched) {
                LOGGER.warn("Failed to retrieve handler for cluster event {}", this.event.getClass());
            }
        }
        catch (Exception ex) {
            LOGGER.error("Error while dispatching task", (Throwable)ex);
        }
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }
}

