/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.core;

import java.io.IOException;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.karaf.cellar.core.ClusterManager;
import org.apache.karaf.cellar.core.Group;
import org.apache.karaf.cellar.core.GroupManager;
import org.apache.karaf.cellar.core.event.EventType;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CellarSupport {
    protected static final transient Logger LOGGER = LoggerFactory.getLogger(CellarSupport.class);
    protected ClusterManager clusterManager;
    protected GroupManager groupManager;
    protected ConfigurationAdmin configurationAdmin;

    public void switchListEntry(String listType, String group, String category, EventType type, String entry) throws Exception {
        if (group != null) {
            String key;
            Configuration configuration = this.configurationAdmin.getConfiguration("org.apache.karaf.cellar.groups", null);
            Dictionary dictionary = configuration.getProperties();
            if (dictionary == null) {
                dictionary = new Properties();
            }
            if (dictionary.get(key = group + "." + category + "." + listType + "." + type.name().toLowerCase()) != null) {
                String value = dictionary.get(key).toString();
                value = value.contains(entry) ? value.replace(entry, "") : value + "," + entry;
                if (value.startsWith(",")) {
                    value = value.substring(1);
                }
                if (value.endsWith(",")) {
                    value = value.substring(0, value.length() - 1);
                }
                value = value.replace("\n\n", "");
                value = value.replace(",,", ",");
                dictionary.put(key, value);
            } else {
                dictionary.put(key, entry);
            }
            configuration.update(dictionary);
        }
    }

    public Set<String> getListEntries(String listType, String group, String category, EventType type) {
        Set<String> result = null;
        if (group != null) {
            try {
                Configuration configuration = this.configurationAdmin.getConfiguration("org.apache.karaf.cellar.groups", null);
                Dictionary dictionary = configuration.getProperties();
                if (dictionary != null) {
                    String[] itemList;
                    String propertyName;
                    String propertyValue;
                    String parent = (String)dictionary.get(group + "." + "parent");
                    if (parent != null) {
                        result = this.getListEntries(listType, parent, category, type);
                    }
                    if ((propertyValue = (String)dictionary.get(propertyName = group + "." + category + "." + listType + "." + type.name().toLowerCase())) != null && (itemList = (propertyValue = propertyValue.replaceAll("\n", "")).split(",")) != null && itemList.length > 0) {
                        if (result == null) {
                            result = new HashSet<String>();
                        }
                        for (String item : itemList) {
                            if (item == null) continue;
                            result.add(item.trim());
                        }
                    }
                }
            }
            catch (IOException e) {
                LOGGER.error("Error looking up for clustering group configuration cfg");
            }
        }
        return result;
    }

    public Set<String> getListEntries(String listType, Collection<String> groups, String category, EventType type) {
        HashSet<String> result = null;
        if (groups != null && !groups.isEmpty()) {
            for (String group : groups) {
                Set<String> items = this.getListEntries(listType, group, category, type);
                if (items == null || items.isEmpty()) continue;
                if (result == null) {
                    result = new HashSet<String>();
                }
                result.addAll(items);
            }
        }
        return result;
    }

    public Set<String> getListEntries(String listType, Group group, String category, EventType type) {
        String groupName;
        Set<String> items;
        HashSet<String> result = null;
        if (group != null && (items = this.getListEntries(listType, groupName = group.getName(), category, type)) != null && !items.isEmpty()) {
            if (result == null) {
                result = new HashSet<String>();
            }
            result.addAll(items);
        }
        return result;
    }

    public Boolean isAllowed(Group group, String category, String event, EventType type) {
        Set<String> whiteList = this.getListEntries("whitelist", group, category, type);
        Set<String> blackList = this.getListEntries("blacklist", group, category, type);
        if (blackList == null || whiteList == null) {
            LOGGER.warn("No whitelist/blacklist found for " + group.getName() + ", check your configuration !");
            return false;
        }
        Boolean result = true;
        if (!whiteList.isEmpty()) {
            result = false;
            for (String whiteListItem : whiteList) {
                if (!this.wildCardMatch(event, whiteListItem)) continue;
                result = true;
                break;
            }
        }
        if (result.booleanValue()) {
            for (String blackListItem : blackList) {
                if (!this.wildCardMatch(event, blackListItem)) continue;
                return false;
            }
        }
        return result;
    }

    protected boolean wildCardMatch(String item, String pattern) {
        if (item == null || pattern == null) {
            return false;
        }
        pattern = pattern.replace("*", ".*");
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(item);
        return m.matches();
    }

    public ConfigurationAdmin getConfigurationAdmin() {
        return this.configurationAdmin;
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    public ClusterManager getClusterManager() {
        return this.clusterManager;
    }

    public void setClusterManager(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }

    public GroupManager getGroupManager() {
        return this.groupManager;
    }

    public void setGroupManager(GroupManager groupManager) {
        this.groupManager = groupManager;
    }

    protected Map<String, Boolean> getSynchronizerMap() {
        return this.clusterManager.getMap("org.apache.karaf.cellar.synchronizers");
    }
}

