/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.shell.commands;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.unomi.api.PartialList;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.query.Query;
import org.apache.unomi.api.services.DefinitionsService;
import org.apache.unomi.api.services.ProfileService;
import org.apache.unomi.common.DataTable;
import org.apache.unomi.shell.commands.ListCommandSupport;

@Command(scope="unomi", name="profile-list", description="This commands lists the latest profiles updated in the Apache Unomi Context Server")
@Service
public class ProfileList
extends ListCommandSupport {
    @Reference
    ProfileService profileService;
    @Reference
    DefinitionsService definitionsService;
    @Argument(index=0, name="maxEntries", description="The maximum number of entries to retrieve (defaults to 100)", required=false, multiValued=false)
    int maxEntries = 100;

    @Override
    protected String[] getHeaders() {
        return new String[]{"ID", "Scope", "Segments", "Consents", "Last visit", "Last update"};
    }

    @Override
    protected DataTable buildDataTable() {
        Query query = new Query();
        query.setSortby("systemProperties.lastUpdated:desc,properties.lastVisit:desc");
        query.setLimit(this.maxEntries);
        Condition matchAllCondition = new Condition(this.definitionsService.getConditionType("matchAllCondition"));
        query.setCondition(matchAllCondition);
        PartialList lastModifiedProfiles = this.profileService.search(query, Profile.class);
        DataTable dataTable = new DataTable();
        for (Profile profile : lastModifiedProfiles.getList()) {
            ArrayList<String> rowData = new ArrayList<String>();
            rowData.add(profile.getItemId());
            rowData.add(profile.getScope());
            rowData.add(StringUtils.join((Iterable)profile.getSegments(), (String)","));
            rowData.add(StringUtils.join(profile.getConsents().keySet(), (String)","));
            rowData.add((String)profile.getProperty("lastVisit"));
            if (profile.getSystemProperties() != null && profile.getSystemProperties().get("lastUpdated") != null) {
                rowData.add((String)profile.getSystemProperties().get("lastUpdated"));
            } else {
                rowData.add("");
            }
            dataTable.addRow(rowData.toArray(new Comparable[rowData.size()]));
        }
        return dataTable;
    }
}

