/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.karaf.commands;

import java.util.List;
import org.apache.cxf.Bus;
import org.apache.cxf.karaf.commands.internal.CXFController;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.Terminal;
import org.apache.karaf.shell.support.table.ShellTable;

@Command(scope="cxf", name="list-busses", description="Lists all CXF Busses.")
@Service
public class ListBussesCommand
extends CXFController
implements Action {
    @Reference(optional=true)
    Terminal terminal;
    @Option(name="--no-format", description="Disable table rendered output", required=false, multiValued=false)
    boolean noFormat;

    public Object execute() throws Exception {
        List<Bus> busses = this.getBusses();
        ShellTable table = new ShellTable();
        if (this.terminal != null && this.terminal.getWidth() > 0) {
            table.size(this.terminal.getWidth());
        }
        table.column("Name");
        table.column("State");
        for (Bus bus : busses) {
            String name = bus.getId();
            String state = bus.getState().toString();
            table.addRow().addContent(new Object[]{name, state});
        }
        table.print(System.out, !this.noFormat);
        return null;
    }
}

