/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.logback.internal.spi;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.CoreConstants;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.ops4j.pax.logging.logback.internal.spi.PaxLevelForLogback;
import org.ops4j.pax.logging.logback.internal.spi.PaxLocationInfoForLogback;
import org.ops4j.pax.logging.spi.PaxLevel;
import org.ops4j.pax.logging.spi.PaxLocationInfo;
import org.ops4j.pax.logging.spi.PaxLoggingEvent;

public class PaxLoggingEventForLogback
implements PaxLoggingEvent {
    private final ILoggingEvent event;

    public PaxLoggingEventForLogback(ILoggingEvent event) {
        this.event = event;
    }

    public PaxLocationInfo getLocationInformation() {
        return new PaxLocationInfoForLogback(this.event.getCallerData());
    }

    public PaxLevel getLevel() {
        return new PaxLevelForLogback(this.event.getLevel());
    }

    public String getLoggerName() {
        return this.event.getLoggerName();
    }

    public String getMessage() {
        return this.event.getMessage();
    }

    public String getRenderedMessage() {
        return this.event.getFormattedMessage();
    }

    public String getThreadName() {
        return this.event.getThreadName();
    }

    public String[] getThrowableStrRep() {
        StringBuilder sb = new StringBuilder();
        for (IThrowableProxy tp = this.event.getThrowableProxy(); tp != null; tp = tp.getCause()) {
            ThrowableProxyUtil.subjoinFirstLine(sb, tp);
            sb.append(CoreConstants.LINE_SEPARATOR);
            ThrowableProxyUtil.subjoinSTEPArray(sb, 1, tp);
        }
        return sb.toString().split(CoreConstants.LINE_SEPARATOR);
    }

    public boolean locationInformationExists() {
        return this.event.hasCallerData();
    }

    public long getTimeStamp() {
        return this.event.getTimeStamp();
    }

    public String getFQNOfLoggerClass() {
        return Logger.class.getName();
    }

    public Map<String, Object> getProperties() {
        return new HashMap<String, Object>(this.event.getMDCPropertyMap());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaxLoggingEventForLogback that = (PaxLoggingEventForLogback)o;
        return Objects.equals(this.event, that.event);
    }

    public int hashCode() {
        return this.event != null ? this.event.hashCode() : 0;
    }
}

