/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.config.shell;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.karaf.cellar.config.ConfigurationSupport;
import org.apache.karaf.cellar.config.shell.ConfigCommandSupport;
import org.apache.karaf.cellar.core.Group;
import org.apache.karaf.cellar.core.event.EventType;
import org.apache.karaf.cellar.core.shell.completer.AllGroupsCompleter;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.osgi.service.cm.Configuration;

@Command(scope="cluster", name="config-list", description="List the configurations in a cluster group")
@Service
public class ListCommand
extends ConfigCommandSupport {
    @Argument(index=0, name="group", description="The cluster group name", required=true, multiValued=false)
    @Completion(value=AllGroupsCompleter.class)
    String groupName;
    @Argument(index=1, name="pid", description="The configuration PID to look for", required=false, multiValued=false)
    String searchPid;
    @Option(name="-m", aliases={"--minimal"}, description="Don't display the properties of each configuration", required=false, multiValued=false)
    boolean minimal;
    @Option(name="--cluster", description="Shows only configurations on the cluster", required=false, multiValued=false)
    boolean onlyCluster;
    @Option(name="--local", description="Shows only configurations on the local node", required=false, multiValued=false)
    boolean onlyLocal;
    @Option(name="--blocked", description="Shows only blocked configurations", required=false, multiValued=false)
    boolean onlyBlocked;

    protected Object doExecute() throws Exception {
        Group group = this.groupManager.findGroupByName(this.groupName);
        if (group == null) {
            System.err.println("Cluster group " + this.groupName + " doesn't exist");
            return null;
        }
        ConfigurationSupport support = new ConfigurationSupport();
        support.setClusterManager(this.clusterManager);
        support.setGroupManager(this.groupManager);
        support.setConfigurationAdmin(this.configurationAdmin);
        Map<String, ConfigurationState> configurations = this.gatherConfigurations();
        if (configurations != null && !configurations.isEmpty()) {
            for (String pid : configurations.keySet()) {
                Properties properties;
                if (this.searchPid != null && (this.searchPid == null || !this.searchPid.equals(pid))) continue;
                ConfigurationState state = configurations.get(pid);
                String located = "";
                boolean cluster = state.isCluster();
                boolean local = state.isLocal();
                if (cluster && local) {
                    located = "cluster/local";
                }
                if (cluster && !local) {
                    located = "cluster";
                    if (this.onlyLocal) continue;
                }
                if (local && !cluster) {
                    located = "local";
                    if (this.onlyCluster) continue;
                }
                if (state.getClusterPids() != null && !state.getClusterPids().isEmpty()) {
                    located = located + " (cluster = " + state.getClusterPids() + ")";
                }
                String blocked = "";
                boolean inbound = support.isAllowed(group, "config", pid, EventType.INBOUND);
                boolean outbound = support.isAllowed(group, "config", pid, EventType.OUTBOUND);
                if (inbound && outbound && this.onlyBlocked) continue;
                if (!inbound && !outbound) {
                    blocked = "in/out";
                }
                if (!inbound && outbound) {
                    blocked = "in";
                }
                if (!outbound && inbound) {
                    blocked = "out";
                }
                System.out.println("----------------------------------------------------------------");
                System.out.println("Pid:            " + pid);
                System.out.println("Located:        " + located);
                System.out.println("Blocked:        " + blocked);
                if (this.minimal || (properties = state.getProperties()) == null) continue;
                System.out.println("Properties:");
                Enumeration<Object> e = properties.keys();
                while (e.hasMoreElements()) {
                    Object key = e.nextElement();
                    System.out.println("   " + key + " = " + properties.get(key));
                }
            }
        } else {
            System.err.println("No configuration PID found in cluster group " + this.groupName);
        }
        return null;
    }

    private Map<String, ConfigurationState> gatherConfigurations() throws Exception {
        HashMap<String, ConfigurationState> configurations = new HashMap<String, ConfigurationState>();
        HashMap configurationsByFileName = new HashMap();
        Map clusterConfigurations = this.clusterManager.getMap("org.apache.karaf.cellar.configuration.map." + this.groupName);
        for (String key : clusterConfigurations.keySet()) {
            Properties properties = (Properties)clusterConfigurations.get(key);
            ConfigurationState state = new ConfigurationState();
            state.setPid(key);
            state.setProperties(properties);
            state.setCluster(true);
            state.setLocal(false);
            configurations.put(key, state);
            String filename = properties.getProperty("karaf.cellar.filename");
            if (filename == null) continue;
            configurationsByFileName.putIfAbsent(filename, new ArrayList());
            ((List)configurationsByFileName.get(filename)).add(state);
        }
        for (Configuration configuration : this.configurationAdmin.listConfigurations(null)) {
            String key = configuration.getPid();
            String filename = (String)configuration.getProperties().get("karaf.cellar.filename");
            ConfigurationState state = (ConfigurationState)configurations.get(key);
            if (state == null) {
                state = new ConfigurationState();
                state.setCluster(false);
                state.setProperties(ConfigurationSupport.dictionaryToProperties(configuration.getProperties()));
                configurations.put(key, state);
            }
            state.setLocal(true);
            if (filename == null || !configurationsByFileName.containsKey(filename)) continue;
            state.setCluster(true);
            state.setClusterPids(new ArrayList<String>());
            List states = (List)configurationsByFileName.get(filename);
            for (ConfigurationState otherState : states) {
                if (otherState.getPid().equals(key)) continue;
                configurations.remove(otherState.getPid());
                state.getClusterPids().add(otherState.getPid());
            }
        }
        return configurations;
    }

    class ConfigurationState {
        private Properties properties;
        private boolean cluster;
        private boolean local;
        private String pid;
        private List<String> clusterPids;

        ConfigurationState() {
        }

        public Properties getProperties() {
            return this.properties;
        }

        public void setProperties(Properties properties) {
            this.properties = properties;
        }

        public boolean isCluster() {
            return this.cluster;
        }

        public void setCluster(boolean cluster) {
            this.cluster = cluster;
        }

        public boolean isLocal() {
            return this.local;
        }

        public void setLocal(boolean local) {
            this.local = local;
        }

        public String getPid() {
            return this.pid;
        }

        public void setPid(String pid) {
            this.pid = pid;
        }

        public List<String> getClusterPids() {
            return this.clusterPids;
        }

        public void setClusterPids(List<String> clusterPids) {
            this.clusterPids = clusterPids;
        }
    }
}

