/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.utils.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.service.repository.Repository;

public class AggregateRepository
implements Repository {
    private final Collection<Repository> repositories;

    public AggregateRepository(Collection<Repository> repositories) {
        this.repositories = repositories;
    }

    public Map<Requirement, Collection<Capability>> findProviders(Collection<? extends Requirement> requirements) {
        HashMap<Requirement, Collection<Capability>> result = new HashMap<Requirement, Collection<Capability>>();
        for (Requirement requirement : requirements) {
            ArrayList caps = new ArrayList();
            for (Repository repository : this.repositories) {
                Map resMap = repository.findProviders(Collections.singleton(requirement));
                Collection res = resMap != null ? (Collection)resMap.get(requirement) : null;
                if (res == null) continue;
                caps.addAll(res);
            }
            result.put(requirement, caps);
        }
        return result;
    }
}

