/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi.resource;

import aQute.bnd.version.VersionRange;
import java.util.ArrayList;
import java.util.List;

public class FilterBuilder {
    Sub current = new Sub("&", null);

    public FilterBuilder or() {
        this.current = new Sub("|", this.current);
        return this;
    }

    public FilterBuilder and() {
        this.current = new Sub("&", this.current);
        return this;
    }

    public FilterBuilder not() {
        this.current = new Sub("!", this.current);
        return this;
    }

    public FilterBuilder end() {
        this.current.previous.members.add(this.current);
        this.current = this.current.previous;
        return this;
    }

    public FilterBuilder eq(String key, Object value) {
        return this.simple(key, Operator.EQ, value);
    }

    public FilterBuilder neq(String key, Object value) {
        return this.not().simple(key, Operator.EQ, value).end();
    }

    public FilterBuilder gt(String key, Object value) {
        return this.not().simple(key, Operator.LE, value).end();
    }

    public FilterBuilder lt(String key, Object value) {
        return this.not().simple(key, Operator.GE, value).end();
    }

    public FilterBuilder ge(String key, Object value) {
        return this.simple(key, Operator.GE, value);
    }

    public FilterBuilder le(String key, Object value) {
        return this.simple(key, Operator.LE, value);
    }

    public FilterBuilder isSet(String key) {
        return this.isPresent(key);
    }

    public FilterBuilder approximate(String key, Object value) {
        return this.simple(key, Operator.APPROX, value);
    }

    public FilterBuilder simple(String key, Operator op, Object value) {
        return this.literal("(" + key + op.name + FilterBuilder.escape(value) + ")");
    }

    public FilterBuilder literal(String string) {
        this.current.members.add(string);
        return this;
    }

    private static String escape(Object value) {
        String s = value.toString();
        int len = s.length();
        StringBuilder sb = new StringBuilder(len);
        block3: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '(': 
                case ')': 
                case '\\': {
                    sb.append('\\').append(c);
                    continue block3;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return len == sb.length() ? s : sb.toString();
    }

    public String toString() {
        return this.current.toString();
    }

    public FilterBuilder isPresent(String key) {
        return this.literal("(" + key + "=*)");
    }

    public FilterBuilder in(String key, org.osgi.framework.VersionRange range) {
        this.and();
        if (range.getLeftType() == '[') {
            this.ge(key, range.getLeft());
        } else {
            this.gt(key, range.getLeft());
        }
        if (range.getRightType() == ']') {
            this.le(key, range.getRight());
        } else {
            this.lt(key, range.getRight());
        }
        this.end();
        return this;
    }

    public FilterBuilder in(String key, VersionRange range) {
        this.and();
        if (range.includeLow()) {
            this.ge(key, range.getLow());
        } else {
            this.gt(key, range.getLow());
        }
        if (range.includeHigh()) {
            this.le(key, range.getHigh());
        } else {
            this.lt(key, range.getHigh());
        }
        this.end();
        return this;
    }

    public void endAnd() {
        if (!this.current.op.equals("&")) {
            throw new IllegalStateException("Expected an & but had " + this.current.op);
        }
        this.end();
    }

    public void endOr() {
        if (!this.current.op.equals("|")) {
            throw new IllegalStateException("Expected an | but had " + this.current.op);
        }
        this.end();
    }

    static class Sub {
        Sub previous;
        String op;
        List<Object> members = new ArrayList<Object>();

        public Sub(String op, Sub current) {
            this.op = op;
            this.previous = current;
        }

        public String toString() {
            if (this.members.isEmpty()) {
                return "";
            }
            if (!this.op.equals("!") && this.members.size() == 1) {
                return this.members.get(0).toString();
            }
            StringBuilder sb = new StringBuilder();
            sb.append("(").append(this.op);
            for (Object top : this.members) {
                sb.append(top);
            }
            sb.append(")");
            return sb.toString();
        }
    }

    public static enum Operator {
        EQ("="),
        APPROX("~="),
        GE(">="),
        LE("<=");

        String name;

        private Operator(String name) {
            this.name = name;
        }
    }
}

