/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi;

import aQute.bnd.http.HttpClient;
import aQute.bnd.osgi.Resource;
import aQute.bnd.service.url.TaggedData;
import aQute.lib.io.IO;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.util.jar.JarFile;

class URLResource
implements Resource {
    private static final ByteBuffer CLOSED = ByteBuffer.allocate(0);
    private ByteBuffer buffer;
    private final URL url;
    private final HttpClient client;
    private String extra;
    private long lastModified = -1L;
    private int size = -1;

    URLResource(URL url, HttpClient client) {
        this.url = url;
        this.client = client;
    }

    @Override
    public ByteBuffer buffer() throws Exception {
        return this.getBuffer().duplicate();
    }

    private ByteBuffer getBuffer() throws Exception {
        if (this.buffer != null) {
            return this.buffer;
        }
        InputStream in = this.open();
        if (this.size == -1) {
            this.buffer = ByteBuffer.wrap(IO.read(in));
            return this.buffer;
        }
        ByteBuffer bb = IO.copy(in, ByteBuffer.allocate(this.size));
        bb.flip();
        this.buffer = bb;
        return this.buffer;
    }

    private InputStream open() throws Exception {
        InputStream in;
        URLConnection conn;
        if (this.client != null) {
            TaggedData tag = this.client.connectTagged(this.url);
            conn = tag.getConnection();
            in = tag.getInputStream();
        } else {
            conn = this.url.openConnection();
            conn.connect();
            in = conn.getInputStream();
        }
        this.lastModified = conn.getLastModified();
        int length = conn.getContentLength();
        if (length != -1) {
            this.size = length;
        }
        return in;
    }

    @Override
    public InputStream openInputStream() throws Exception {
        return IO.stream(this.buffer());
    }

    public String toString() {
        return ":" + this.url.toExternalForm() + ":";
    }

    @Override
    public void write(OutputStream out) throws Exception {
        if (this.buffer != null) {
            IO.copy(this.buffer(), out);
        } else {
            IO.copy(this.open(), out);
        }
    }

    @Override
    public long lastModified() {
        if (this.lastModified >= 0L) {
            return this.lastModified;
        }
        try {
            this.getBuffer();
        }
        catch (Exception e) {
            this.lastModified = 0L;
        }
        return this.lastModified;
    }

    @Override
    public String getExtra() {
        return this.extra;
    }

    @Override
    public void setExtra(String extra) {
        this.extra = extra;
    }

    @Override
    public long size() throws Exception {
        if (this.size >= 0) {
            return this.size;
        }
        this.size = this.getBuffer().limit();
        return this.size;
    }

    @Override
    public void close() throws IOException {
        this.buffer = CLOSED;
    }

    static class JarURLUtil
    extends JarURLConnection {
        JarURLUtil(URL url) throws MalformedURLException {
            super(url);
        }

        @Override
        public JarFile getJarFile() throws IOException {
            return null;
        }

        @Override
        public void connect() throws IOException {
        }
    }
}

