/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356.server.deploy;

import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.annotation.HandlesTypes;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.server.ServerApplicationConfig;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.listener.ContainerInitializer;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ThreadClassLoaderScope;
import org.eclipse.jetty.websocket.jsr356.server.ServerContainer;
import org.eclipse.jetty.websocket.server.NativeWebSocketConfiguration;
import org.eclipse.jetty.websocket.server.NativeWebSocketServletContainerInitializer;
import org.eclipse.jetty.websocket.server.WebSocketUpgradeFilter;

@HandlesTypes(value={ServerApplicationConfig.class, ServerEndpoint.class, Endpoint.class})
public class WebSocketServerContainerInitializer
implements ServletContainerInitializer {
    public static final String ATTR_JAVAX_SERVER_CONTAINER = javax.websocket.server.ServerContainer.class.getName();
    public static final String ENABLE_KEY = "org.eclipse.jetty.websocket.jsr356";
    public static final String ADD_DYNAMIC_FILTER_KEY = "org.eclipse.jetty.websocket.jsr356.addDynamicFilter";
    private static final Logger LOG = Log.getLogger(WebSocketServerContainerInitializer.class);
    public static final String HTTPCLIENT_ATTRIBUTE = "org.eclipse.jetty.websocket.jsr356.HttpClient";

    public static boolean isEnabledViaContext(ServletContext context, String keyName, boolean defValue) {
        String cp = context.getInitParameter(keyName);
        if (cp != null) {
            if (TypeUtil.isTrue((Object)cp)) {
                return true;
            }
            if (TypeUtil.isFalse((Object)cp)) {
                return false;
            }
            return defValue;
        }
        Object enable = context.getAttribute(keyName);
        if (enable != null) {
            if (TypeUtil.isTrue((Object)enable)) {
                return true;
            }
            if (TypeUtil.isFalse((Object)enable)) {
                return false;
            }
        }
        return defValue;
    }

    @Deprecated
    public static ServerContainer configureContext(ServletContextHandler context) throws ServletException {
        return WebSocketServerContainerInitializer.initialize(context);
    }

    @Deprecated
    public static ServerContainer configureContext(ServletContext context, ServletContextHandler jettyContext) throws ServletException {
        return WebSocketServerContainerInitializer.initialize(jettyContext);
    }

    public static ServerContainer initialize(ServletContextHandler context) throws ServletException {
        ServerContainer serverContainer = (ServerContainer)((Object)context.getAttribute(ATTR_JAVAX_SERVER_CONTAINER));
        if (serverContainer == null) {
            Server server;
            NativeWebSocketConfiguration nativeWebSocketConfiguration = NativeWebSocketServletContainerInitializer.initialize((ServletContextHandler)context);
            HttpClient httpClient = (HttpClient)context.getAttribute(HTTPCLIENT_ATTRIBUTE);
            if (httpClient == null && (server = context.getServer()) != null) {
                httpClient = (HttpClient)server.getAttribute(HTTPCLIENT_ATTRIBUTE);
            }
            serverContainer = new ServerContainer(nativeWebSocketConfiguration, httpClient);
            context.addBean((Object)serverContainer);
            context.setAttribute(ATTR_JAVAX_SERVER_CONTAINER, (Object)serverContainer);
            if (WebSocketServerContainerInitializer.isEnabledViaContext((ServletContext)context.getServletContext(), ADD_DYNAMIC_FILTER_KEY, true)) {
                WebSocketUpgradeFilter.configure((ServletContextHandler)context);
            }
        }
        return serverContainer;
    }

    public static void configure(ServletContextHandler context, Configurator configurator) {
        context.getServletContext().setExtendedListenerTypes(true);
        context.addEventListener((EventListener)ContainerInitializer.asContextListener((ServletContainerInitializer)new WebSocketServerContainerInitializer()).afterStartup(servletContext -> {
            ServerContainer serverContainer = (ServerContainer)((Object)((Object)servletContext.getAttribute(ATTR_JAVAX_SERVER_CONTAINER)));
            if (configurator != null) {
                try {
                    configurator.accept((ServletContext)servletContext, serverContainer);
                }
                catch (DeploymentException e) {
                    throw new RuntimeException("Failed to deploy WebSocket Endpoint", e);
                }
            }
        }));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onStartup(Set<Class<?>> c, ServletContext context) throws ServletException {
        if (!WebSocketServerContainerInitializer.isEnabledViaContext(context, ENABLE_KEY, true)) {
            LOG.info("JSR-356 is disabled by configuration for context {}", new Object[]{context.getContextPath()});
            return;
        }
        ServletContextHandler handler = ServletContextHandler.getServletContextHandler((ServletContext)context);
        if (handler == null) {
            throw new ServletException("Not running on Jetty, JSR-356 support unavailable");
        }
        try (ThreadClassLoaderScope scope = new ThreadClassLoaderScope(context.getClassLoader());){
            ServerContainer jettyContainer = WebSocketServerContainerInitializer.initialize(handler);
            context.addListener((EventListener)((Object)new ContextDestroyListener()));
            if (c.isEmpty()) {
                if (!LOG.isDebugEnabled()) return;
                LOG.debug("No JSR-356 annotations or interfaces discovered", new Object[0]);
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found {} classes", (long)c.size());
            }
            HashSet<Class<? extends Endpoint>> discoveredExtendedEndpoints = new HashSet<Class<? extends Endpoint>>();
            HashSet discoveredAnnotatedEndpoints = new HashSet();
            HashSet<Class<? extends ServerApplicationConfig>> serverAppConfigs = new HashSet<Class<? extends ServerApplicationConfig>>();
            this.filterClasses(c, discoveredExtendedEndpoints, discoveredAnnotatedEndpoints, serverAppConfigs);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Discovered {} extends Endpoint classes", (long)discoveredExtendedEndpoints.size());
                LOG.debug("Discovered {} @ServerEndpoint classes", (long)discoveredAnnotatedEndpoints.size());
                LOG.debug("Discovered {} ServerApplicationConfig classes", (long)serverAppConfigs.size());
            }
            boolean wasFiltered = false;
            HashSet deployableExtendedEndpointConfigs = new HashSet();
            HashSet deployableAnnotatedEndpoints = new HashSet();
            for (Class clazz : serverAppConfigs) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found ServerApplicationConfig: {}", new Object[]{clazz});
                }
                try {
                    Set annotatedClasses;
                    ServerApplicationConfig config = (ServerApplicationConfig)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    Set seconfigs = config.getEndpointConfigs(discoveredExtendedEndpoints);
                    if (seconfigs != null) {
                        wasFiltered = true;
                        deployableExtendedEndpointConfigs.addAll(seconfigs);
                    }
                    if ((annotatedClasses = config.getAnnotatedEndpointClasses(discoveredAnnotatedEndpoints)) == null) continue;
                    wasFiltered = true;
                    deployableAnnotatedEndpoints.addAll(annotatedClasses);
                }
                catch (Exception e) {
                    throw new ServletException("Unable to instantiate: " + clazz.getName(), (Throwable)e);
                }
            }
            if (!wasFiltered) {
                deployableAnnotatedEndpoints.addAll(discoveredAnnotatedEndpoints);
                deployableExtendedEndpointConfigs = new HashSet();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Deploying {} ServerEndpointConfig(s)", (long)deployableExtendedEndpointConfigs.size());
            }
            for (ServerEndpointConfig serverEndpointConfig : deployableExtendedEndpointConfigs) {
                try {
                    jettyContainer.addEndpoint(serverEndpointConfig);
                }
                catch (DeploymentException e) {
                    throw new ServletException((Throwable)e);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Deploying {} @ServerEndpoint(s)", (long)deployableAnnotatedEndpoints.size());
            }
            for (Class clazz : deployableAnnotatedEndpoints) {
                try {
                    jettyContainer.addEndpoint(clazz);
                }
                catch (DeploymentException e) {
                    throw new ServletException((Throwable)e);
                    return;
                }
            }
        }
    }

    private void filterClasses(Set<Class<?>> c, Set<Class<? extends Endpoint>> discoveredExtendedEndpoints, Set<Class<?>> discoveredAnnotatedEndpoints, Set<Class<? extends ServerApplicationConfig>> serverAppConfigs) {
        for (Class<?> clazz : c) {
            ServerEndpoint endpoint;
            if (ServerApplicationConfig.class.isAssignableFrom(clazz)) {
                serverAppConfigs.add(clazz);
            }
            if (Endpoint.class.isAssignableFrom(clazz)) {
                discoveredExtendedEndpoints.add(clazz);
            }
            if ((endpoint = clazz.getAnnotation(ServerEndpoint.class)) == null) continue;
            discoveredAnnotatedEndpoints.add(clazz);
        }
    }

    public static interface Configurator {
        public void accept(ServletContext var1, ServerContainer var2) throws DeploymentException;
    }

    public static class ContextDestroyListener
    implements ServletContextListener {
        public void contextInitialized(ServletContextEvent sce) {
        }

        public void contextDestroyed(ServletContextEvent sce) {
            ServerContainer bean;
            ServletContextHandler handler = ServletContextHandler.getServletContextHandler((ServletContext)sce.getServletContext());
            if (handler != null && (bean = (ServerContainer)((Object)handler.getBean(ServerContainer.class))) != null) {
                handler.removeBean((Object)bean);
            }
            sce.getServletContext().removeAttribute(javax.websocket.server.ServerContainer.class.getName());
        }
    }
}

