/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.utils;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;

public class URLPathEncoder {
    private static boolean[] safe;
    private static final char[] HEXADECIMAL;
    private static final String[] SCHEME_PREFIXES;

    private static String encodePath(String path) {
        int validColonPrefixLen = 0;
        for (String scheme : SCHEME_PREFIXES) {
            if (!path.startsWith(scheme)) continue;
            validColonPrefixLen = scheme.length();
            break;
        }
        byte[] pathBytes = path.getBytes(StandardCharsets.UTF_8);
        StringBuilder encodedPath = new StringBuilder(pathBytes.length * 3);
        for (int i = 0; i < pathBytes.length; ++i) {
            byte pathByte = pathBytes[i];
            int b = pathByte & 0xFF;
            if (safe[b] || b == 58 && i < validColonPrefixLen) {
                encodedPath.append((char)b);
                continue;
            }
            encodedPath.append('%');
            encodedPath.append(HEXADECIMAL[(b & 0xF0) >> 4]);
            encodedPath.append(HEXADECIMAL[b & 0xF]);
        }
        return encodedPath.toString();
    }

    public static URL urlPathToURL(String urlPath) throws MalformedURLException {
        String urlPathNormalized = urlPath;
        if (!(urlPathNormalized.startsWith("jrt:") || urlPathNormalized.startsWith("http://") || urlPathNormalized.startsWith("https://"))) {
            if (!(urlPathNormalized = urlPathNormalized.replace("!/", "!").replace("!", "!/")).startsWith("file:") && !urlPathNormalized.startsWith("jar:")) {
                urlPathNormalized = "file:" + urlPathNormalized;
            }
            if (urlPathNormalized.contains("!") && !urlPathNormalized.startsWith("jar:")) {
                urlPathNormalized = "jar:" + urlPathNormalized;
            }
        }
        urlPathNormalized = URLPathEncoder.encodePath(urlPathNormalized);
        try {
            return new URL(urlPathNormalized);
        }
        catch (MalformedURLException e) {
            throw new MalformedURLException("Cannot parse URL " + urlPathNormalized + ": " + e);
        }
    }

    static {
        int i;
        safe = new boolean[256];
        for (i = 97; i <= 122; ++i) {
            URLPathEncoder.safe[i] = true;
        }
        for (i = 65; i <= 90; ++i) {
            URLPathEncoder.safe[i] = true;
        }
        for (i = 48; i <= 57; ++i) {
            URLPathEncoder.safe[i] = true;
        }
        URLPathEncoder.safe[43] = true;
        URLPathEncoder.safe[46] = true;
        URLPathEncoder.safe[95] = true;
        URLPathEncoder.safe[45] = true;
        URLPathEncoder.safe[36] = true;
        URLPathEncoder.safe[44] = true;
        URLPathEncoder.safe[41] = true;
        URLPathEncoder.safe[40] = true;
        URLPathEncoder.safe[39] = true;
        URLPathEncoder.safe[42] = true;
        URLPathEncoder.safe[33] = true;
        URLPathEncoder.safe[47] = true;
        HEXADECIMAL = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        SCHEME_PREFIXES = new String[]{"jrt:", "file:", "jar:file:", "jar:", "http:", "https:"};
    }
}

