/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.similarities.ClassicSimilarity;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.search.similarities.TFIDFSimilarity;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.lucene.search.XMoreLikeThis;

public class MoreLikeThisQuery
extends Query {
    public static final String DEFAULT_MINIMUM_SHOULD_MATCH = "30%";
    private TFIDFSimilarity similarity;
    private String[] likeText;
    private Fields[] likeFields;
    private String[] unlikeText;
    private Fields[] unlikeFields;
    private String[] moreLikeFields;
    private Analyzer analyzer;
    private String minimumShouldMatch = "30%";
    private int minTermFrequency = 2;
    private int maxQueryTerms = 25;
    private Set<?> stopWords = XMoreLikeThis.DEFAULT_STOP_WORDS;
    private int minDocFreq = 5;
    private int maxDocFreq = Integer.MAX_VALUE;
    private int minWordLen = 0;
    private int maxWordLen = 0;
    private boolean boostTerms = false;
    private float boostTermsFactor = 1.0f;

    public MoreLikeThisQuery() {
    }

    public MoreLikeThisQuery(String likeText, String[] moreLikeFields, Analyzer analyzer) {
        this.likeText = new String[]{likeText};
        this.moreLikeFields = moreLikeFields;
        this.analyzer = analyzer;
    }

    public int hashCode() {
        return Objects.hash(this.classHash(), this.boostTerms, Float.valueOf(this.boostTermsFactor), Arrays.hashCode(this.likeText), this.maxDocFreq, this.maxQueryTerms, this.maxWordLen, this.minDocFreq, this.minTermFrequency, this.minWordLen, Arrays.hashCode(this.moreLikeFields), this.minimumShouldMatch, this.stopWords);
    }

    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        MoreLikeThisQuery other = (MoreLikeThisQuery)((Object)obj);
        if (!this.analyzer.equals(other.analyzer)) {
            return false;
        }
        if (this.boostTerms != other.boostTerms) {
            return false;
        }
        if (this.boostTermsFactor != other.boostTermsFactor) {
            return false;
        }
        if (!Arrays.equals(this.likeText, other.likeText)) {
            return false;
        }
        if (this.maxDocFreq != other.maxDocFreq) {
            return false;
        }
        if (this.maxQueryTerms != other.maxQueryTerms) {
            return false;
        }
        if (this.maxWordLen != other.maxWordLen) {
            return false;
        }
        if (this.minDocFreq != other.minDocFreq) {
            return false;
        }
        if (this.minTermFrequency != other.minTermFrequency) {
            return false;
        }
        if (this.minWordLen != other.minWordLen) {
            return false;
        }
        if (!Arrays.equals(this.moreLikeFields, other.moreLikeFields)) {
            return false;
        }
        if (!this.minimumShouldMatch.equals(other.minimumShouldMatch)) {
            return false;
        }
        if (this.similarity == null ? other.similarity != null : !this.similarity.equals(other.similarity)) {
            return false;
        }
        return !(this.stopWords == null ? other.stopWords != null : !this.stopWords.equals(other.stopWords));
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query rewritten = super.rewrite(reader);
        if (rewritten != this) {
            return rewritten;
        }
        XMoreLikeThis mlt = new XMoreLikeThis(reader, (TFIDFSimilarity)(this.similarity == null ? new ClassicSimilarity() : this.similarity));
        mlt.setFieldNames(this.moreLikeFields);
        mlt.setAnalyzer(this.analyzer);
        mlt.setMinTermFreq(this.minTermFrequency);
        mlt.setMinDocFreq(this.minDocFreq);
        mlt.setMaxDocFreq(this.maxDocFreq);
        mlt.setMaxQueryTerms(this.maxQueryTerms);
        mlt.setMinWordLen(this.minWordLen);
        mlt.setMaxWordLen(this.maxWordLen);
        mlt.setStopWords(this.stopWords);
        mlt.setBoost(this.boostTerms);
        mlt.setBoostFactor(this.boostTermsFactor);
        if (this.unlikeText != null || this.unlikeFields != null) {
            this.handleUnlike(mlt, this.unlikeText, this.unlikeFields);
        }
        return this.createQuery(mlt);
    }

    private Query createQuery(XMoreLikeThis mlt) throws IOException {
        BooleanQuery.Builder bqBuilder = new BooleanQuery.Builder();
        if (this.likeFields != null) {
            Query mltQuery = mlt.like(this.likeFields);
            mltQuery = Queries.applyMinimumShouldMatch((BooleanQuery)mltQuery, this.minimumShouldMatch);
            bqBuilder.add(mltQuery, BooleanClause.Occur.SHOULD);
        }
        if (this.likeText != null) {
            Reader[] readers = new Reader[this.likeText.length];
            for (int i = 0; i < readers.length; ++i) {
                readers[i] = new StringReader(this.likeText[i]);
            }
            Query mltQuery = mlt.like(this.moreLikeFields[0], readers);
            mltQuery = Queries.applyMinimumShouldMatch((BooleanQuery)mltQuery, this.minimumShouldMatch);
            bqBuilder.add(mltQuery, BooleanClause.Occur.SHOULD);
        }
        return bqBuilder.build();
    }

    private void handleUnlike(XMoreLikeThis mlt, String[] unlikeText, Fields[] unlikeFields) throws IOException {
        HashSet<Term> skipTerms = new HashSet<Term>();
        if (unlikeText != null) {
            for (String string : unlikeText) {
                String fieldName = this.moreLikeFields[0];
                try (TokenStream ts = this.analyzer.tokenStream(fieldName, string);){
                    CharTermAttribute termAtt = (CharTermAttribute)ts.addAttribute(CharTermAttribute.class);
                    ts.reset();
                    while (ts.incrementToken()) {
                        skipTerms.add(new Term(fieldName, termAtt.toString()));
                    }
                    ts.end();
                }
            }
        }
        if (unlikeFields != null) {
            for (String string : unlikeFields) {
                Iterator iterator = string.iterator();
                while (iterator.hasNext()) {
                    BytesRef text;
                    String fieldName = (String)iterator.next();
                    Terms terms = string.terms(fieldName);
                    TermsEnum termsEnum = terms.iterator();
                    while ((text = termsEnum.next()) != null) {
                        skipTerms.add(new Term(fieldName, text.utf8ToString()));
                    }
                }
            }
        }
        if (!skipTerms.isEmpty()) {
            mlt.setSkipTerms(skipTerms);
        }
    }

    public String toString(String field) {
        return "like:" + Arrays.toString(this.likeText);
    }

    public String getLikeText() {
        return this.likeText == null ? null : this.likeText[0];
    }

    public String[] getLikeTexts() {
        return this.likeText;
    }

    public void setLikeText(String ... likeText) {
        this.likeText = likeText;
    }

    public Fields[] getLikeFields() {
        return this.likeFields;
    }

    public void setLikeFields(Fields ... likeFields) {
        this.likeFields = likeFields;
    }

    public void setLikeText(List<String> likeText) {
        this.setLikeText(likeText.toArray(Strings.EMPTY_ARRAY));
    }

    public void setUnlikeFields(Fields ... unlikeFields) {
        this.unlikeFields = unlikeFields;
    }

    public void setUnlikeText(String[] unlikeText) {
        this.unlikeText = unlikeText;
    }

    public String[] getMoreLikeFields() {
        return this.moreLikeFields;
    }

    public void setMoreLikeFields(String[] moreLikeFields) {
        this.moreLikeFields = moreLikeFields;
    }

    public Similarity getSimilarity() {
        return this.similarity;
    }

    public void setSimilarity(Similarity similarity) {
        if (similarity == null || similarity instanceof TFIDFSimilarity) {
            this.similarity = (TFIDFSimilarity)similarity;
        }
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public String getMinimumShouldMatch() {
        return this.minimumShouldMatch;
    }

    public void setMinimumShouldMatch(String minimumShouldMatch) {
        this.minimumShouldMatch = minimumShouldMatch;
    }

    public int getMinTermFrequency() {
        return this.minTermFrequency;
    }

    public void setMinTermFrequency(int minTermFrequency) {
        this.minTermFrequency = minTermFrequency;
    }

    public int getMaxQueryTerms() {
        return this.maxQueryTerms;
    }

    public void setMaxQueryTerms(int maxQueryTerms) {
        this.maxQueryTerms = maxQueryTerms;
    }

    public Set<?> getStopWords() {
        return this.stopWords;
    }

    public void setStopWords(Set<?> stopWords) {
        this.stopWords = stopWords;
    }

    public int getMinDocFreq() {
        return this.minDocFreq;
    }

    public void setMinDocFreq(int minDocFreq) {
        this.minDocFreq = minDocFreq;
    }

    public int getMaxDocFreq() {
        return this.maxDocFreq;
    }

    public void setMaxDocFreq(int maxDocFreq) {
        this.maxDocFreq = maxDocFreq;
    }

    public int getMinWordLen() {
        return this.minWordLen;
    }

    public void setMinWordLen(int minWordLen) {
        this.minWordLen = minWordLen;
    }

    public int getMaxWordLen() {
        return this.maxWordLen;
    }

    public void setMaxWordLen(int maxWordLen) {
        this.maxWordLen = maxWordLen;
    }

    public boolean isBoostTerms() {
        return this.boostTerms;
    }

    public void setBoostTerms(boolean boostTerms) {
        this.boostTerms = boostTerms;
    }

    public float getBoostTermsFactor() {
        return this.boostTermsFactor;
    }

    public void setBoostTermsFactor(float boostTermsFactor) {
        this.boostTermsFactor = boostTermsFactor;
    }
}

