/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.io;

import aQute.lib.io.ByteBufferInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;

public class ByteBufferDataOutput
implements DataOutput {
    private ByteBuffer bb;

    public ByteBufferDataOutput() {
        this(4096);
    }

    public ByteBufferDataOutput(int size) {
        this.bb = ByteBuffer.allocate(size);
    }

    public ByteBuffer toByteBuffer() {
        ByteBuffer obb = this.bb.duplicate();
        obb.flip();
        return obb;
    }

    public byte[] toByteArray() {
        ByteBuffer obb = this.toByteBuffer();
        int len = obb.remaining();
        byte[] result = new byte[len];
        obb.get(result, 0, len);
        return result;
    }

    private ByteBuffer bb(int len) {
        ByteBuffer obb = this.bb;
        if (obb.remaining() - len >= 0) {
            return obb;
        }
        int minCap = obb.position() + len;
        int newCap = obb.capacity() << 1;
        if (newCap - minCap < 0) {
            newCap = minCap;
        }
        obb.flip();
        this.bb = ByteBuffer.allocate(newCap).put(obb);
        return this.bb;
    }

    @Override
    public void write(int b) {
        this.bb(1).put((byte)b);
    }

    @Override
    public void write(byte[] b) {
        int len = b.length;
        this.bb(len).put(b, 0, len);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.bb(len).put(b, off, len);
    }

    public void write(ByteBuffer src) {
        this.bb(src.remaining()).put(src);
    }

    public void write(InputStream in) throws IOException {
        ByteBuffer obb;
        if (in instanceof ByteBufferInputStream) {
            ByteBufferInputStream bbin = (ByteBufferInputStream)in;
            this.write(bbin.buffer());
            return;
        }
        do {
            int position;
            int size;
            obb = this.bb(in.available() + 1);
            byte[] buffer = obb.array();
            while (obb.hasRemaining() && (size = in.read(buffer, position = obb.position(), obb.remaining())) > 0) {
                obb.position(position + size);
            }
        } while (!obb.hasRemaining());
    }

    @Override
    public void writeBoolean(boolean v) {
        this.bb(1).put(v ? (byte)1 : 0);
    }

    @Override
    public void writeByte(int v) {
        this.bb(1).put((byte)v);
    }

    @Override
    public void writeShort(int v) {
        this.bb(2).putShort((short)v);
    }

    @Override
    public void writeChar(int v) {
        this.bb(2).putChar((char)v);
    }

    @Override
    public void writeInt(int v) {
        this.bb(4).putInt(v);
    }

    @Override
    public void writeLong(long v) {
        this.bb(8).putLong(v);
    }

    @Override
    public void writeFloat(float v) {
        this.bb(4).putFloat(v);
    }

    @Override
    public void writeDouble(double v) {
        this.bb(8).putDouble(v);
    }

    @Override
    public void writeBytes(String s) {
        int len = s.length();
        ByteBuffer b = this.bb(len * 1);
        for (int i = 0; i < len; ++i) {
            b.put((byte)s.charAt(i));
        }
    }

    @Override
    public void writeChars(String s) {
        int len = s.length();
        ByteBuffer b = this.bb(len * 2);
        for (int i = 0; i < len; ++i) {
            b.putChar(s.charAt(i));
        }
    }

    @Override
    public void writeUTF(String s) throws IOException {
        int i;
        int len;
        int size = len = s.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char c = s.charAt(i2);
            if (c >= '\u0800') {
                size += 2;
                continue;
            }
            if (c < '\u0080' && c != '\u0000') continue;
            ++size;
        }
        if (size > 65535) {
            throw new UTFDataFormatException("encoding too long: " + size);
        }
        ByteBuffer b = this.bb(2 + size);
        b.putShort((short)size);
        if (size == len) {
            for (i = 0; i < len; ++i) {
                b.put((byte)s.charAt(i));
            }
        } else {
            for (i = 0; i < len; ++i) {
                char c = s.charAt(i);
                if (c > '\u0000' && c < '\u0080') {
                    b.put((byte)c);
                    continue;
                }
                if (c >= '\u0800') {
                    b.put((byte)(0xE0 | c >> 12 & 0xF));
                    b.put((byte)(0x80 | c >> 6 & 0x3F));
                    b.put((byte)(0x80 | c & 0x3F));
                    continue;
                }
                b.put((byte)(0xC0 | c >> 6 & 0x1F));
                b.put((byte)(0x80 | c & 0x3F));
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("[pos=");
        sb.append(this.bb.position());
        sb.append(" lim=");
        sb.append(this.bb.limit());
        sb.append(" cap=");
        sb.append(this.bb.capacity());
        sb.append("]");
        return sb.toString();
    }
}

