/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.services.impl.scheduler;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.unomi.api.services.SchedulerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerServiceImpl
implements SchedulerService {
    private static final Logger logger = LoggerFactory.getLogger((String)SchedulerServiceImpl.class.getName());
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private ScheduledExecutorService sharedScheduler;
    private int threadPoolSize;

    public void postConstruct() {
        this.sharedScheduler = Executors.newScheduledThreadPool(this.threadPoolSize);
        logger.info("Scheduler service initialized.");
    }

    public void preDestroy() {
        this.sharedScheduler.shutdown();
        this.scheduler.shutdown();
        logger.info("Scheduler service shutdown.");
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    public ScheduledExecutorService getScheduleExecutorService() {
        return this.scheduler;
    }

    public ScheduledExecutorService getSharedScheduleExecutorService() {
        return this.sharedScheduler;
    }

    public static long getTimeDiffInSeconds(int hourInUtc, ZonedDateTime now) {
        ZonedDateTime nextRun = now.withHour(hourInUtc).withMinute(0).withSecond(0);
        if (now.compareTo(nextRun) > 0) {
            nextRun = nextRun.plusDays(1L);
        }
        Duration duration = Duration.between(now, nextRun);
        long initialDelay = duration.getSeconds();
        return initialDelay;
    }
}

