/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.blueprint.impl;

import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.aries.jmx.blueprint.BlueprintMetadataMBean;
import org.apache.aries.jmx.blueprint.BlueprintStateMBean;
import org.apache.aries.jmx.blueprint.impl.BlueprintMetadata;
import org.apache.aries.jmx.blueprint.impl.BlueprintState;
import org.apache.aries.jmx.blueprint.impl.RegistrableStandardEmitterMBean;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"org.apache.aries.jmx.blueprint");
    protected BundleContext bundleContext;
    protected ObjectName blueprintStateName;
    protected ObjectName blueprintMetadataName;
    protected ServiceTracker mbeanServiceTracker;

    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        this.blueprintStateName = new ObjectName("org.apache.aries.blueprint:service=blueprintState,version=1.0");
        this.blueprintMetadataName = new ObjectName("org.apache.aries.blueprint:service=blueprintMetadata,version=1.0");
        this.mbeanServiceTracker = new ServiceTracker(this.bundleContext, MBeanServer.class.getCanonicalName(), (ServiceTrackerCustomizer)new MBeanServerServiceTracker());
        LOGGER.debug("Awaiting MBeanServer service registration");
        this.mbeanServiceTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        this.mbeanServiceTracker.close();
    }

    protected void registerMBeans(MBeanServer mbeanServer) {
        LOGGER.debug("Registering bundle state monitor with MBeanServer: {} with name: {}", (Object)mbeanServer, (Object)this.blueprintStateName);
        try {
            RegistrableStandardEmitterMBean blueprintState = new RegistrableStandardEmitterMBean(new BlueprintState(this.bundleContext), BlueprintStateMBean.class);
            mbeanServer.registerMBean(blueprintState, this.blueprintStateName);
        }
        catch (InstanceAlreadyExistsException e) {
            LOGGER.debug("Cannot register BlueprintStateMBean");
        }
        catch (MBeanRegistrationException e) {
            LOGGER.error("Cannot register BlueprintStateMBean", (Throwable)e);
        }
        catch (NotCompliantMBeanException e) {
            LOGGER.error("Cannot register BlueprintStateMBean", (Throwable)e);
        }
        LOGGER.debug("Registering bundle metadata monitor with MBeanServer: {} with name: {}", (Object)mbeanServer, (Object)this.blueprintMetadataName);
        try {
            StandardMBean blueprintMetadata = new StandardMBean(new BlueprintMetadata(this.bundleContext), BlueprintMetadataMBean.class);
            mbeanServer.registerMBean(blueprintMetadata, this.blueprintMetadataName);
        }
        catch (InstanceAlreadyExistsException e) {
            LOGGER.debug("Cannot register BlueprintMetadataMBean");
        }
        catch (MBeanRegistrationException e) {
            LOGGER.error("Cannot register BlueprintMetadataMBean", (Throwable)e);
        }
        catch (NotCompliantMBeanException e) {
            LOGGER.error("Cannot register BlueprintMetadataMBean", (Throwable)e);
        }
    }

    protected void deregisterMBeans(MBeanServer mbeanServer) {
        try {
            mbeanServer.unregisterMBean(this.blueprintStateName);
        }
        catch (InstanceNotFoundException e) {
            LOGGER.debug("BlueprintStateMBean not found on deregistration");
        }
        catch (MBeanRegistrationException e) {
            LOGGER.error("BlueprintStateMBean deregistration problem");
        }
        try {
            mbeanServer.unregisterMBean(this.blueprintMetadataName);
        }
        catch (InstanceNotFoundException e) {
            LOGGER.debug("BlueprintMetadataMBean not found on deregistration");
        }
        catch (MBeanRegistrationException e) {
            LOGGER.error("BlueprintMetadataMBean deregistration problem");
        }
    }

    class MBeanServerServiceTracker
    implements ServiceTrackerCustomizer {
        MBeanServerServiceTracker() {
        }

        public Object addingService(ServiceReference servicereference) {
            try {
                LOGGER.debug("Adding MBeanServer: {}", (Object)servicereference);
                MBeanServer mbeanServer = (MBeanServer)Activator.this.bundleContext.getService(servicereference);
                if (mbeanServer != null) {
                    Activator.this.registerMBeans(mbeanServer);
                }
                return mbeanServer;
            }
            catch (RuntimeException e) {
                LOGGER.error("uncaught exception in addingService", (Throwable)e);
                throw e;
            }
        }

        public void removedService(ServiceReference servicereference, Object obj) {
            try {
                LOGGER.debug("Removing MBeanServer: {}", (Object)servicereference);
                Activator.this.deregisterMBeans((MBeanServer)obj);
            }
            catch (Throwable e) {
                LOGGER.debug("uncaught exception in removedService", e);
            }
        }

        public void modifiedService(ServiceReference servicereference, Object obj) {
        }
    }
}

