/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Traceable;
import org.apache.camel.processor.DelegateAsyncProcessor;
import org.apache.camel.processor.StopProcessor;
import org.apache.camel.spi.IdAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamplingThrottler
extends DelegateAsyncProcessor
implements Traceable,
IdAware {
    private static final Logger LOG = LoggerFactory.getLogger(SamplingThrottler.class);
    private String id;
    private long messageFrequency;
    private long currentMessageCount;
    private long samplePeriod;
    private long periodInMillis;
    private TimeUnit units;
    private long timeOfLastExchange;
    private StopProcessor stopper = new StopProcessor();
    private final Object calculationLock = new Object();
    private SampleStats sampled = new SampleStats();

    public SamplingThrottler(Processor processor, long messageFrequency) {
        super(processor);
        if (messageFrequency <= 0L) {
            throw new IllegalArgumentException("A positive value is required for the sampling message frequency");
        }
        this.messageFrequency = messageFrequency;
    }

    public SamplingThrottler(Processor processor, long samplePeriod, TimeUnit units) {
        super(processor);
        if (samplePeriod <= 0L) {
            throw new IllegalArgumentException("A positive value is required for the sampling period");
        }
        if (units == null) {
            throw new IllegalArgumentException("A invalid null value was supplied for the units of the sampling period");
        }
        this.samplePeriod = samplePeriod;
        this.units = units;
        this.periodInMillis = units.toMillis(samplePeriod);
    }

    @Override
    public String toString() {
        if (this.messageFrequency > 0L) {
            return "SamplingThrottler[1 exchange per: " + this.messageFrequency + " messages received -> " + this.getProcessor() + "]";
        }
        return "SamplingThrottler[1 exchange per: " + this.samplePeriod + " " + this.units.toString().toLowerCase(Locale.ENGLISH) + " -> " + this.getProcessor() + "]";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getTraceLabel() {
        if (this.messageFrequency > 0L) {
            return "samplingThrottler[1 exchange per: " + this.messageFrequency + " messages received]";
        }
        return "samplingThrottler[1 exchange per: " + this.samplePeriod + " " + this.units.toString().toLowerCase(Locale.ENGLISH) + "]";
    }

    public long getMessageFrequency() {
        return this.messageFrequency;
    }

    public long getSamplePeriod() {
        return this.samplePeriod;
    }

    public TimeUnit getUnits() {
        return this.units;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        boolean doSend = false;
        Object object = this.calculationLock;
        synchronized (object) {
            if (this.messageFrequency > 0L) {
                ++this.currentMessageCount;
                if (this.currentMessageCount % this.messageFrequency == 0L) {
                    doSend = true;
                }
            } else {
                long now = System.currentTimeMillis();
                if (now >= this.timeOfLastExchange + this.periodInMillis) {
                    doSend = true;
                    if (LOG.isTraceEnabled()) {
                        LOG.trace(this.sampled.sample());
                    }
                    this.timeOfLastExchange = now;
                } else if (LOG.isTraceEnabled()) {
                    LOG.trace(this.sampled.drop());
                }
            }
        }
        if (doSend) {
            return this.processor.process(exchange, callback);
        }
        try {
            this.stopper.process(exchange);
        }
        catch (Exception e) {
            exchange.setException(e);
        }
        callback.done(true);
        return true;
    }

    private static class SampleStats {
        private long droppedThisPeriod;
        private long totalDropped;
        private long totalSampled;
        private long totalThisPeriod;

        private SampleStats() {
        }

        String drop() {
            ++this.droppedThisPeriod;
            ++this.totalThisPeriod;
            ++this.totalDropped;
            return this.getDroppedLog();
        }

        String sample() {
            this.totalThisPeriod = 1L;
            ++this.totalSampled;
            this.droppedThisPeriod = 0L;
            return this.getSampledLog();
        }

        String getSampledLog() {
            return String.format("Sampled %d of %d total exchanges", this.totalSampled, this.totalSampled + this.totalDropped);
        }

        String getDroppedLog() {
            return String.format("Dropped %d of %d exchanges in this period, totalling %d dropped of %d exchanges overall.", this.droppedThisPeriod, this.totalThisPeriod, this.totalDropped, this.totalSampled + this.totalDropped);
        }
    }
}

