/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.List;
import java.util.Map;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.camel.CamelContext;
import org.apache.camel.ServiceStatus;
import org.apache.camel.StatefulService;
import org.apache.camel.api.management.ManagedInstance;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.CamelOpenMBeanTypes;
import org.apache.camel.api.management.mbean.ManagedDataFormatMBean;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.util.JsonSchemaHelper;
import org.apache.camel.util.ObjectHelper;

@ManagedResource(description="Managed DataFormat")
public class ManagedDataFormat
implements ManagedInstance,
ManagedDataFormatMBean {
    private final CamelContext camelContext;
    private final DataFormat dataFormat;

    public ManagedDataFormat(CamelContext camelContext, DataFormat dataFormat) {
        this.camelContext = camelContext;
        this.dataFormat = dataFormat;
    }

    public void init(ManagementStrategy strategy) {
    }

    public DataFormat getDataFormat() {
        return this.dataFormat;
    }

    public CamelContext getContext() {
        return this.camelContext;
    }

    @Override
    public String getName() {
        if (this.dataFormat instanceof DataFormatName) {
            return ((DataFormatName)((Object)this.dataFormat)).getDataFormatName();
        }
        return null;
    }

    @Override
    public String getCamelId() {
        return this.camelContext.getName();
    }

    @Override
    public String getCamelManagementName() {
        return this.camelContext.getManagementName();
    }

    @Override
    public String getState() {
        if (this.dataFormat instanceof StatefulService) {
            ServiceStatus status = ((StatefulService)((Object)this.dataFormat)).getStatus();
            return status.name();
        }
        return ServiceStatus.Started.name();
    }

    @Override
    public String informationJson() {
        String dataFormatName = this.getName();
        if (dataFormatName != null) {
            return this.camelContext.explainDataFormatJson(dataFormatName, this.dataFormat, true);
        }
        return null;
    }

    @Override
    public TabularData explain(boolean allOptions) {
        String dataFormatName = this.getName();
        if (dataFormatName != null) {
            try {
                TabularDataSupport answer = new TabularDataSupport(CamelOpenMBeanTypes.explainDataFormatTabularType());
                String json = this.camelContext.explainDataFormatJson(dataFormatName, this.dataFormat, allOptions);
                List<Map<String, String>> rows = JsonSchemaHelper.parseJsonSchema("properties", json, true);
                for (Map<String, String> row : rows) {
                    String name = row.get("name");
                    String kind = row.get("kind");
                    String label = row.get("label") != null ? row.get("label") : "";
                    String type = row.get("type");
                    String javaType = row.get("javaType");
                    String deprecated = row.get("deprecated") != null ? row.get("deprecated") : "";
                    String secret = row.get("secret") != null ? row.get("secret") : "";
                    String value = row.get("value") != null ? row.get("value") : "";
                    String defaultValue = row.get("defaultValue") != null ? row.get("defaultValue") : "";
                    String description = row.get("description") != null ? row.get("description") : "";
                    CompositeType ct = CamelOpenMBeanTypes.explainDataFormatsCompositeType();
                    CompositeDataSupport data = new CompositeDataSupport(ct, new String[]{"option", "kind", "label", "type", "java type", "deprecated", "secret", "value", "default value", "description"}, new Object[]{name, kind, label, type, javaType, deprecated, secret, value, defaultValue, description});
                    answer.put(data);
                }
                return answer;
            }
            catch (Exception e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        }
        return null;
    }

    @Override
    public DataFormat getInstance() {
        return this.dataFormat;
    }
}

