/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.ComponentConfiguration;
import org.apache.camel.component.file.FileEndpoint;
import org.apache.camel.component.file.GenericFileComponent;
import org.apache.camel.component.file.GenericFileConfiguration;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.spi.EndpointCompleter;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;

public class FileComponent
extends GenericFileComponent<File>
implements EndpointCompleter {
    public static final String FILE_EXCHANGE_FILE = "CamelFileExchangeFile";
    public static final String DEFAULT_LOCK_FILE_POSTFIX = ".camelLock";

    public FileComponent() {
        this.setEndpointClass(FileEndpoint.class);
    }

    public FileComponent(CamelContext context) {
        super(context);
        this.setEndpointClass(FileEndpoint.class);
    }

    @Override
    protected GenericFileEndpoint<File> buildFileEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (StringHelper.hasStartToken(remaining, "simple")) {
            throw new IllegalArgumentException("Invalid directory: " + remaining + ". Dynamic expressions with ${ } placeholders is not allowed. Use the fileName option to set the dynamic expression.");
        }
        File file = new File(remaining);
        FileEndpoint result = new FileEndpoint(uri, this);
        result.setFile(file);
        GenericFileConfiguration config = new GenericFileConfiguration();
        config.setDirectory(FileUtil.isAbsolute(file) ? file.getAbsolutePath() : file.getPath());
        result.setConfiguration(config);
        return result;
    }

    @Override
    protected void afterPropertiesSet(GenericFileEndpoint<File> endpoint) throws Exception {
    }

    @Override
    public List<String> completeEndpointPath(ComponentConfiguration configuration, String completionText) {
        boolean empty = ObjectHelper.isEmpty(completionText);
        String pattern = completionText;
        File file = new File(completionText);
        String prefix = completionText;
        if (file.exists()) {
            pattern = "";
        } else {
            int idx;
            String startPath = ".";
            if (!empty && (idx = completionText.lastIndexOf(47)) >= 0) {
                startPath = completionText.substring(0, idx);
                if (startPath.length() == 0) {
                    startPath = "/";
                }
                pattern = completionText.substring(idx + 1);
            }
            file = new File(startPath);
            prefix = startPath;
        }
        if (prefix.length() > 0 && !prefix.endsWith("/")) {
            prefix = prefix + "/";
        }
        if (prefix.equals("./")) {
            prefix = "";
        }
        File[] list = file.listFiles();
        ArrayList<String> answer = new ArrayList<String>();
        for (File aFile : list) {
            String name = aFile.getName();
            if (pattern.length() != 0 && !name.contains(pattern) || !this.isValidEndpointCompletion(configuration, completionText, aFile)) continue;
            answer.add(prefix + name);
        }
        return answer;
    }

    protected boolean isValidEndpointCompletion(ComponentConfiguration configuration, String completionText, File file) {
        return !file.getName().startsWith(".");
    }
}

