/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.shell.services.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.unomi.shell.migration.MigrationService;
import org.apache.unomi.shell.services.UnomiManagementService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@Component(service={UnomiManagementService.class}, immediate=true)
public class UnomiManagementServiceImpl
implements UnomiManagementService {
    private BundleContext bundleContext;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    private MigrationService migrationService;
    private final List<String> bundleSymbolicNames = new ArrayList<String>();
    private List<String> reversedBundleSymbolicNames;

    @Activate
    public void init(ComponentContext componentContext) throws Exception {
        this.bundleContext = componentContext.getBundleContext();
        this.initReversedBundleSymbolicNames();
        if (StringUtils.isNotBlank((CharSequence)this.bundleContext.getProperty("unomi.autoMigrate"))) {
            this.migrationService.migrateUnomi(this.bundleContext.getProperty("unomi.autoMigrate"), true, null);
        }
        if (StringUtils.isNotBlank((CharSequence)this.bundleContext.getProperty("unomi.autoStart")) && this.bundleContext.getProperty("unomi.autoStart").equals("true")) {
            this.startUnomi();
        }
    }

    @Override
    public void startUnomi() throws BundleException {
        block0: for (String bundleSymbolicName : this.bundleSymbolicNames) {
            for (Bundle bundle : this.bundleContext.getBundles()) {
                if (!bundle.getSymbolicName().equals(bundleSymbolicName)) continue;
                if (bundle.getState() != 4) continue block0;
                bundle.start();
                continue block0;
            }
        }
    }

    @Override
    public void stopUnomi() throws BundleException {
        block0: for (String bundleSymbolicName : this.reversedBundleSymbolicNames) {
            for (Bundle bundle : this.bundleContext.getBundles()) {
                if (!bundle.getSymbolicName().equals(bundleSymbolicName)) continue;
                if (bundle.getState() != 32) continue block0;
                bundle.stop();
                continue block0;
            }
        }
    }

    public void initReversedBundleSymbolicNames() {
        this.bundleSymbolicNames.clear();
        this.bundleSymbolicNames.add("org.apache.unomi.lifecycle-watcher");
        this.bundleSymbolicNames.add("org.apache.unomi.api");
        this.bundleSymbolicNames.add("org.apache.unomi.common");
        this.bundleSymbolicNames.add("org.apache.unomi.scripting");
        this.bundleSymbolicNames.add("org.apache.unomi.metrics");
        this.bundleSymbolicNames.add("org.apache.unomi.persistence-spi");
        this.bundleSymbolicNames.add("org.apache.unomi.persistence-elasticsearch-core");
        this.bundleSymbolicNames.add("org.apache.unomi.services");
        this.bundleSymbolicNames.add("org.apache.unomi.cxs-lists-extension-services");
        this.bundleSymbolicNames.add("org.apache.unomi.cxs-lists-extension-rest");
        this.bundleSymbolicNames.add("org.apache.unomi.cxs-geonames-services");
        this.bundleSymbolicNames.add("org.apache.unomi.cxs-geonames-rest");
        this.bundleSymbolicNames.add("org.apache.unomi.cxs-privacy-extension-services");
        this.bundleSymbolicNames.add("org.apache.unomi.cxs-privacy-extension-rest");
        this.bundleSymbolicNames.add("org.apache.unomi.json-schema-services");
        this.bundleSymbolicNames.add("org.apache.unomi.json-schema-rest");
        this.bundleSymbolicNames.add("org.apache.unomi.rest");
        this.bundleSymbolicNames.add("org.apache.unomi.wab");
        this.bundleSymbolicNames.add("org.apache.unomi.plugins-base");
        this.bundleSymbolicNames.add("org.apache.unomi.plugins-request");
        this.bundleSymbolicNames.add("org.apache.unomi.plugins-mail");
        this.bundleSymbolicNames.add("org.apache.unomi.plugins-optimization-test");
        this.bundleSymbolicNames.add("org.apache.unomi.cxs-lists-extension-actions");
        this.bundleSymbolicNames.add("org.apache.unomi.router-api");
        this.bundleSymbolicNames.add("org.apache.unomi.router-core");
        this.bundleSymbolicNames.add("org.apache.unomi.router-service");
        this.bundleSymbolicNames.add("org.apache.unomi.router-rest");
        this.bundleSymbolicNames.add("org.apache.unomi.shell-dev-commands");
        this.bundleSymbolicNames.add("org.apache.unomi.web-tracker-wab");
        this.bundleSymbolicNames.add("org.apache.unomi.groovy-actions-services");
        this.bundleSymbolicNames.add("org.apache.unomi.groovy-actions-rest");
        if (this.reversedBundleSymbolicNames == null || this.reversedBundleSymbolicNames.isEmpty()) {
            this.reversedBundleSymbolicNames = new ArrayList<String>();
            this.reversedBundleSymbolicNames.addAll(this.bundleSymbolicNames);
            Collections.reverse(this.reversedBundleSymbolicNames);
        }
    }
}

