/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.function;

import java.math.MathContext;
import java.math.RoundingMode;
import org.javamoney.moneta.function.DefaultMonetaryRoundedFactory;
import org.javamoney.moneta.function.MonetaryRoundedFactory;
import org.javamoney.moneta.function.PrecisionContextRoundedOperator;
import org.javamoney.moneta.function.PrecisionScaleRoundedOperator;
import org.javamoney.moneta.function.ScaleRoundedOperator;

public final class MonetaryRoundedFactoryBuilder {
    private final RoundingMode roundingMode;

    MonetaryRoundedFactoryBuilder(RoundingMode roundingMode) {
        this.roundingMode = roundingMode;
    }

    public MonetaryRoundedFactoryWithScaleBuilder withScale(int scale) {
        return new MonetaryRoundedFactoryWithScaleBuilder(this.roundingMode, scale);
    }

    public MonetaryRoundedFactoryWithPrecisionBuilder withPrecision(int precision) {
        return new MonetaryRoundedFactoryWithPrecisionBuilder(this.roundingMode, precision);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(MonetaryRoundedFactoryBuilder.class.getName()).append('{').append("roundingMode: ").append((Object)this.roundingMode).append('}');
        return sb.toString();
    }

    public static class MonetaryRoundedFactoryWithPrecisionScaleBuilder {
        private int scale;
        private int precision;
        private final RoundingMode roundingMode;

        public MonetaryRoundedFactoryWithPrecisionScaleBuilder(RoundingMode roundingMode) {
            this.roundingMode = roundingMode;
        }

        public MonetaryRoundedFactory build() {
            MathContext mathContext = new MathContext(this.precision, this.roundingMode);
            return new DefaultMonetaryRoundedFactory(PrecisionScaleRoundedOperator.of(this.scale, mathContext));
        }
    }

    public static class MonetaryRoundedFactoryWithPrecisionBuilder {
        private final int precision;
        private final RoundingMode roundingMode;

        private MonetaryRoundedFactoryWithPrecisionBuilder(RoundingMode roundingMode, int precision) {
            this.roundingMode = roundingMode;
            this.precision = precision;
        }

        public MonetaryRoundedFactoryWithPrecisionScaleBuilder withScale(int scale) {
            MonetaryRoundedFactoryWithPrecisionScaleBuilder builder = new MonetaryRoundedFactoryWithPrecisionScaleBuilder(this.roundingMode);
            builder.precision = this.precision;
            builder.scale = scale;
            return builder;
        }

        public MonetaryRoundedFactory build() {
            MathContext mathContext = new MathContext(this.precision, this.roundingMode);
            return new DefaultMonetaryRoundedFactory(PrecisionContextRoundedOperator.of(mathContext));
        }
    }

    public static class MonetaryRoundedFactoryWithScaleBuilder {
        private final RoundingMode roundingMode;
        private final int scale;

        private MonetaryRoundedFactoryWithScaleBuilder(RoundingMode roundingMode, int scale) {
            this.roundingMode = roundingMode;
            this.scale = scale;
        }

        public MonetaryRoundedFactory build() {
            return new DefaultMonetaryRoundedFactory(ScaleRoundedOperator.of(this.scale, this.roundingMode));
        }

        public MonetaryRoundedFactoryWithPrecisionScaleBuilder withPrecision(int precision) {
            MonetaryRoundedFactoryWithPrecisionScaleBuilder builder = new MonetaryRoundedFactoryWithPrecisionScaleBuilder(this.roundingMode);
            builder.scale = this.scale;
            builder.precision = precision;
            return builder;
        }
    }
}

