/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.List;
import org.osgi.framework.InvalidSyntaxException;

public class SimpleFilter {
    public static final int MATCH_ALL = 0;
    public static final int AND = 1;
    public static final int OR = 2;
    public static final int NOT = 3;
    public static final int EQ = 4;
    public static final int LTE = 5;
    public static final int GTE = 6;
    public static final int SUBSTRING = 7;
    public static final int PRESENT = 8;
    public static final int APPROX = 9;
    private final String m_name;
    private final Object m_value;
    private final int m_op;
    private static final Class<?>[] STRING_CLASS = new Class[]{String.class};

    public SimpleFilter(String attr, Object value, int op) {
        this.m_name = attr;
        this.m_value = value;
        this.m_op = op;
    }

    public String getName() {
        return this.m_name;
    }

    public Object getValue() {
        return this.m_value;
    }

    public int getOperation() {
        return this.m_op;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    private void toString(StringBuilder sb) {
        switch (this.m_op) {
            case 1: {
                sb.append("(&");
                SimpleFilter.toString(sb, (List)this.m_value);
                sb.append(")");
                break;
            }
            case 2: {
                sb.append("(|");
                SimpleFilter.toString(sb, (List)this.m_value);
                sb.append(")");
                break;
            }
            case 3: {
                sb.append("(!");
                SimpleFilter.toString(sb, (List)this.m_value);
                sb.append(")");
                break;
            }
            case 4: {
                sb.append("(").append(this.m_name).append("=");
                SimpleFilter.toEncodedString(sb, this.m_value);
                sb.append(")");
                break;
            }
            case 5: {
                sb.append("(").append(this.m_name).append("<=");
                SimpleFilter.toEncodedString(sb, this.m_value);
                sb.append(")");
                break;
            }
            case 6: {
                sb.append("(").append(this.m_name).append(">=");
                SimpleFilter.toEncodedString(sb, this.m_value);
                sb.append(")");
                break;
            }
            case 7: {
                sb.append("(").append(this.m_name).append("=");
                SimpleFilter.unparseSubstring(sb, (List)this.m_value);
                sb.append(")");
                break;
            }
            case 8: {
                sb.append("(").append(this.m_name).append("=*)");
                break;
            }
            case 9: {
                sb.append("(").append(this.m_name).append("~=");
                SimpleFilter.toEncodedString(sb, this.m_value);
                sb.append(")");
                break;
            }
            case 0: {
                sb.append("(*)");
            }
        }
    }

    private static void toString(StringBuilder sb, List list) {
        for (Object o : list) {
            SimpleFilter sf = (SimpleFilter)o;
            sf.toString(sb);
        }
    }

    private static String toDecodedString(String s, int startIdx, int endIdx) {
        StringBuilder sb = new StringBuilder(endIdx - startIdx);
        boolean escaped = false;
        for (int i = 0; i < endIdx - startIdx; ++i) {
            char c = s.charAt(startIdx + i);
            if (!escaped && c == '\\') {
                escaped = true;
                continue;
            }
            escaped = false;
            sb.append(c);
        }
        return sb.toString();
    }

    private static void toEncodedString(StringBuilder sb, Object o) {
        if (o instanceof String) {
            String s = (String)o;
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == '\\' || c == '(' || c == ')' || c == '*') {
                    sb.append('\\');
                }
                sb.append(c);
            }
        } else {
            sb.append(o);
        }
    }

    public static SimpleFilter parse(String filter) throws InvalidSyntaxException {
        int idx = SimpleFilter.skipWhitespace(filter, 0);
        if (filter == null || filter.length() == 0 || idx >= filter.length()) {
            throw new InvalidSyntaxException("Null or empty filter.", filter);
        }
        if (filter.charAt(idx) != '(') {
            throw new InvalidSyntaxException("Missing opening parenthesis", filter);
        }
        SimpleFilter sf = null;
        ArrayList<Object> stack = new ArrayList<Object>();
        boolean isEscaped = false;
        while (idx < filter.length()) {
            if (sf != null) {
                throw new InvalidSyntaxException("Only one top-level operation allowed", filter);
            }
            if (!isEscaped && filter.charAt(idx) == '(') {
                if (filter.charAt(idx = SimpleFilter.skipWhitespace(filter, idx + 1)) == '&') {
                    int peek = SimpleFilter.skipWhitespace(filter, idx + 1);
                    if (filter.charAt(peek) == '(') {
                        idx = peek - 1;
                        stack.add(0, new SimpleFilter(null, new ArrayList(), 1));
                    } else {
                        stack.add(0, idx);
                    }
                } else if (filter.charAt(idx) == '|') {
                    int peek = SimpleFilter.skipWhitespace(filter, idx + 1);
                    if (filter.charAt(peek) == '(') {
                        idx = peek - 1;
                        stack.add(0, new SimpleFilter(null, new ArrayList(), 2));
                    } else {
                        stack.add(0, idx);
                    }
                } else if (filter.charAt(idx) == '!') {
                    int peek = SimpleFilter.skipWhitespace(filter, idx + 1);
                    if (filter.charAt(peek) == '(') {
                        idx = peek - 1;
                        stack.add(0, new SimpleFilter(null, new ArrayList(), 3));
                    } else {
                        stack.add(0, idx);
                    }
                } else {
                    stack.add(0, idx);
                }
            } else if (!isEscaped && filter.charAt(idx) == ')') {
                Object top = stack.remove(0);
                if (top instanceof SimpleFilter) {
                    if (!stack.isEmpty() && stack.get(0) instanceof SimpleFilter) {
                        ((List)((SimpleFilter)stack.get((int)0)).m_value).add(top);
                    } else {
                        sf = (SimpleFilter)top;
                    }
                } else if (!stack.isEmpty() && stack.get(0) instanceof SimpleFilter) {
                    ((List)((SimpleFilter)stack.get((int)0)).m_value).add(SimpleFilter.subfilter(filter, (Integer)top, idx));
                } else {
                    sf = SimpleFilter.subfilter(filter, (Integer)top, idx);
                }
            } else {
                isEscaped = !isEscaped && filter.charAt(idx) == '\\';
            }
            idx = SimpleFilter.skipWhitespace(filter, idx + 1);
        }
        if (sf == null) {
            throw new InvalidSyntaxException("Missing closing parenthesis", filter);
        }
        return sf;
    }

    private static SimpleFilter subfilter(String filter, int startIdx, int endIdx) throws InvalidSyntaxException {
        int op;
        char c;
        String opChars = "=<>~";
        int attrEndIdx = startIdx;
        for (int i = 0; i < endIdx - startIdx && "=<>~".indexOf(c = filter.charAt(startIdx + i)) < 0; ++i) {
            if (Character.isWhitespace(c)) continue;
            attrEndIdx = startIdx + i + 1;
        }
        if (attrEndIdx == startIdx) {
            throw new InvalidSyntaxException("Missing attribute name: " + filter.substring(startIdx, endIdx), filter);
        }
        String attr = filter.substring(startIdx, attrEndIdx);
        startIdx = SimpleFilter.skipWhitespace(filter, attrEndIdx);
        switch (filter.charAt(startIdx)) {
            case '=': {
                op = 4;
                ++startIdx;
                break;
            }
            case '<': {
                if (filter.charAt(startIdx + 1) != '=') {
                    throw new InvalidSyntaxException("Unknown operator: " + filter.substring(startIdx, endIdx), filter);
                }
                op = 5;
                startIdx += 2;
                break;
            }
            case '>': {
                if (filter.charAt(startIdx + 1) != '=') {
                    throw new InvalidSyntaxException("Unknown operator: " + filter.substring(startIdx, endIdx), filter);
                }
                op = 6;
                startIdx += 2;
                break;
            }
            case '~': {
                if (filter.charAt(startIdx + 1) != '=') {
                    throw new InvalidSyntaxException("Unknown operator: " + filter.substring(startIdx, endIdx), filter);
                }
                op = 9;
                startIdx += 2;
                break;
            }
            default: {
                throw new InvalidSyntaxException("Unknown operator: " + filter.substring(startIdx, endIdx), filter);
            }
        }
        Object value = SimpleFilter.toDecodedString(filter, startIdx, endIdx);
        if (op == 4) {
            String valueStr = filter.substring(startIdx, endIdx);
            List<String> values = SimpleFilter.parseSubstring(valueStr);
            if (values.size() == 2 && values.get(0).length() == 0 && values.get(1).length() == 0) {
                op = 8;
            } else if (values.size() > 1) {
                op = 7;
                value = values;
            }
        }
        return new SimpleFilter(attr, value, op);
    }

    public static List<String> parseSubstring(String value) {
        ArrayList<String> pieces = new ArrayList<String>();
        StringBuilder ss = new StringBuilder();
        boolean wasStar = false;
        boolean leftstar = false;
        boolean rightstar = false;
        int idx = 0;
        boolean escaped = false;
        while (true) {
            if (idx >= value.length()) {
                if (wasStar) {
                    rightstar = true;
                    break;
                }
                pieces.add(ss.toString());
                break;
            }
            char c = value.charAt(idx++);
            if (!escaped && c == '*') {
                if (wasStar) continue;
                if (ss.length() > 0) {
                    pieces.add(ss.toString());
                }
                ss.setLength(0);
                if (pieces.isEmpty()) {
                    leftstar = true;
                }
                wasStar = true;
                continue;
            }
            if (!escaped && c == '\\') {
                escaped = true;
                continue;
            }
            escaped = false;
            wasStar = false;
            ss.append(c);
        }
        ss.setLength(0);
        if (leftstar || rightstar || pieces.size() > 1) {
            if (rightstar) {
                pieces.add("");
            }
            if (leftstar) {
                pieces.add(0, "");
            }
        }
        return pieces;
    }

    public static void unparseSubstring(StringBuilder sb, List<String> pieces) {
        for (int i = 0; i < pieces.size(); ++i) {
            if (i > 0) {
                sb.append("*");
            }
            SimpleFilter.toEncodedString(sb, pieces.get(i));
        }
    }

    public static boolean compareSubstring(List<String> pieces, String s) {
        boolean result = true;
        int len = pieces.size();
        if (len == 1) {
            return s.equals(pieces.get(0));
        }
        int index = 0;
        for (int i = 0; i < len; ++i) {
            String piece = pieces.get(i);
            if (i == 0 && !s.startsWith(piece)) {
                result = false;
                break;
            }
            if (i == len - 1) {
                if (s.endsWith(piece) && s.length() >= index + piece.length()) {
                    result = true;
                    break;
                }
                result = false;
                break;
            }
            if (i > 0 && i < len - 1 && (index = s.indexOf(piece, index)) < 0) {
                result = false;
                break;
            }
            index += piece.length();
        }
        return result;
    }

    private static int skipWhitespace(String s, int startIdx) {
        int len = s.length();
        while (startIdx < len && Character.isWhitespace(s.charAt(startIdx))) {
            ++startIdx;
        }
        return startIdx;
    }

    public boolean matches(Dictionary dict) {
        boolean matched = true;
        if (this.getOperation() == 0) {
            matched = true;
        } else if (this.getOperation() == 1) {
            List sfs = (List)this.getValue();
            for (int i = 0; matched && i < sfs.size(); ++i) {
                matched = ((SimpleFilter)sfs.get(i)).matches(dict);
            }
        } else if (this.getOperation() == 2) {
            matched = false;
            List sfs = (List)this.getValue();
            for (int i = 0; !matched && i < sfs.size(); ++i) {
                matched = ((SimpleFilter)sfs.get(i)).matches(dict);
            }
        } else if (this.getOperation() == 3) {
            List sfs = (List)this.getValue();
            for (int i = 0; i < sfs.size(); ++i) {
                matched = !((SimpleFilter)sfs.get(i)).matches(dict);
            }
        } else {
            matched = false;
            Object lhs = dict.get(this.getName());
            if (lhs != null) {
                matched = SimpleFilter.compare(lhs, this.getValue(), this.getOperation());
            }
        }
        return matched;
    }

    private static boolean compare(Object lhs, Object rhsUnknown, int op) {
        if (lhs == null) {
            return false;
        }
        if (op == 8) {
            return true;
        }
        if (lhs instanceof Comparable) {
            Object rhs;
            if (op == 7 && !(lhs instanceof String)) {
                return false;
            }
            if (op == 7) {
                rhs = rhsUnknown;
            } else {
                try {
                    rhs = SimpleFilter.coerceType(lhs, (String)rhsUnknown);
                }
                catch (Exception ex) {
                    return false;
                }
            }
            switch (op) {
                case 4: {
                    try {
                        return ((Comparable)lhs).compareTo(rhs) == 0;
                    }
                    catch (Exception ex) {
                        return false;
                    }
                }
                case 6: {
                    try {
                        return ((Comparable)lhs).compareTo(rhs) >= 0;
                    }
                    catch (Exception ex) {
                        return false;
                    }
                }
                case 5: {
                    try {
                        return ((Comparable)lhs).compareTo(rhs) <= 0;
                    }
                    catch (Exception ex) {
                        return false;
                    }
                }
                case 9: {
                    return SimpleFilter.compareApproximate(lhs, rhs);
                }
                case 7: {
                    return SimpleFilter.compareSubstring((List)rhs, (String)lhs);
                }
            }
            throw new RuntimeException("Unknown comparison operator: " + op);
        }
        if (lhs instanceof Boolean) {
            Object rhs;
            try {
                rhs = SimpleFilter.coerceType(lhs, (String)rhsUnknown);
            }
            catch (Exception ex) {
                return false;
            }
            switch (op) {
                case 4: 
                case 5: 
                case 6: 
                case 9: {
                    return lhs.equals(rhs);
                }
            }
            throw new RuntimeException("Unknown comparison operator: " + op);
        }
        if (lhs.getClass().isArray()) {
            lhs = SimpleFilter.convertArrayToList(lhs);
        }
        if (lhs instanceof Collection) {
            Iterator iter = ((Collection)lhs).iterator();
            while (iter.hasNext()) {
                if (!SimpleFilter.compare(iter.next(), rhsUnknown, op)) continue;
                return true;
            }
            return false;
        }
        if (op == 7 && !(lhs instanceof String)) {
            return false;
        }
        try {
            return lhs.equals(SimpleFilter.coerceType(lhs, (String)rhsUnknown));
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static boolean compareApproximate(Object lhs, Object rhs) {
        if (rhs instanceof String) {
            return SimpleFilter.removeWhitespace((String)lhs).equalsIgnoreCase(SimpleFilter.removeWhitespace((String)rhs));
        }
        if (rhs instanceof Character) {
            return Character.toLowerCase(((Character)lhs).charValue()) == Character.toLowerCase(((Character)rhs).charValue());
        }
        return lhs.equals(rhs);
    }

    private static String removeWhitespace(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            sb.append(s.charAt(i));
        }
        return sb.toString();
    }

    private static Object coerceType(Object lhs, String rhsString) throws Exception {
        if (lhs.getClass() == rhsString.getClass()) {
            return rhsString;
        }
        Character rhs = null;
        try {
            if (lhs instanceof Character) {
                rhs = Character.valueOf(rhsString.charAt(0));
            } else {
                if (lhs instanceof Number || lhs instanceof Boolean) {
                    rhsString = rhsString.trim();
                }
                Constructor<?> ctor = lhs.getClass().getConstructor(STRING_CLASS);
                ctor.setAccessible(true);
                rhs = ctor.newInstance(rhsString);
            }
        }
        catch (Exception ex) {
            throw new Exception("Could not instantiate class " + lhs.getClass().getName() + " from string constructor with argument '" + rhsString + "' because " + ex);
        }
        return rhs;
    }

    private static List convertArrayToList(Object array) {
        int len = Array.getLength(array);
        ArrayList<Object> list = new ArrayList<Object>(len);
        for (int i = 0; i < len; ++i) {
            list.add(Array.get(array, i));
        }
        return list;
    }
}

