/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.http;

import aQute.bnd.http.HttpClient;
import aQute.bnd.service.url.TaggedData;
import aQute.lib.converter.TypeReference;
import aQute.service.reporter.Reporter;
import java.io.File;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.osgi.util.promise.Promise;

public class HttpRequest<T> {
    String verb = "GET";
    boolean isIdemPotent = true;
    Object upload;
    Type download;
    Map<String, String> headers = new HashMap<String, String>();
    long timeout = -1L;
    HttpClient client;
    String ifNoneMatch;
    long ifModifiedSince;
    long ifUnmodifiedSince;
    URL url;
    int redirects = 10;
    String ifMatch;
    boolean cached;
    long maxStale;
    Reporter reporter;
    File useCacheFile;
    boolean updateTag;
    int retries;
    long retryDelay;

    HttpRequest(HttpClient client) {
        this.client = client;
        this.retries = client.retries;
        this.retryDelay = client.retryDelay;
    }

    public <X> HttpRequest<X> get(Class<X> type) {
        this.download = type;
        return this;
    }

    public <X> HttpRequest<X> get(TypeReference<X> type) {
        this.download = type.getType();
        return this;
    }

    public HttpRequest<Object> get(Type type) {
        this.download = type;
        return this;
    }

    public HttpRequest<T> verb(String verb) {
        this.verb = verb;
        switch (verb.toUpperCase()) {
            case "GET": 
            case "HEAD": 
            case "PUT": 
            case "DELETE": 
            case "OPTIONS": 
            case "TRACE": {
                return this.idemPotent(true);
            }
        }
        return this.idemPotent(false);
    }

    public HttpRequest<T> put() {
        return this.verb("PUT");
    }

    public HttpRequest<T> head() {
        return this.verb("HEAD");
    }

    public HttpRequest<T> get() {
        return this.verb("GET");
    }

    public HttpRequest<T> post() {
        return this.verb("POST");
    }

    public HttpRequest<T> option() {
        return this.verb("OPTIONS");
    }

    public HttpRequest<T> trace() {
        return this.verb("TRACE");
    }

    public HttpRequest<T> delete() {
        return this.verb("DELETE");
    }

    public HttpRequest<T> upload(Object upload) {
        this.upload = upload;
        return this;
    }

    public HttpRequest<T> headers(Map<String, String> map) {
        this.headers.putAll(map);
        return this;
    }

    public HttpRequest<T> headers(String key, String value) {
        this.headers.put(key, value);
        return this;
    }

    public HttpRequest<T> timeout(long timeoutInMs) {
        this.timeout = timeoutInMs;
        return this;
    }

    public HttpRequest<T> ifNoneMatch(String etag) {
        this.ifNoneMatch = etag;
        return this;
    }

    public HttpRequest<T> ifModifiedSince(long epochTime) {
        this.ifModifiedSince = epochTime;
        return this;
    }

    public HttpRequest<T> maxRedirects(int n) {
        this.redirects = n;
        return this;
    }

    public T go(URL url) throws Exception {
        this.url = url;
        return this.client.send(this);
    }

    public T go(URI url) throws Exception {
        return this.go(url.toURL());
    }

    public HttpRequest<T> age(int n, TimeUnit tu) {
        this.headers.put("Age", "" + tu.toSeconds(n));
        return this;
    }

    public Promise<T> async(URL url) {
        this.url = url;
        return this.client.sendAsync(this);
    }

    public Promise<T> async(URI uri) {
        try {
            return this.async(uri.toURL());
        }
        catch (MalformedURLException e) {
            return this.client.promiseFactory().failed((Throwable)e);
        }
    }

    public String toString() {
        return "HttpRequest [verb=" + this.verb + ", upload=" + this.upload + ", download=" + this.download + ", headers=" + this.headers + ", timeout=" + this.timeout + ", client=" + this.client + ", url=" + this.url + "]";
    }

    public HttpRequest<T> ifUnmodifiedSince(long ifNotModifiedSince) {
        this.ifUnmodifiedSince = ifNotModifiedSince;
        return this;
    }

    public HttpRequest<T> ifMatch(String etag) {
        this.ifMatch = etag;
        return this;
    }

    public HttpRequest<TaggedData> asTag() {
        return this.get(TaggedData.class);
    }

    public HttpRequest<String> asString() {
        return this.get(String.class);
    }

    public boolean isCache() {
        return "GET".equalsIgnoreCase(this.verb) && this.cached || this.download == File.class;
    }

    public HttpRequest<File> useCache(long maxStale) {
        this.maxStale = maxStale;
        this.cached = true;
        return this.get(File.class);
    }

    public HttpRequest<File> useCache() {
        return this.useCache(-1L);
    }

    public HttpRequest<File> useCache(File file) {
        this.useCacheFile = file;
        return this.useCache(-1L);
    }

    public HttpRequest<File> useCache(File file, long maxStale) {
        this.useCacheFile = file;
        return this.useCache(maxStale);
    }

    public HttpRequest<T> report(Reporter reporter) {
        this.reporter = reporter;
        return this;
    }

    public HttpRequest<T> timeout(long timeout, TimeUnit unit) {
        this.timeout = unit.toMillis(timeout);
        return this;
    }

    public boolean isTagResult() {
        return this.download == null || this.download == TaggedData.class;
    }

    public HttpRequest<T> updateTag() {
        this.updateTag = true;
        return this;
    }

    public HttpRequest<T> retries(int retries) {
        this.retries = retries;
        return this;
    }

    public HttpRequest<T> retryDelay(int retryDelay) {
        this.retryDelay = TimeUnit.SECONDS.toMillis(retryDelay);
        return this;
    }

    public HttpRequest<T> idemPotent(boolean isIdemPotent) {
        this.isIdemPotent = isIdemPotent;
        return this;
    }
}

