/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.proxy.impl.interfaces;

import java.security.AllPermission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.aries.proxy.InvocationListener;
import org.apache.aries.proxy.UnableToProxyException;
import org.apache.aries.proxy.impl.common.AbstractWovenProxyAdapter;
import org.apache.aries.proxy.impl.interfaces.InterfaceCombiningClassAdapter;
import org.apache.aries.proxy.weaving.WovenProxy;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;

final class ProxyClassLoader
extends ClassLoader {
    private static final ProtectionDomain PROXY_PROTECTION_DOMAIN;
    private final ConcurrentMap<LinkedHashSet<Class<?>>, String> classes = new ConcurrentHashMap();
    private final ConcurrentMap<String, Class<?>> locatedClasses = new ConcurrentHashMap();
    private final Set<Class<?>> ifaces = new HashSet();
    private final ReadWriteLock ifacesLock = new ReentrantReadWriteLock();

    public ProxyClassLoader(Bundle bundle) {
        super(ProxyClassLoader.getClassloader(bundle));
    }

    private static ClassLoader getClassloader(Bundle bundle) {
        if (bundle == null) {
            return ProxyClassLoader.class.getClassLoader();
        }
        BundleWiring wiring = bundle != null ? (BundleWiring)bundle.adapt(BundleWiring.class) : null;
        return wiring != null ? wiring.getClassLoader() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Class<?> findClass(String className) {
        if (WovenProxy.class.getName().equals(className)) {
            return WovenProxy.class;
        }
        if (InvocationListener.class.getName().equals(className)) {
            return InvocationListener.class;
        }
        Class<?> c = (Class<?>)this.locatedClasses.get(className);
        if (c != null) {
            return c;
        }
        Lock rLock = this.ifacesLock.readLock();
        rLock.lock();
        try {
            HashSet<ClassLoader> cls = new HashSet<ClassLoader>();
            for (Class<?> iface : this.ifaces) {
                if (!cls.add(iface.getClassLoader())) continue;
                try {
                    c = Class.forName(className, false, iface.getClassLoader());
                    this.locatedClasses.put(className, c);
                    Class<?> clazz = c;
                    return clazz;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    try {
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                        return null;
                    }
                }
            }
        }
        finally {
            rLock.unlock();
        }
    }

    public boolean isInvalid(Set<Class<?>> createSet) {
        for (Class<?> iface : createSet) {
            try {
                Class<?> newIFace = Class.forName(iface.getName(), false, this);
                if (newIFace.equals(iface)) continue;
                return true;
            }
            catch (ClassNotFoundException cnfe) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> createProxyClass(Class<?> superclass, SortedSet<Class<?>> interfaces) throws UnableToProxyException {
        LinkedHashSet createSet = new LinkedHashSet(interfaces);
        createSet.add(superclass);
        String className = (String)this.classes.get(createSet);
        if (className != null) {
            try {
                return Class.forName(className, false, this);
            }
            catch (ClassNotFoundException cnfe) {
                this.classes.remove(createSet);
            }
        }
        Lock wLock = this.ifacesLock.writeLock();
        wLock.lock();
        try {
            this.ifaces.addAll(interfaces);
            if (superclass != null) {
                this.ifaces.add(superclass);
            }
        }
        finally {
            wLock.unlock();
        }
        className = "Proxy" + AbstractWovenProxyAdapter.getSanitizedUUIDString();
        InterfaceCombiningClassAdapter icca = new InterfaceCombiningClassAdapter(className, this, superclass, interfaces);
        try {
            byte[] bytes = icca.generateBytes();
            Class<?> c = this.defineClass(className, bytes, 0, bytes.length, PROXY_PROTECTION_DOMAIN);
            String old = this.classes.putIfAbsent(createSet, className);
            if (old != null) {
                c = Class.forName(className, false, this);
            }
            return c;
        }
        catch (ClassFormatError cfe) {
            throw new UnableToProxyException((Class)createSet.iterator().next(), (Throwable)cfe);
        }
        catch (ClassNotFoundException e) {
            throw new UnableToProxyException((Class)createSet.iterator().next(), (Throwable)e);
        }
    }

    static {
        Permissions pc = new Permissions();
        ((PermissionCollection)pc).add(new AllPermission());
        PROXY_PROTECTION_DOMAIN = new ProtectionDomain(null, pc);
    }
}

