/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.NamedAnalyzer;

public final class IndexAnalyzers
implements Closeable {
    private final Map<String, NamedAnalyzer> analyzers;
    private final Map<String, NamedAnalyzer> normalizers;
    private final Map<String, NamedAnalyzer> whitespaceNormalizers;

    public IndexAnalyzers(Map<String, NamedAnalyzer> analyzers, Map<String, NamedAnalyzer> normalizers, Map<String, NamedAnalyzer> whitespaceNormalizers) {
        Objects.requireNonNull(analyzers.get("default"), "the default analyzer must be set");
        if (!analyzers.get("default").name().equals("default")) {
            throw new IllegalStateException("default analyzer must have the name [default] but was: [" + analyzers.get("default").name() + "]");
        }
        this.analyzers = Collections.unmodifiableMap(analyzers);
        this.normalizers = Collections.unmodifiableMap(normalizers);
        this.whitespaceNormalizers = Collections.unmodifiableMap(whitespaceNormalizers);
    }

    public NamedAnalyzer get(String name) {
        return this.analyzers.get(name);
    }

    public Map<String, NamedAnalyzer> getAnalyzers() {
        return this.analyzers;
    }

    public NamedAnalyzer getNormalizer(String name) {
        return this.normalizers.get(name);
    }

    public NamedAnalyzer getWhitespaceNormalizer(String name) {
        return this.whitespaceNormalizers.get(name);
    }

    public NamedAnalyzer getDefaultIndexAnalyzer() {
        return this.analyzers.get("default");
    }

    public NamedAnalyzer getDefaultSearchAnalyzer() {
        return this.analyzers.getOrDefault("default_search", this.getDefaultIndexAnalyzer());
    }

    public NamedAnalyzer getDefaultSearchQuoteAnalyzer() {
        return this.analyzers.getOrDefault("default_search_quoted", this.getDefaultSearchAnalyzer());
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(Stream.of(this.analyzers.values().stream(), this.normalizers.values().stream(), this.whitespaceNormalizers.values().stream()).flatMap(s -> s).filter(a -> a.scope() == AnalyzerScope.INDEX).collect(Collectors.toList()));
    }
}

