/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.status;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotStatus;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class SnapshotsStatusResponse
extends ActionResponse
implements ToXContentObject {
    private List<SnapshotStatus> snapshots = Collections.emptyList();
    private static final ConstructingObjectParser<SnapshotsStatusResponse, Void> PARSER = new ConstructingObjectParser("snapshots_status_response", true, parsedObjects -> {
        List snapshots = (List)parsedObjects[0];
        return new SnapshotsStatusResponse(snapshots);
    });

    public SnapshotsStatusResponse(StreamInput in) throws IOException {
        super(in);
        int size = in.readVInt();
        ArrayList<SnapshotStatus> builder = new ArrayList<SnapshotStatus>();
        for (int i = 0; i < size; ++i) {
            builder.add(new SnapshotStatus(in));
        }
        this.snapshots = Collections.unmodifiableList(builder);
    }

    SnapshotsStatusResponse(List<SnapshotStatus> snapshots) {
        this.snapshots = snapshots;
    }

    public List<SnapshotStatus> getSnapshots() {
        return this.snapshots;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.snapshots.size());
        for (SnapshotStatus snapshotInfo : this.snapshots) {
            snapshotInfo.writeTo(out);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray("snapshots");
        for (SnapshotStatus snapshot : this.snapshots) {
            snapshot.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static SnapshotsStatusResponse fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotsStatusResponse response = (SnapshotsStatusResponse)o;
        return this.snapshots != null ? this.snapshots.equals(response.snapshots) : response.snapshots == null;
    }

    public int hashCode() {
        return this.snapshots != null ? this.snapshots.hashCode() : 0;
    }

    static {
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), SnapshotStatus.PARSER, new ParseField("snapshots", new String[0]));
    }
}

