/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.core.shell.completer;

import java.util.List;
import org.apache.karaf.cellar.core.ClusterManager;
import org.apache.karaf.cellar.core.Node;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.console.CommandLine;
import org.apache.karaf.shell.api.console.Completer;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.support.completers.StringsCompleter;

public abstract class NodeCompleterSupport
implements Completer {
    @Reference
    private ClusterManager clusterManager;

    public int complete(Session session, CommandLine commandLine, List<String> candidates) {
        StringsCompleter delegate = new StringsCompleter();
        try {
            for (Node node : this.clusterManager.listNodes()) {
                if (!this.acceptsNode(node)) continue;
                if (this.addId()) {
                    String id = node.getId();
                    if (delegate.getStrings() != null && !delegate.getStrings().contains(id)) {
                        delegate.getStrings().add(id);
                    }
                }
                if (!this.addAlias()) continue;
                String alias = node.getAlias();
                if (delegate.getStrings() == null || delegate.getStrings().contains(alias)) continue;
                delegate.getStrings().add(alias);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return delegate.complete(session, commandLine, candidates);
    }

    protected abstract boolean acceptsNode(Node var1);

    protected abstract boolean addId();

    protected abstract boolean addAlias();

    public ClusterManager getClusterManager() {
        return this.clusterManager;
    }

    public void setClusterManager(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }
}

