/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.hex;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.Formatter;
import java.util.Objects;
import java.util.regex.Pattern;

public class Hex {
    private static final Pattern HEX_P = Pattern.compile("(?:\\p{XDigit}{2})+");
    static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static final byte[] toByteArray(String string) {
        Objects.requireNonNull(string, "The hex string must not be null.");
        string = string.trim();
        if ((string.length() & 1) != 0) {
            throw new IllegalArgumentException("a hex string must have an even length");
        }
        byte[] out = new byte[string.length() / 2];
        for (int i = 0; i < out.length; ++i) {
            int high = Hex.nibble(string.charAt(i * 2)) << 4;
            int low = Hex.nibble(string.charAt(i * 2 + 1));
            out[i] = (byte)(high + low);
        }
        return out;
    }

    public static String toHex(byte b) {
        char low = HEX[b & 0xF];
        char high = HEX[(b & 0xF0) >> 4];
        return new String(new char[]{high, low});
    }

    public static final int nibble(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        throw new IllegalArgumentException("Not a hex digit: " + c);
    }

    public static final String toHexString(byte[] data) {
        StringBuilder sb = new StringBuilder();
        try {
            Hex.append((Appendable)sb, data);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    public static final void append(Appendable sb, byte[] data) throws IOException {
        for (int i = 0; i < data.length; ++i) {
            sb.append(Hex.nibble(data[i] >> 4));
            sb.append(Hex.nibble(data[i]));
        }
    }

    public static final char nibble(int i) {
        return HEX[i & 0xF];
    }

    public static boolean isHex(String pub) {
        return HEX_P.matcher(pub).matches();
    }

    public static boolean isHexCharacter(char c) {
        if (c < '0') {
            return false;
        }
        if (c <= '9') {
            return true;
        }
        if (c < 'A') {
            return false;
        }
        if (c <= 'F') {
            return true;
        }
        if (c < 'a') {
            return false;
        }
        return c <= 'f';
    }

    public static String separated(byte[] bytes, String separator) {
        return Hex.separated(bytes, 0, bytes.length, separator);
    }

    public static String separated(byte[] bytes, int start, int length, String separator) {
        assert (start >= 0);
        assert (length + start <= bytes.length);
        String del = "";
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            byte x = bytes[i + start];
            sb.append(del);
            sb.append(Hex.toHex(x));
            del = separator;
        }
        return sb.toString();
    }

    public static String format(byte[] data) {
        if (data == null) {
            return "";
        }
        try (Formatter f = new Formatter();){
            StringBuilder ascii = new StringBuilder(30);
            StringBuilder hex = new StringBuilder(30);
            for (int rover = 0; rover < data.length; rover += 16) {
                ascii.setLength(0);
                hex.setLength(0);
                int p = rover;
                for (int g = 0; g < 2 && p < data.length; ++g) {
                    hex.append(' ');
                    ascii.append("  ");
                    for (int i = 0; i < 8 && p < data.length; ++i) {
                        int c = data[p++];
                        hex.append(' ');
                        hex.append(Hex.toHex((byte)c));
                        if (c < 32 || c > 126) {
                            c = 46;
                        }
                        ascii.append((char)c);
                    }
                }
                f.format("0x%04x%-50s%s%n", rover, hex, ascii);
            }
            String string = f.toString();
            return string;
        }
    }

    public static String format(ByteBuffer data) {
        if (data == null) {
            return "";
        }
        ByteBuffer bb = data.duplicate();
        try (Formatter f = new Formatter();){
            StringBuilder ascii = new StringBuilder(30);
            StringBuilder hex = new StringBuilder(30);
            int rover = 0;
            while (bb.hasRemaining()) {
                ascii.setLength(0);
                hex.setLength(0);
                for (int g = 0; g < 2 && bb.hasRemaining(); ++g) {
                    hex.append(' ');
                    ascii.append("  ");
                    for (int i = 0; i < 8 && bb.hasRemaining(); ++i) {
                        int c = bb.get();
                        hex.append(' ');
                        hex.append(Hex.toHex((byte)c));
                        if (c < 32 || c > 126) {
                            c = 46;
                        }
                        ascii.append((char)c);
                    }
                }
                f.format("0x%04x%-50s%s%n", rover, hex, ascii);
                rover += 16;
            }
            String string = f.toString();
            return string;
        }
    }

    public static boolean isBinary(byte[] data) {
        for (int i = 0; i < data.length; ++i) {
            if (data[i] != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isBinary(ByteBuffer data) {
        ByteBuffer bb = data.duplicate();
        while (bb.hasRemaining()) {
            if (bb.get() != 0) continue;
            return true;
        }
        return false;
    }

    public static void append(Appendable sb, byte ch) {
        try {
            sb.append(Hex.nibble(ch >>> 4));
            sb.append(Hex.nibble(ch >>> 0));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void append(Appendable sb, short ch) {
        Hex.append(sb, (byte)(0xFF & ch >>> 8));
        Hex.append(sb, (byte)(0xFF & ch >>> 0));
    }

    public static void append(Appendable sb, char ch) {
        Hex.append(sb, (short)ch);
    }

    public static void append(Appendable sb, int ch) {
        Hex.append(sb, (short)(0xFFFF & ch >>> 16));
        Hex.append(sb, (short)(0xFFFF & ch >>> 0));
    }

    public static void append(Appendable sb, long ch) {
        Hex.append(sb, (int)(0xFFFFFFFFFFFFFFFFL & ch >>> 32));
        Hex.append(sb, (int)(0xFFFFFFFFFFFFFFFFL & ch >>> 0));
    }
}

