/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.ProtoUtils;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequestResponse;

public class ListGroupsResponse
extends AbstractRequestResponse {
    private static final Schema CURRENT_SCHEMA = ProtoUtils.currentResponseSchema(ApiKeys.LIST_GROUPS.id);
    public static final String ERROR_CODE_KEY_NAME = "error_code";
    public static final String GROUPS_KEY_NAME = "groups";
    public static final String GROUP_ID_KEY_NAME = "group_id";
    public static final String PROTOCOL_TYPE_KEY_NAME = "protocol_type";
    private final short errorCode;
    private final List<Group> groups;

    public ListGroupsResponse(short errorCode, List<Group> groups) {
        super(new Struct(CURRENT_SCHEMA));
        this.struct.set(ERROR_CODE_KEY_NAME, (Object)errorCode);
        ArrayList<Struct> groupList = new ArrayList<Struct>();
        for (Group group : groups) {
            Struct groupStruct = this.struct.instance(GROUPS_KEY_NAME);
            groupStruct.set(GROUP_ID_KEY_NAME, (Object)group.groupId);
            groupStruct.set(PROTOCOL_TYPE_KEY_NAME, (Object)group.protocolType);
            groupList.add(groupStruct);
        }
        this.struct.set(GROUPS_KEY_NAME, (Object)groupList.toArray());
        this.errorCode = errorCode;
        this.groups = groups;
    }

    public ListGroupsResponse(Struct struct) {
        super(struct);
        this.errorCode = struct.getShort(ERROR_CODE_KEY_NAME);
        this.groups = new ArrayList<Group>();
        for (Object groupObj : struct.getArray(GROUPS_KEY_NAME)) {
            Struct groupStruct = (Struct)groupObj;
            String groupId = groupStruct.getString(GROUP_ID_KEY_NAME);
            String protocolType = groupStruct.getString(PROTOCOL_TYPE_KEY_NAME);
            this.groups.add(new Group(groupId, protocolType));
        }
    }

    public List<Group> groups() {
        return this.groups;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public static ListGroupsResponse parse(ByteBuffer buffer) {
        return new ListGroupsResponse(CURRENT_SCHEMA.read(buffer));
    }

    public static ListGroupsResponse fromError(Errors error) {
        return new ListGroupsResponse(error.code(), Collections.emptyList());
    }

    public static class Group {
        private final String groupId;
        private final String protocolType;

        public Group(String groupId, String protocolType) {
            this.groupId = groupId;
            this.protocolType = protocolType;
        }

        public String groupId() {
            return this.groupId;
        }

        public String protocolType() {
            return this.protocolType;
        }
    }
}

