/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.apache.sshd.common.config.keys.IdentityResourceLoader;
import org.apache.sshd.common.util.io.IoUtils;

public interface KeyEntryResolver<PUB extends PublicKey, PRV extends PrivateKey>
extends IdentityResourceLoader<PUB, PRV> {
    default public KeyPair generateKeyPair(int keySize) throws GeneralSecurityException {
        KeyPairGenerator gen = this.getKeyPairGenerator();
        gen.initialize(keySize);
        return gen.generateKeyPair();
    }

    default public KeyPair cloneKeyPair(KeyPair kp) throws GeneralSecurityException {
        if (kp == null) {
            return null;
        }
        PublicKey pubCloned = null;
        PublicKey pubOriginal = kp.getPublic();
        Class pubExpected = this.getPublicKeyType();
        if (pubOriginal != null) {
            Class<?> orgType = pubOriginal.getClass();
            if (!pubExpected.isAssignableFrom(orgType)) {
                throw new InvalidKeyException("Mismatched public key types: expected=" + pubExpected.getSimpleName() + ", actual=" + orgType.getSimpleName());
            }
            pubCloned = this.clonePublicKey((PublicKey)pubExpected.cast(pubOriginal));
        }
        PrivateKey prvCloned = null;
        PrivateKey prvOriginal = kp.getPrivate();
        Class prvExpected = this.getPrivateKeyType();
        if (prvOriginal != null) {
            Class<?> orgType = prvOriginal.getClass();
            if (!prvExpected.isAssignableFrom(orgType)) {
                throw new InvalidKeyException("Mismatched private key types: expected=" + prvExpected.getSimpleName() + ", actual=" + orgType.getSimpleName());
            }
            prvCloned = this.clonePrivateKey((PrivateKey)prvExpected.cast(prvOriginal));
        }
        return new KeyPair(pubCloned, prvCloned);
    }

    public PUB clonePublicKey(PUB var1) throws GeneralSecurityException;

    public PRV clonePrivateKey(PRV var1) throws GeneralSecurityException;

    public KeyPairGenerator getKeyPairGenerator() throws GeneralSecurityException;

    public KeyFactory getKeyFactoryInstance() throws GeneralSecurityException;

    public static int encodeString(OutputStream s, String v) throws IOException {
        return KeyEntryResolver.encodeString(s, v, StandardCharsets.UTF_8);
    }

    public static int encodeString(OutputStream s, String v, String charset) throws IOException {
        return KeyEntryResolver.encodeString(s, v, Charset.forName(charset));
    }

    public static int encodeString(OutputStream s, String v, Charset cs) throws IOException {
        return KeyEntryResolver.writeRLEBytes(s, v.getBytes(cs));
    }

    public static int encodeBigInt(OutputStream s, BigInteger v) throws IOException {
        return KeyEntryResolver.writeRLEBytes(s, v.toByteArray());
    }

    public static int writeRLEBytes(OutputStream s, byte ... bytes) throws IOException {
        return KeyEntryResolver.writeRLEBytes(s, bytes, 0, bytes.length);
    }

    public static int writeRLEBytes(OutputStream s, byte[] bytes, int off, int len) throws IOException {
        byte[] lenBytes = KeyEntryResolver.encodeInt(s, len);
        s.write(bytes, off, len);
        return lenBytes.length + len;
    }

    public static byte[] encodeInt(OutputStream s, int v) throws IOException {
        byte[] bytes = new byte[]{(byte)(v >> 24 & 0xFF), (byte)(v >> 16 & 0xFF), (byte)(v >> 8 & 0xFF), (byte)(v & 0xFF)};
        s.write(bytes);
        return bytes;
    }

    public static String decodeString(InputStream s) throws IOException {
        return KeyEntryResolver.decodeString(s, StandardCharsets.UTF_8);
    }

    public static String decodeString(InputStream s, String charset) throws IOException {
        return KeyEntryResolver.decodeString(s, Charset.forName(charset));
    }

    public static String decodeString(InputStream s, Charset cs) throws IOException {
        byte[] bytes = KeyEntryResolver.readRLEBytes(s);
        return new String(bytes, cs);
    }

    public static BigInteger decodeBigInt(InputStream s) throws IOException {
        return new BigInteger(KeyEntryResolver.readRLEBytes(s));
    }

    public static byte[] readRLEBytes(InputStream s) throws IOException {
        int len = KeyEntryResolver.decodeInt(s);
        byte[] bytes = new byte[len];
        IoUtils.readFully(s, bytes);
        return bytes;
    }

    public static int decodeInt(InputStream s) throws IOException {
        byte[] bytes = new byte[]{0, 0, 0, 0};
        IoUtils.readFully(s, bytes);
        return (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
    }
}

