/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.RollbackExchangeException;
import org.apache.camel.Traceable;
import org.apache.camel.spi.IdAware;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.AsyncProcessorHelper;

public class RollbackProcessor
extends ServiceSupport
implements AsyncProcessor,
Traceable,
IdAware {
    private String id;
    private boolean markRollbackOnly;
    private boolean markRollbackOnlyLast;
    private String message;

    public RollbackProcessor() {
    }

    public RollbackProcessor(String message) {
        this.message = message;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (this.isMarkRollbackOnlyLast()) {
            exchange.setProperty("CamelRollbackOnlyLast", Boolean.TRUE);
        } else {
            exchange.setProperty("CamelRollbackOnly", Boolean.TRUE);
        }
        if (this.markRollbackOnly || this.markRollbackOnlyLast) {
            callback.done(true);
            return true;
        }
        if (this.message != null) {
            exchange.setException(new RollbackExchangeException(this.message, exchange));
        } else {
            exchange.setException(new RollbackExchangeException(exchange));
        }
        callback.done(true);
        return true;
    }

    public String toString() {
        if (this.message != null) {
            return "Rollback[" + this.message + "]";
        }
        return "Rollback";
    }

    @Override
    public String getTraceLabel() {
        return "rollback";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isMarkRollbackOnly() {
        return this.markRollbackOnly;
    }

    public void setMarkRollbackOnly(boolean markRollbackOnly) {
        this.markRollbackOnly = markRollbackOnly;
    }

    public boolean isMarkRollbackOnlyLast() {
        return this.markRollbackOnlyLast;
    }

    public void setMarkRollbackOnlyLast(boolean markRollbackOnlyLast) {
        this.markRollbackOnlyLast = markRollbackOnlyLast;
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
    }
}

