/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.jetty.internal;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.ops4j.pax.web.service.jetty.internal.JettyFactoryImpl;
import org.ops4j.pax.web.service.jetty.internal.ServerControllerImpl;
import org.ops4j.pax.web.service.spi.ServerController;
import org.ops4j.pax.web.service.spi.ServerControllerFactory;
import org.ops4j.pax.web.service.spi.model.ServerModel;
import org.osgi.framework.Bundle;

class ServerControllerFactoryImpl
implements ServerControllerFactory {
    private Bundle bundle;
    private Map<Handler, Integer> handlers = new ServiceMap<Handler>();
    private Map<Connector, Integer> connectors = new ServiceMap<Connector>();
    private Map<HttpConfiguration.Customizer, Integer> customizers = new ServiceMap<HttpConfiguration.Customizer>();
    private List<ServerControllerImpl> serverControllers = new LinkedList<ServerControllerImpl>();
    private Comparator<?> priorityComparator;

    public ServerControllerFactoryImpl(Bundle bundle, Comparator<?> priorityComparator) {
        this.bundle = bundle;
        this.priorityComparator = priorityComparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHandler(Handler handler, int ranking) {
        List<ServerControllerImpl> list = this.serverControllers;
        synchronized (list) {
            for (ServerControllerImpl serverController : this.serverControllers) {
                serverController.jettyServer.addHandler(handler);
            }
            this.handlers.put(handler, ranking);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHandler(Handler handler) {
        List<ServerControllerImpl> list = this.serverControllers;
        synchronized (list) {
            this.handlers.remove(handler);
            for (ServerControllerImpl serverController : this.serverControllers) {
                serverController.jettyServer.removeHandler(handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnector(Connector connector, int ranking) {
        List<ServerControllerImpl> list = this.serverControllers;
        synchronized (list) {
            for (ServerControllerImpl serverController : this.serverControllers) {
                serverController.jettyServer.addConnector(connector);
            }
            this.connectors.put(connector, ranking);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnector(Connector connector) {
        List<ServerControllerImpl> list = this.serverControllers;
        synchronized (list) {
            this.connectors.remove(connector);
            for (ServerControllerImpl serverController : this.serverControllers) {
                serverController.jettyServer.removeConnector(connector);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCustomizer(HttpConfiguration.Customizer customizer, int ranking) {
        List<ServerControllerImpl> list = this.serverControllers;
        synchronized (list) {
            List<HttpConfiguration.Customizer> customizers = Collections.singletonList(customizer);
            for (ServerControllerImpl serverController : this.serverControllers) {
                serverController.addCustomizers(customizers);
            }
            this.customizers.put(customizer, ranking);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCustomizer(HttpConfiguration.Customizer customizer) {
        List<ServerControllerImpl> list = this.serverControllers;
        synchronized (list) {
            this.customizers.remove(customizer);
            List<HttpConfiguration.Customizer> customizers = Collections.singletonList(customizer);
            for (ServerControllerImpl serverController : this.serverControllers) {
                serverController.removeCustomizers(customizers);
            }
        }
    }

    public ServerController createServerController(ServerModel serverModel) {
        return new ServerControllerImpl(new JettyFactoryImpl(serverModel, this.bundle, this.priorityComparator), this.priorityComparator){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized void start() {
                List list = ServerControllerFactoryImpl.this.serverControllers;
                synchronized (list) {
                    for (Connector connector : ServerControllerFactoryImpl.this.connectors.keySet()) {
                        this.jettyServer.addConnector(connector);
                    }
                    super.start();
                    if (!ServerControllerFactoryImpl.this.customizers.isEmpty()) {
                        this.addCustomizers(ServerControllerFactoryImpl.this.customizers.keySet());
                    }
                    for (Handler handler : ServerControllerFactoryImpl.this.handlers.keySet()) {
                        this.jettyServer.addHandler(handler);
                    }
                    ServerControllerFactoryImpl.this.serverControllers.add(this);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized void stop() {
                List list = ServerControllerFactoryImpl.this.serverControllers;
                synchronized (list) {
                    ServerControllerFactoryImpl.this.serverControllers.remove(this);
                    for (Handler handler : ServerControllerFactoryImpl.this.handlers.keySet()) {
                        this.jettyServer.removeHandler(handler);
                    }
                    if (!ServerControllerFactoryImpl.this.customizers.isEmpty()) {
                        this.removeCustomizers(ServerControllerFactoryImpl.this.customizers.keySet());
                    }
                    super.stop();
                    for (Connector connector : ServerControllerFactoryImpl.this.connectors.keySet()) {
                        this.jettyServer.addConnector(connector);
                    }
                }
            }
        };
    }

    private static class ServiceMap<T>
    extends AbstractMap<T, Integer> {
        private Comparator<Map.Entry<T, Integer>> COMPARATOR = new ComparatorImpl();
        private List<Map.Entry<T, Integer>> entries = new ArrayList<Map.Entry<T, Integer>>();

        @Override
        public Set<Map.Entry<T, Integer>> entrySet() {
            return new AbstractSet<Map.Entry<T, Integer>>(){

                @Override
                public Iterator<Map.Entry<T, Integer>> iterator() {
                    return entries.iterator();
                }

                @Override
                public int size() {
                    return entries.size();
                }
            };
        }

        @Override
        public Integer put(T service, Integer ranking) {
            AbstractMap.SimpleImmutableEntry<T, Integer> entry = new AbstractMap.SimpleImmutableEntry<T, Integer>(service, ranking);
            this.entries.add(entry);
            Collections.sort(this.entries, this.COMPARATOR);
            return null;
        }

        private static class ComparatorImpl<T>
        implements Comparator<Map.Entry<T, Integer>> {
            private ComparatorImpl() {
            }

            @Override
            public int compare(Map.Entry<T, Integer> entry1, Map.Entry<T, Integer> entry2) {
                return entry1.getValue().compareTo(entry2.getValue());
            }
        }
    }
}

