/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.validation;

import java.util.Objects;

public class ValidationResult {
    private final Severity severity;
    private final String source;
    private final String message;

    public ValidationResult(Object source, Severity severity, String format, Object ... args) {
        this.source = source instanceof String ? (String)source : (source instanceof Class ? ((Class)source).getSimpleName() : (source != null ? source.getClass().getSimpleName() : null));
        this.severity = severity;
        this.message = String.format(format, args);
    }

    public String getSource() {
        return this.source;
    }

    public String getMessage() {
        return this.message;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public static ValidationResult error(Object source, String format, Object ... args) {
        return new ValidationResult(source, Severity.ERROR, format, args);
    }

    public static ValidationResult warn(Object source, String format, Object ... args) {
        return new ValidationResult(source, Severity.WARN, format, args);
    }

    public static ValidationResult info(Object source, String format, Object ... args) {
        return new ValidationResult(source, Severity.INFO, format, args);
    }

    public static ValidationResult debug(Object source, String format, Object ... args) {
        return new ValidationResult(source, Severity.DEBUG, format, args);
    }

    public static ValidationResult trace(Object source, String format, Object ... args) {
        return new ValidationResult(source, Severity.TRACE, format, args);
    }

    public boolean equals(Object other) {
        if (!(other instanceof ValidationResult)) {
            return false;
        }
        ValidationResult castOther = (ValidationResult)other;
        return Objects.equals((Object)this.severity, (Object)castOther.severity) && Objects.equals(this.source, castOther.source) && Objects.equals(this.message, castOther.message);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.severity, this.source, this.message});
    }

    public String toString() {
        return String.format("[%s] %s", this.source != null ? this.source : "<unknown>", this.message);
    }

    public static enum Severity {
        ERROR(5),
        WARN(4),
        INFO(3),
        DEBUG(2),
        TRACE(1);

        private final int level;

        private Severity(int level) {
            this.level = level;
        }

        public boolean isEquallyOrMoreSevereThan(Severity other) {
            return this.level >= other.level;
        }
    }
}

